<?php echo $__env->make('front.layout.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php if(session()->has('success')): ?>
    <div class="alert alert-danger alert-dismissible text-center"><button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button><?php echo e(session()->get('success')); ?></div> 
<?php endif; ?>
<?php if(session()->has('error')): ?>
    <div class="alert alert-danger alert-dismissible text-center"><button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button><?php echo e(session()->get('error')); ?></div> 
<?php endif; ?>
    <!-- Page Contain -->
    <div class="page-contain">
        <!-- Main content -->
        <div id="main-content" class="main-content">

            <!--Block 01: Main slide-->
            <div class="main-slide block-slider">
                <ul class="biolife-carousel nav-none-on-mobile" data-slick='{"arrows": true, "dots": false, "slidesMargin": 0, "slidesToShow": 1, "infinite": true, "speed": 800}' >
                    <?php $__currentLoopData = $sliders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $slider): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <li>
                        <div class="slide-contain slider-opt03__layout01">
                            <div class="media">
                                <div class="child-elememt">
                                    <a href="#" class="link-to">
                                        <img src="<?php echo e(url('storage/app/'.$slider->thumb)); ?>" width="604" height="580" alt="">
                                    </a>
                                </div>
                            </div>
                            <div class="text-content">
                                <i class="first-line">Alam</i>
                                <h3 class="second-line"><?php echo $slider->title; ?></h3>
                                <p class="third-line"><?php echo $slider->slider_content1; ?></p>
                                <p class="buttons">
                                    <a href="<?php echo e(url('/shop')); ?>" class="btn btn-bold">Shop now</a>
                                    <a href="<?php echo e($slider->slider_content2); ?>" class="btn btn-thin">View Hot Deals</a>
                                </p>
                            </div>
                        </div>
                    </li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </ul>
            </div>
           
            <div class="blog-posts sm-margin-top-93px sm-padding-top-72px xs-padding-bottom-50px">
                <div class="container">
                    <div class="biolife-title-box">
                        <span class="subtitle">The freshest and most Tender</span>
                        <h3 class="main-title">Meat Products.</h3>
                    </div>
                    <ul class="biolife-carousel nav-center nav-none-on-mobile xs-margin-top-36px" data-slick='{"rows":1,"arrows":true,"dots":false,"infinite":false,"speed":400,"slidesMargin":30,"slidesToShow":3, "responsive":[{"breakpoint":1200, "settings":{ "slidesToShow": 3}},{"breakpoint":992, "settings":{ "slidesToShow": 2}},{"breakpoint":768, "settings":{ "slidesToShow": 2}},{"breakpoint":600, "settings":{ "slidesToShow": 1}}]}'>
                        <?php $__currentLoopData = $adds->skip(1)->take(3); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $add): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <li>
                            <div class="post-item effect-01 style-bottom-info layout-02 ">
                                <div class="thumbnail">
                                    <a href="<?php echo e($add->category); ?>" class="link-to-post"><img src="<?php echo e(url('storage/app/'.$add->image)); ?>" width="370" height="270" alt="<?php echo e($add->title); ?>"></a>
                                    <div class="post-date">
                                        <span class="date"><?php echo e($add->title); ?></span>
                                    </div>
                                </div>
                                <div class="post-content">
                                    <h4 class="post-name"><a href="<?php echo e($add->category); ?>" class="linktopost"><?php echo e($add->title); ?></a></h4>
                                </div>
                            </div>
                        </li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                      
                    </ul>
                </div>
            </div>

            <!--Block 03: Featured Products-->
            <div class="product-tab z-index-20 sm-margin-top-193px xs-margin-top-30px">
                <div class="container">
                    <div class="biolife-title-box">
                        <span class="subtitle">All the best item for You</span>
                        <h3 class="main-title">Featured Products</h3>
                    </div>
                    <div class="biolife-tab biolife-tab-contain sm-margin-top-34px">
                        <div class="tab-head tab-head__icon-top-layout icon-top-layout">
            
                        </div>
                        <div class="tab-content">
                            <div id="tab01_1st" class="tab-contain active">
                                <ul class="products-list biolife-carousel nav-center-02 nav-none-on-mobile eq-height-contain" data-slick='{"rows":2 ,"arrows":true,"dots":false,"infinite":true,"speed":400,"slidesMargin":10,"slidesToShow":4, "responsive":[{"breakpoint":1200, "settings":{ "slidesToShow": 4}},{"breakpoint":992, "settings":{ "slidesToShow": 3, "slidesMargin":25 }},{"breakpoint":768, "settings":{ "slidesToShow": 2, "slidesMargin":15}}]}'>

                                   <?php $__currentLoopData = $featured_products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php $images = explode(",", $product->image);
                                    $primaryImage = isset($images[0]) ? $images[0] : '';
                                    $hoverImage = isset($images[1]) ? $images[1] : $primaryImage;?>
                                    <li class="product-item">
                                        <div class="contain-product layout-default">
                                            <div class="product-thumb">
                                                <a href="<?php echo e(url('/single-product')); ?>/<?php echo e($product->id); ?>" class="link-to-product">
                                                    <img src="<?php echo e(url('public/images/product', $primaryImage)); ?>" width="270" height="270" class="product-thumnail">
                                                </a>
                                                <a class="lookup btn_call_quickview" data-product="<?php echo e($product->id); ?>" href="#"><i class="biolife-icon icon-search"></i></a>

                                            </div>
                                            <div class="info">
                                                <?php $category = App\Category::find($product->category_id);?>
                                                <b class="categories"><?php echo e($category->name); ?></b>
                                                <h4 class="product-title"><a href="<?php echo e(url('/single-product')); ?>/<?php echo e($product->id); ?>" class="pr-name"><?php echo e($product->name); ?> </a></h4>
                                                <div class="price ">
                                                    <?php if($product->promotion_price != null): ?>
                                                    <ins><span class="price-amount"><span class="currencySymbol">£</span><?php echo e($product->promotion_price); ?></span></ins>

                                                    <del><span class="price-amount"><span class="currencySymbol">£</span><?php echo e($product->price); ?></span></del>
                                                    <?php else: ?>
                                                    
                                                    <ins><span class="price-amount"><span class="currencySymbol">£</span><?php echo e($product->price); ?></span></ins>
                                                    <?php endif; ?>
                                                </div>
                                                
                                                <div class="slide-down-box">
                                                    <div class="buttons">    
                                            <?php if($product->is_variant == null): ?>
                                                <?php if($product->qty > 0): ?>
                                                    <form id="addItem<?php echo e($product->id); ?>" action="<?php echo e(url('cart/addItem')); ?>" method="POST" class="variants add">
                                                    <?php echo csrf_field(); ?>
                                                        <input type="hidden" name="quantity" value="1">
                                                        <input type="hidden" name="product_id" value="<?php echo e($product->id); ?>">
                                                        <input type="hidden" name="name" value="<?php echo e($product->name); ?>">
                                                    <?php if($product->promotion_price != null): ?>
                                                        <input type="hidden" name="price" value="<?php echo e($product->promotion_price); ?>">
                                                    <?php else: ?>
                                                        <input type="hidden" name="price" value="<?php echo e($product->price); ?>">
                                                     
                                                    <?php endif; ?> 
                                                    </form>
                                                        <a href="javascript:void(0)" onclick="document.getElementById('addItem<?php echo e($product->id); ?>').submit();" class="btn add-to-cart-btn"><i class="fa fa-cart-arrow-down" aria-hidden="true"></i>Add to cart</a>
                                                <?php else: ?>
                                                        <a href="/single-product/${product.id}" class="btn add-to-cart-btn disabled">
                                                            <i class="fa fa-ban" aria-hidden="true"></i> Out Of Stock
                                                        </a>
                                                        
                                                <?php endif; ?>
                                                <?php else: ?>
                                                    <a href="/single-product/${product.id}" class="btn add-to-cart-btn">
                                                        <i class="fa fa-cart-arrow-down" aria-hidden="true"></i> Add To Cart
                                                    </a>
                                                <?php endif; ?>
                                                       
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </li>
                                   <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!--Block 04: Banner Promotion 01 -->
            <div class="banner-promotion-01 xs-margin-top-50px sm-margin-top-11px">
                <div class="biolife-banner promotion biolife-banner__promotion">
                    <div class="banner-contain">
                        <div class="media background-biolife-banner__promotion">
                            <div class="img-moving position-1">
                                <img src="<?php echo asset('public/front')?>/images/home-03/img-moving-pst-1.png" width="149" height="139" alt="img msv">
                            </div>
                            <div class="img-moving position-2">
                                <img src="<?php echo asset('public/front')?>/images/home-03/img-moving-pst-2.png" width="185" height="265" alt="img msv">
                            </div>
                            <div class="img-moving position-3">
                                <img src="<?php echo asset('public/front')?>/images/home-03/img-moving-pst-3-cut.png" width="384" height="151" alt="img msv">
                            </div>
                            <div class="img-moving position-4">
                                <img src="<?php echo asset('public/front')?>/images/home-03/img-moving-pst-4.png" width="198" height="269" alt="img msv">
                            </div>
                        </div>
                        <div class="text-content">
                            <div class="container text-wrap">
                                <i class="first-line">Healthy Fruit juice</i>
                                <span class="second-line">Vegetable Always fresh</span>
                                <p class="third-line">Food Heaven Made Easy sounds like the name of an amazingly delicious food delivery service, but don't be fooled...</p>
                                <div class="product-detail">
                                    <!-- <p class="txt-price"><span>Only:</span>$8.00</p> -->
                                    <a href="<?php echo e(url('/shop')); ?>" class="btn add-to-cart-btn">Shop</a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!--Block 05: Banner Promotion 02-->
            <div class="banner-promotion-02 z-index-20">
                <div class="biolife-banner promotion2 biolife-banner__promotion2">
                    <div class="banner-contain">
                        <div class="container">
                            <div class="media"></div>
                            <div class="text-content">
                                <b class="first-line">Food Heaven Made</b>
                                <span class="second-line">Easy <i>Healthy, Happy Life</i></span>
                                <p class="third-line">Food Heaven Made Easy sounds like the name of an amazingly delicious food delivery service, but don't be fooled. The blog is actually a compilation of recipes, cooking videos, and nutrition tips.</p>
                                <p class="buttons">
                                    <a href="<?php echo e(url('/shop')); ?>" class="btn btn-bold">Deals</a>
                                    <!-- <a href="#" class="btn btn-thin">View Menu Now</a> -->
                                </p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!--Block 06: Products fresh vegetables-->
            <?php if($deal_products != null): ?>
            <div class="Product-box sm-margin-top-96px xs-margin-top-0">
                <div class="container">
                    <div class="row">
                        <div class="col-lg-4 col-md-5 col-sm-6">
                            <div class="advance-product-box">
                                <div class="biolife-title-box bold-style biolife-title-box__bold-style">
                                    <h3 class="title">Deals of the day</h3>
                                </div>
                                <ul class="products biolife-carousel nav-top-right nav-none-on-mobile" data-slick='{"arrows":true, "dots":false, "infinite":false, "speed":400, "slidesMargin":30, "slidesToShow":1}'>
                                    <?php $__currentLoopData = $deal_products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                                        <?php $images = explode(",", $product->image);
                                        $primaryImage = isset($images[0]) ? $images[0] : '';
                                        $hoverImage = isset($images[1]) ? $images[1] : $primaryImage;?>
                                    <li class="product-item">
                                        <div class="contain-product deal-layout contain-product__deal-layout">
                                            <div class="product-thumb">
                                                <a href="<?php echo e(url('/single-product')); ?>/<?php echo e($product->id); ?>" class="link-to-product">
                                                    <img src="<?php echo e(url('public/images/product', $primaryImage)); ?>" alt="dd" width="330" height="330" class="product-thumnail">
                                                </a>
                                                <div class="labels">
                                                    <span class="sale-label"></span>
                                                </div>
                                            </div>
                                            <div class="info">
                                                <div class="biolife-countdown" data-datetime="<?php echo e(\Carbon\Carbon::parse($product->last_date)->format('Y/m/d')); ?>"></div>
                                                
                                                <?php $category = App\Category::find($product->category_id);?>
                                                <b class="categories"><?php echo e($category->name); ?></b>
                                                <h4 class="product-title"><a href="<?php echo e(url('/single-product')); ?>/<?php echo e($product->id); ?>" class="pr-name"><?php echo e($product->name); ?> </a></h4>
                                                <div class="price ">
                                                    <?php if($product->promotion_price != null): ?>
                                                    <ins><span class="price-amount"><span class="currencySymbol">£</span><?php echo e($product->promotion_price); ?></span></ins>

                                                    <del><span class="price-amount"><span class="currencySymbol">£</span><?php echo e($product->price); ?></span></del>
                                                    <?php else: ?>
                                                    
                                                    <ins><span class="price-amount"><span class="currencySymbol">£</span><?php echo e($product->price); ?></span></ins>
                                                    <?php endif; ?>
                                                </div>

                                                <div class="slide-down-box">
                                                    <div class="buttons">    
                                            <?php if($product->is_variant == null): ?>
                                                <?php if($product->qty > 0): ?>
                                                    <form id="addItem<?php echo e($product->id); ?>" action="<?php echo e(url('cart/addItem')); ?>" method="POST" class="variants add">
                                                    <?php echo csrf_field(); ?>
                                                        <input type="hidden" name="quantity" value="1">
                                                        <input type="hidden" name="product_id" value="<?php echo e($product->id); ?>">
                                                        <input type="hidden" name="name" value="<?php echo e($product->name); ?>">
                                                    <?php if($product->promotion_price != null): ?>
                                                        <input type="hidden" name="price" value="<?php echo e($product->promotion_price); ?>">
                                                    <?php else: ?>
                                                        <input type="hidden" name="price" value="<?php echo e($product->price); ?>">
                                                     
                                                    <?php endif; ?> 
                                                    </form>
                                                        <a href="javascript:void(0)" onclick="document.getElementById('addItem<?php echo e($product->id); ?>').submit();" class="btn add-to-cart-btn" style="width: 100%; min-height: 20px; white-space: nowrap; display: inline-block; box-sizing: border-box; text-align: center; line-height: 20px;" ><i class="fa fa-cart-arrow-down" aria-hidden="true"></i> Add to cart</a>
                                                <?php else: ?>
                                                        <a href="/single-product/${product.id}" class="btn add-to-cart-btn disabled">
                                                            <i class="fa fa-ban" aria-hidden="true"></i> Out Of Stock
                                                        </a>
                                                        
                                                <?php endif; ?>
                                                <?php else: ?>
                                                    <a href="/single-product/${product.id}" class="btn add-to-cart-btn">
                                                        <i class="fa fa-cart-arrow-down" aria-hidden="true"></i> Add To Cart
                                                    </a>
                                                <?php endif; ?>
                                                       
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </ul>
                            </div>
                        </div>
                        <div class="col-lg-8 col-md-7 col-sm-6">
                            <div class="advance-product-box">
                                <div class="biolife-title-box bold-style biolife-title-box__bold-style">
                                    <h3 class="title">Hot Deals Products</h3>
                                </div>
                                <ul class="products biolife-carousel eq-height-contain nav-center-03 nav-none-on-mobile row-space-29px" data-slick='{"rows":2,"arrows":true,"dots":false,"infinite":false,"speed":400,"slidesMargin":30,"slidesToShow":2,"responsive":[{"breakpoint":1200,"settings":{ "rows":2, "slidesToShow": 2}},{"breakpoint":992, "settings":{ "rows":2, "slidesToShow": 1}},{"breakpoint":768, "settings":{ "rows":2, "slidesToShow": 2}},{"breakpoint":500, "settings":{ "rows":2, "slidesToShow": 1}}]}'>

                                    <?php $__currentLoopData = $deal_products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <li class="product-item">
                                        <div class="contain-product right-info-layout contain-product__right-info-layout">
                                            <div class="product-thumb">
                                                <a href="<?php echo e(url('/single-product')); ?>/<?php echo e($product->id); ?>" class="link-to-product">
                                                <?php $images = explode(",", $product->image);
                                        $primaryImage = isset($images[0]) ? $images[0] : '';
                                        $hoverImage = isset($images[1]) ? $images[1] : $primaryImage;?>
                                            
                                                    <img src="<?php echo e(url('public/images/product', $primaryImage)); ?>" alt="dd" width="270" height="270" class="product-thumnail">
                                                </a>
                                            </div>
                                            <div class="info">
                                                <?php $category = App\Category::find($product->category_id);?>
                                                <b class="categories"><?php echo e($category->name); ?></b>
                                                <h4 class="product-title"><a href="<?php echo e(url('/single-product')); ?>/<?php echo e($product->id); ?>" class="pr-name"><?php echo e($product->name); ?></a></h4>
                                                <div class="price ">
                                                    <?php if($product->promotion_price != null): ?>
                                                    <ins><span class="price-amount"><span class="currencySymbol">£</span><?php echo e($product->promotion_price); ?></span></ins>

                                                    <del><span class="price-amount"><span class="currencySymbol">£</span><?php echo e($product->price); ?></span></del>
                                                    <?php else: ?>
                                                    
                                                    <ins><span class="price-amount"><span class="currencySymbol">£</span><?php echo e($product->price); ?></span></ins>
                                                    <?php endif; ?>
                                                </div>
                                                <?php
                                                    $reviews = App\Review::where('product_id', $product->id)->get();
                                                    $number = $reviews->count();
                                                    $totalStars = $reviews->sum('stars');
                                                    $averageRating = $number > 0 ? $totalStars / $number : 0;
                                                    $ratingPercent = round($averageRating * 20); // e.g. 4.5 * 20 = 90
                                                    $ratingClass = "width-{$ratingPercent}percent"; // will become width-90percent etc.
                                                ?>
                                                <div class="rating">
                                                    <p class="star-rating">
                                                        <span class="<?php echo e($ratingClass); ?>"></span>
                                                    </p>
                                                    <span class="review-count">(<?php echo e($reviews->count()); ?> Reviews)</span>
                                                </div>
                                            </div>
                                        </div>
                                    </li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </ul>
                                <div class="biolife-banner style-01 biolife-banner__style-01 xs-margin-top-80px-im sm-margin-top-30px-im">
                                    <div class="banner-contain">
                                        <a href="#" class="bn-link"></a>
                                        <div class="text-content">
                                            <span class="first-line">Daily Fresh</span>
                                            <b class="second-line">Natural</b>
                                            <i class="third-line">Fresh Food</i>
                                            <span class="fourth-line">Premium Quality</span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <?php endif; ?>

            <div class="product-tab z-index-20 sm-margin-top-193px xs-margin-top-30px">
                <div class="container">
                    <div class="biolife-title-box">
                        <span class="subtitle">All the best item for You</span>
                        <h3 class="main-title">Fresh Vegetables</h3>
                    </div>
                    <div class="biolife-tab biolife-tab-contain sm-margin-top-34px">
                        <div class="tab-head tab-head__icon-top-layout icon-top-layout">
            
                        </div>
                        <div class="tab-content">
                            <div id="tab01_1st" class="tab-contain active">
                                <ul class="products-list biolife-carousel nav-center-02 nav-none-on-mobile eq-height-contain" data-slick='{"rows":2 ,"arrows":true,"dots":false,"infinite":true,"speed":400,"slidesMargin":10,"slidesToShow":4, "responsive":[{"breakpoint":1200, "settings":{ "slidesToShow": 4}},{"breakpoint":992, "settings":{ "slidesToShow": 3, "slidesMargin":25 }},{"breakpoint":768, "settings":{ "slidesToShow": 2, "slidesMargin":15}}]}'>

                                   <?php $__currentLoopData = $vegetable_products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>



                                    <?php $images = explode(",", $product->image);
                                    $primaryImage = isset($images[0]) ? $images[0] : '';
                                    $hoverImage = isset($images[1]) ? $images[1] : $primaryImage;?>
                                    <li class="product-item">
                                        <div class="contain-product layout-default">
                                            <div class="product-thumb">
                                                <a href="<?php echo e(url('/single-product')); ?>/<?php echo e($product->id); ?>" class="link-to-product">
                                                    <img src="<?php echo e(url('public/images/product', $primaryImage)); ?>" width="270" height="270" class="product-thumnail">
                                                </a>
                                                <a class="lookup btn_call_quickview" data-product="<?php echo e($product->id); ?>" href="#"><i class="biolife-icon icon-search"></i></a>
                                            </div>
                                            <div class="info">
                                                <?php $category = App\Category::find($product->category_id);?>
                                                <b class="categories"><?php echo e($category->name); ?></b>
                                                <h4 class="product-title"><a href="<?php echo e(url('/single-product')); ?>/<?php echo e($product->id); ?>" class="pr-name"><?php echo e($product->name); ?> </a></h4>
                                                <div class="price ">
                                                    <?php if($product->promotion_price != null): ?>
                                                    <ins><span class="price-amount"><span class="currencySymbol">£</span><?php echo e($product->promotion_price); ?></span></ins>

                                                    <del><span class="price-amount"><span class="currencySymbol">£</span><?php echo e($product->price); ?></span></del>
                                                    <?php else: ?>
                                                    
                                                    <ins><span class="price-amount"><span class="currencySymbol">£</span><?php echo e($product->price); ?></span></ins>
                                                    <?php endif; ?>
                                                </div>
                                                <div class="slide-down-box">
                                                    <div class="buttons">    
                                            <?php if($product->is_variant == null): ?>
                                                <?php if($product->qty > 0): ?>
                                                    <form id="addItem<?php echo e($product->id); ?>" action="<?php echo e(url('cart/addItem')); ?>" method="POST" class="variants add">
                                                    <?php echo csrf_field(); ?>
                                                        <input type="hidden" name="quantity" value="1">
                                                        <input type="hidden" name="product_id" value="<?php echo e($product->id); ?>">
                                                        <input type="hidden" name="name" value="<?php echo e($product->name); ?>">
                                                    <?php if($product->promotion_price != null): ?>
                                                        <input type="hidden" name="price" value="<?php echo e($product->promotion_price); ?>">
                                                    <?php else: ?>
                                                        <input type="hidden" name="price" value="<?php echo e($product->price); ?>"> 
                                                    <?php endif; ?> 
                                                    </form>
                                                        <a href="javascript:void(0)" onclick="document.getElementById('addItem<?php echo e($product->id); ?>').submit();" class="btn add-to-cart-btn"><i class="fa fa-cart-arrow-down" aria-hidden="true"></i>Add to cart</a>
                                                <?php else: ?>
                                                        <a href="/single-product/${product.id}" class="btn add-to-cart-btn disabled">
                                                            <i class="fa fa-ban" aria-hidden="true"></i> Out Of Stock
                                                        </a>
                                                        
                                                <?php endif; ?>
                                                <?php else: ?>
                                                    <a href="/single-product/${product.id}" class="btn add-to-cart-btn">
                                                        <i class="fa fa-cart-arrow-down" aria-hidden="true"></i> Add To Cart
                                                    </a>
                                                <?php endif; ?>
                                                       
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </li>
                                   <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- frozen foods -->
            <div class="product-tab z-index-20 sm-margin-top-193px xs-margin-top-30px">
                <div class="container">
                    <div class="biolife-title-box">
                        <span class="subtitle">All the best item for You</span>
                        <h3 class="main-title">Meats Foods</h3>
                    </div>
                    <div class="biolife-tab biolife-tab-contain sm-margin-top-34px">
                        <div class="tab-head tab-head__icon-top-layout icon-top-layout">
            
                        </div>
                        <div class="tab-content">
                            <div id="tab01_1st" class="tab-contain active">
                                <ul class="products-list biolife-carousel nav-center-02 nav-none-on-mobile eq-height-contain" data-slick='{"rows":2 ,"arrows":true,"dots":false,"infinite":true,"speed":400,"slidesMargin":10,"slidesToShow":4, "responsive":[{"breakpoint":1200, "settings":{ "slidesToShow": 4}},{"breakpoint":992, "settings":{ "slidesToShow": 3, "slidesMargin":25 }},{"breakpoint":768, "settings":{ "slidesToShow": 2, "slidesMargin":15}}]}'>

                                   <?php $__currentLoopData = $meat_products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>



                                    <?php $images = explode(",", $product->image);
                                    $primaryImage = isset($images[0]) ? $images[0] : '';
                                    $hoverImage = isset($images[1]) ? $images[1] : $primaryImage;?>
                                    <li class="product-item">
                                        <div class="contain-product layout-default">
                                            <div class="product-thumb">
                                                <a href="<?php echo e(url('/single-product')); ?>/<?php echo e($product->id); ?>" class="link-to-product">
                                                    <img src="<?php echo e(url('public/images/product', $primaryImage)); ?>" width="270" height="270" class="product-thumnail">
                                                </a>
                                                <a class="lookup btn_call_quickview" data-product="<?php echo e($product->id); ?>" href="#"><i class="biolife-icon icon-search"></i></a>
                                            </div>
                                            <div class="info">
                                                <?php $category = App\Category::find($product->category_id);?>
                                                <b class="categories"><?php echo e($category->name); ?></b>
                                                <h4 class="product-title"><a href="#" class="pr-name"><?php echo e($product->name); ?> </a></h4>
                                                <div class="price ">
                                                    <?php if($product->promotion_price != null): ?>
                                                    <ins><span class="price-amount"><span class="currencySymbol">£</span><?php echo e($product->promotion_price); ?></span></ins>

                                                    <del><span class="price-amount"><span class="currencySymbol">£</span><?php echo e($product->price); ?></span></del>
                                                    <?php else: ?>
                                                    
                                                    <ins><span class="price-amount"><span class="currencySymbol">£</span><?php echo e($product->price); ?></span></ins>
                                                    <?php endif; ?>
                                                </div>
                                                <div class="slide-down-box">
                                                    <div class="buttons">    
                                            <?php if($product->is_variant == null): ?>
                                                <?php if($product->qty > 0): ?>
                                                    <form id="addItem<?php echo e($product->id); ?>" action="<?php echo e(url('cart/addItem')); ?>" method="POST" class="variants add">
                                                    <?php echo csrf_field(); ?>
                                                        <input type="hidden" name="quantity" value="1">
                                                        <input type="hidden" name="product_id" value="<?php echo e($product->id); ?>">
                                                        <input type="hidden" name="name" value="<?php echo e($product->name); ?>">
                                                    <?php if($product->promotion_price != null): ?>
                                                        <input type="hidden" name="price" value="<?php echo e($product->promotion_price); ?>">
                                                    <?php else: ?>
                                                        <input type="hidden" name="price" value="<?php echo e($product->price); ?>">
                                                    
                                                    <?php endif; ?> 
                                                    </form> 
                                                        <a href="javascript:void(0)" onclick="document.getElementById('addItem<?php echo e($product->id); ?>').submit();" class="btn add-to-cart-btn"><i class="fa fa-cart-arrow-down" aria-hidden="true"></i>Add to cart</a>
                                                <?php else: ?>
                                                        <a href="/single-product/${product.id}" class="btn add-to-cart-btn disabled">
                                                            <i class="fa fa-ban" aria-hidden="true"></i> Out Of Stock
                                                        </a>
                                                        
                                                <?php endif; ?>
                                                <?php else: ?>
                                                    <a href="/single-product/${product.id}" class="btn add-to-cart-btn">
                                                        <i class="fa fa-cart-arrow-down" aria-hidden="true"></i> Add To Cart
                                                    </a>
                                                <?php endif; ?>
                                                       
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </li>
                                   <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- frozen foods -->
            <div class="product-tab z-index-20 sm-margin-top-193px xs-margin-top-30px">
                <div class="container">
                    <div class="biolife-title-box">
                        <span class="subtitle">All the best item for You</span>
                        <h3 class="main-title">Frozen Foods</h3>
                    </div>
                    <div class="biolife-tab biolife-tab-contain sm-margin-top-34px">
                        <div class="tab-head tab-head__icon-top-layout icon-top-layout">
            
                        </div>
                        <div class="tab-content">
                            <div id="tab01_1st" class="tab-contain active">
                                <ul class="products-list biolife-carousel nav-center-02 nav-none-on-mobile eq-height-contain" data-slick='{"rows":2 ,"arrows":true,"dots":false,"infinite":true,"speed":400,"slidesMargin":10,"slidesToShow":4, "responsive":[{"breakpoint":1200, "settings":{ "slidesToShow": 4}},{"breakpoint":992, "settings":{ "slidesToShow": 3, "slidesMargin":25 }},{"breakpoint":768, "settings":{ "slidesToShow": 2, "slidesMargin":15}}]}'>

                                   <?php $__currentLoopData = $frozen_products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>



                                    <?php $images = explode(",", $product->image);
                                    $primaryImage = isset($images[0]) ? $images[0] : '';
                                    $hoverImage = isset($images[1]) ? $images[1] : $primaryImage;?>
                                    <li class="product-item">
                                        <div class="contain-product layout-default">
                                            <div class="product-thumb">
                                                <a href="<?php echo e(url('/single-product')); ?>/<?php echo e($product->id); ?>" class="link-to-product">
                                                    <img src="<?php echo e(url('public/images/product', $primaryImage)); ?>" width="270" height="270" class="product-thumnail">
                                                </a>
                                                <a class="lookup btn_call_quickview" data-product="<?php echo e($product->id); ?>" href="#"><i class="biolife-icon icon-search"></i></a>
                                            </div>
                                            <div class="info">
                                                <?php $category = App\Category::find($product->category_id);?>
                                                <b class="categories"><?php echo e($category->name); ?></b>
                                                <h4 class="product-title"><a href="#" class="pr-name"><?php echo e($product->name); ?> </a></h4>
                                                <div class="price ">
                                                    <?php if($product->promotion_price != null): ?>
                                                    <ins><span class="price-amount"><span class="currencySymbol">£</span><?php echo e($product->promotion_price); ?></span></ins>

                                                    <del><span class="price-amount"><span class="currencySymbol">£</span><?php echo e($product->price); ?></span></del>
                                                    <?php else: ?>
                                                    
                                                    <ins><span class="price-amount"><span class="currencySymbol">£</span><?php echo e($product->price); ?></span></ins>
                                                    <?php endif; ?>
                                                </div>
                                                <div class="slide-down-box">
                                                    <div class="buttons">    
                                            <?php if($product->is_variant == null): ?>
                                                <?php if($product->qty > 0): ?>
                                                    <form id="addItem<?php echo e($product->id); ?>" action="<?php echo e(url('cart/addItem')); ?>" method="POST" class="variants add">
                                                    <?php echo csrf_field(); ?>
                                                        <input type="hidden" name="quantity" value="1">
                                                        <input type="hidden" name="product_id" value="<?php echo e($product->id); ?>">
                                                        <input type="hidden" name="name" value="<?php echo e($product->name); ?>">
                                                    <?php if($product->promotion_price != null): ?>
                                                        <input type="hidden" name="price" value="<?php echo e($product->promotion_price); ?>">
                                                    <?php else: ?>
                                                        <input type="hidden" name="price" value="<?php echo e($product->price); ?>">
                                                     
                                                    <?php endif; ?> 
                                                    </form>
                                                        <a href="javascript:void(0)" onclick="document.getElementById('addItem<?php echo e($product->id); ?>').submit();" class="btn add-to-cart-btn"><i class="fa fa-cart-arrow-down" aria-hidden="true"></i>Add to cart</a>
                                                <?php else: ?>
                                                        <a href="/single-product/${product.id}" class="btn add-to-cart-btn disabled">
                                                            <i class="fa fa-ban" aria-hidden="true"></i> Out Of Stock
                                                        </a>
                                                        
                                                <?php endif; ?>
                                                <?php else: ?>
                                                    <a href="/single-product/${product.id}" class="btn add-to-cart-btn">
                                                        <i class="fa fa-cart-arrow-down" aria-hidden="true"></i> Add To Cart
                                                    </a>
                                                <?php endif; ?>
                                                       
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </li>
                                   <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!--Block 07: Brands
            <div class="brand-slide sm-margin-top-100px background-fafafa xs-margin-top-80px xs-margin-bottom-80px">
                <div class="container">
                    <ul class="biolife-carousel nav-center-bold nav-none-on-mobile" data-slick='{"rows":1,"arrows":true,"dots":false,"infinite":false,"speed":400,"slidesMargin":30,"slidesToShow":4, "responsive":[{"breakpoint":1200, "settings":{ "slidesToShow": 4}},{"breakpoint":992, "settings":{ "slidesToShow": 3}},{"breakpoint":768, "settings":{ "slidesToShow": 2, "slidesMargin":10}},{"breakpoint":450, "settings":{ "slidesToShow": 1, "slidesMargin":10}}]}'>
                        <li>
                            <div class="biolife-brd-container">
                                <a href="#" class="link">
                                    <figure><img src="<?php echo asset('public/front')?>/images/home-03/brd-01.jpg" width="214" height="163" alt=""></figure>
                                </a>
                            </div>
                        </li>
                        <li>
                            <div class="biolife-brd-container">
                                <a href="#" class="link">
                                    <figure><img src="<?php echo asset('public/front')?>/images/home-03/brd-02.jpg" width="214" height="163" alt=""></figure>
                                </a>
                            </div>
                        </li>
                        <li>
                            <div class="biolife-brd-container">
                                <a href="#" class="link">
                                    <figure><img src="<?php echo asset('public/front')?>/images/home-03/brd-03.jpg" width="153" height="163" alt=""></figure>
                                </a>
                            </div>
                        </li>
                        <li>
                            <div class="biolife-brd-container">
                                <a href="#" class="link">
                                    <figure><img src="<?php echo asset('public/front')?>/images/home-03/brd-04.jpg" width="224" height="163" alt=""></figure>
                                </a>
                            </div>
                        </li>
                        <li>
                            <div class="biolife-brd-container">
                                <a href="#" class="link">
                                    <figure><img src="<?php echo asset('public/front')?>/images/home-03/brd-01.jpg" width="214" height="163" alt=""></figure>
                                </a>
                            </div>
                        </li>
                        <li>
                            <div class="biolife-brd-container">
                                <a href="#" class="link">
                                    <figure><img src="<?php echo asset('public/front')?>/images/home-03/brd-02.jpg" width="214" height="163" alt=""></figure>
                                </a>
                            </div>
                        </li>
                        <li>
                            <div class="biolife-brd-container">
                                <a href="#" class="link">
                                    <figure><img src="<?php echo asset('public/front')?>/images/home-03/brd-03.jpg" width="153" height="163" alt=""></figure>
                                </a>
                            </div>
                        </li>
                        <li>
                            <div class="biolife-brd-container">
                                <a href="#" class="link">
                                    <figure><img src="<?php echo asset('public/front')?>/images/home-03/brd-04.jpg" width="224" height="163" alt=""></figure>
                                </a>
                            </div>
                        </li>
                    </ul>
                </div>
            </div>-->

            <!--Block 08: Blog Posts-->
            <div class="blog-posts sm-margin-top-93px sm-padding-top-72px xs-padding-bottom-50px">
                <div class="container">
                    <div class="biolife-title-box">
                        <span class="subtitle">The freshest and most exciting varities</span>
                        <h3 class="main-title">All Categories</h3>
                    </div>
                    <ul class="biolife-carousel nav-center nav-none-on-mobile xs-margin-top-36px" data-slick='{"rows":1,"arrows":true,"dots":false,"infinite":false,"speed":400,"slidesMargin":30,"slidesToShow":3, "responsive":[{"breakpoint":1200, "settings":{ "slidesToShow": 3}},{"breakpoint":992, "settings":{ "slidesToShow": 2}},{"breakpoint":768, "settings":{ "slidesToShow": 2}},{"breakpoint":600, "settings":{ "slidesToShow": 1}}]}'>
                        
                        <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <li>
                            <div class="post-item effect-01 style-bottom-info layout-02 ">
                                <div class="thumbnail">
                                    <a href="<?php echo e(url('/shop_by_id/' . $category->id)); ?>" class="link-to-post"><img src="<?php echo e(url('public/images/category/'.$category->image)); ?>" width="370" height="270" alt=""></a>
                                    <div class="post-date">
                                        <span class="date"><?php echo e($category->name); ?></span>
                                    </div>
                                </div>
                                <div class="post-content">
                                    <h4 class="post-name"><a href="<?php echo e(url('/shop_by_id/' . $category->id)); ?>" class="linktopost"><?php echo e($category->name); ?></a></h4>
                                </div>
                            </div>
                        </li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        
                    </ul>
                </div>
            </div>

        </div>

    </div>

<?php echo $__env->make('front.layout.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <?php /**PATH /home/mamusxqr/alamminimarket.co.uk/resources/views/front/index.blade.php ENDPATH**/ ?>