<!DOCTYPE html>
<html class="no-js" lang="en">

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <title><?php echo e($general_setting->site_title); ?></title>
    <?php echo SEOTools::generate(); ?>

    <?php if(!empty($customHeadScript)): ?>
        <?php echo $customHeadScript; ?>

    <?php endif; ?>

    <!-- for seo -->
    <?php $site = \App\SiteSetting::first(); ?>

    <?php if(!empty($site->google_search_console_meta)): ?>
        <meta name="google-site-verification" content="<?php echo e($site->google_search_console_meta); ?>">
    <?php endif; ?>

    <?php if(!empty($site->bing_webmaster_meta)): ?>
        <meta name="msvalidate.01" content="<?php echo e($site->bing_webmaster_meta); ?>">
    <?php endif; ?>

    <?php if(!empty($site->yandex_webmaster_meta)): ?>
        <meta name="yandex-verification" content="<?php echo e($site->yandex_webmaster_meta); ?>">
    <?php endif; ?>

    <?php if(!empty($site->google_analytics_id)): ?>
        <!-- Global site tag (gtag.js) - Google Analytics -->
        <script async src="https://www.googletagmanager.com/gtag/js?id=<?php echo e($site->google_analytics_id); ?>"></script>
        <script>
            window.dataLayer = window.dataLayer || [];
            function gtag(){dataLayer.push(arguments);}
            gtag('js', new Date());
            gtag('config', '<?php echo e($site->google_analytics_id); ?>');
        </script>
    <?php endif; ?>

    <?php if(!empty($site->google_tag_manager_id)): ?>
        <!-- Google Tag Manager -->
        <script>
            (function(w,d,s,l,i){w[l]=w[l]||[];w[l].push({'gtm.start':
            new Date().getTime(),event:'gtm.js'});var f=d.getElementsByTagName(s)[0],
            j=d.createElement(s),dl=l!='dataLayer'?'&l='+l:'';j.async=true;j.src=
            'https://www.googletagmanager.com/gtm.js?id='+i+dl;f.parentNode.insertBefore(j,f);
            })(window,document,'script','dataLayer','<?php echo e($site->google_tag_manager_id); ?>');
        </script>
    <?php endif; ?>

    <?php if(!empty($site->facebook_pixel_id)): ?>
        <!-- Facebook Pixel Code -->
        <script>
            !function(f,b,e,v,n,t,s){if(f.fbq)return;n=f.fbq=function(){n.callMethod?
            n.callMethod.apply(n,arguments):n.queue.push(arguments)};if(!f._fbq)f._fbq=n;
            n.push=n;n.loaded=!0;n.version='2.0';n.queue=[];t=b.createElement(e);t.async=!0;
            t.src=v;s=b.getElementsByTagName(e)[0];s.parentNode.insertBefore(t,s)}
            (window, document,'script','https://connect.facebook.net/en_US/fbevents.js');
            fbq('init', '<?php echo e($site->facebook_pixel_id); ?>');
            fbq('track', 'PageView');
        </script>
        <noscript>
            <img height="1" width="1" style="display:none"
                src="https://www.facebook.com/tr?id=<?php echo e($site->facebook_pixel_id); ?>&ev=PageView&noscript=1"/>
        </noscript>
    <?php endif; ?>

    <?php if(!empty($site->twitter_pixel_id)): ?>
        <!-- Twitter Pixel -->
        <script>
            !function(e,t,n,s,u,a){e.twq||(s=e.twq=function(){s.exe?s.exe.apply(s,arguments):s.queue.push(arguments);
            },s.version='1.1',s.queue=[],u=t.createElement(n),u.async=!0,u.src='//static.ads-twitter.com/uwt.js',
            a=t.getElementsByTagName(n)[0],a.parentNode.insertBefore(u,a))}(window,document,'script');
            twq('init','<?php echo e($site->twitter_pixel_id); ?>');
            twq('track','PageView');
        </script>
    <?php endif; ?>

    <?php if(!empty($site->custom_head_scripts)): ?>
        <?php echo $site->custom_head_scripts; ?>

    <?php endif; ?>

    <!-- seo ends -->
    <link href="https://fonts.googleapis.com/css?family=Cairo:400,600,700&amp;display=swap" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css?family=Poppins:600&amp;display=swap" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css?family=Playfair+Display:400i,700i" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css?family=Ubuntu&amp;display=swap" rel="stylesheet">
    <link rel="shortcut icon" type="image/x-icon" href="<?php echo asset('public/front/images/favicon.png') ?>"/>
    <link rel="stylesheet" href="<?php echo asset('public/front/css/font-awesome.min.css') ?>">

    <link rel="stylesheet" type="text/css" href="<?php echo asset('public/front/css/bootstrap.min.css') ?>">
    <link rel="stylesheet" type="text/css" href="<?php echo asset('public/front/css/animate.min.css') ?>">
    <link rel="stylesheet" type="text/css" href="<?php echo asset('public/front/css/font-awesome.min.css') ?>">
    <link rel="stylesheet" type="text/css" href="<?php echo asset('public/front/css/nice-select.css') ?>">
    <link rel="stylesheet" type="text/css" href="<?php echo asset('public/front/css/slick.min.css') ?>">
    <link rel="stylesheet" type="text/css" href="<?php echo asset('public/front/css/style.css') ?>">
    <link rel="stylesheet" type="text/css" href="<?php echo asset('public/front/css/main-color.css') ?>">

</head>
<body class="biolife-body">
    <!-- seo body script -->
    <?php if(!empty($site->google_tag_manager_id)): ?>
        <!-- Google Tag Manager (noscript) -->
        <noscript>
            <iframe src="https://www.googletagmanager.com/ns.html?id=<?php echo e($site->google_tag_manager_id); ?>"
                    height="0" width="0" style="display:none;visibility:hidden"></iframe>
        </noscript>
    <?php endif; ?>

    <?php if(!empty($site->custom_body_scripts)): ?>
        <?php echo $site->custom_body_scripts; ?>

    <?php endif; ?>

    <!-- Preloader -->
    <div id="biof-loading">
        <div class="biof-loading-center">
            <div class="biof-loading-center-absolute">
                <div class="dot dot-one"></div>
                <div class="dot dot-two"></div>
                <div class="dot dot-three"></div>
            </div>
        </div>
    </div>

    <!-- HEADER -->
    <header id="header" class="header-area style-01 layout-03">
        <div class="header-top bg-main hidden-xs">
            <div class="container">
                <div class="top-bar left">
                    <ul class="horizontal-menu">
                        <li><a href="mailto:<?php echo e($info->mail); ?>"><i class="fa fa-envelope" aria-hidden="true"></i><?php echo e($info->mail); ?></a></li>
                        <li><a href="call:+447411039260">Order Now <?php echo e($info->phone); ?></a></li>
                    </ul>
                </div>
                <div class="top-bar right">
                    <ul class="social-list">
                        <li><a href="<?php echo e($info->ss2); ?>" target="_blank"><i class="fa fa-youtube" aria-hidden="true"></i></a></li>
                        <li><a href="<?php echo e($info->facebook); ?>" target="_blank"><i class="fa fa-facebook" aria-hidden="true"></i></a></li>
                        <li><a href="<?php echo e($info->ss3); ?>" target="_blank"><i class="fa fa-instagram" aria-hidden="true"></i></a></li>
                    </ul>
                    <ul class="horizontal-menu">
                        <?php if(auth()->guard()->guest()): ?>
                            <li><a href="<?php echo e(route('login')); ?>" class="login-link"><i class="biolife-icon icon-login"></i>Login</a></li>
                            <li><a href="<?php echo e(route('register')); ?>"><i class="biolife-icon icon-login"></i>Register</a></li>
                        <?php else: ?>
                    <?php if(Auth::user()->role_id == 5): ?>
                        <li><a href="<?php echo e(url('/customer_account')); ?>"><i class="biolife-icon icon-login"></i>User Profile</a></li>
                    <?php endif; ?>
                    <?php if(Auth::user()->role_id != 5): ?>
                        <li><a href="<?php echo e(url('/home')); ?>"><i class="biolife-icon icon-login"></i>Dashboard</a></li>
                    <?php endif; ?>
                        <li><a href="<?php echo e(route('logout')); ?>"
                                onclick="event.preventDefault();
                                document.getElementById('logout-form').submit();"><i class="biolife-icon icon-login"></i>
                                <?php echo e(__('Logout')); ?></a>
                                <form id="logout-form" action="<?php echo e(route('logout')); ?>" method="POST" style="display: none;">
                                    <?php echo csrf_field(); ?>
                                </form>
                        </li>
                    <?php endif; ?>
                    </ul>
                </div>
            </div>
        </div>
        <div class="header-middle biolife-sticky-object ">
            <div class="container">
                <div class="row">
                    <div class="col-lg-3 col-md-2 col-md-6 col-xs-6">
                        <a href="<?php echo e(url('/')); ?>" class="biolife-logo">
                            <img src="<?php echo e(url('public/logo', $general_setting->site_logo)); ?>" alt="Alamminimarket" width="135" height="34">
                            </a>
                    </div>
                    <div class="col-lg-6 col-md-7 hidden-sm hidden-xs">
                        <div class="primary-menu">
                        <ul class="menu biolife-menu clone-main-menu clone-primary-menu" id="primary-menu" data-menuname="main menu">
                            <li class="menu-item"><a style="<?php echo e(Request::is('/') ? 'color:#e73917;' : ''); ?>" href="<?php echo e(url('/')); ?>">Home</a></li>
                            <?php 
                            $about = App\Page::orderBy('created_at', 'asc')->first();?>
                                        
                            <li>
                                <a href="<?php echo e(url('pages/' . $about->id)); ?>" style="<?php echo e(Request::is('pages/' . $about->id) ? 'color:#e73917;' : ''); ?>">
                                    About Us
                                </a>
                            </li>


                            <li class="menu-item">
                                <a href="<?php echo e(url('/shop')); ?>" style="<?php echo e(Request::is('shop') ? 'color:#e73917;' : ''); ?>" class="menu-name" data-title="Products">Shop</a>
                                
                            </li>
                            <li>
                                <a style="<?php echo e(Request::is('deals') ? 'color:#e73917;' : ''); ?>" href="<?php echo e(url('/deals')); ?>">Hot Deals</a>
                            </li>

                            <li class="menu-item"> <a style="<?php echo e(Request::is('contact')?'color:#e73917;' : ''); ?>" href="<?php echo e(url('/contact')); ?>">Contact</a></li>
                        </ul>
                    </div>
                    </div>
                    <div class="col-lg-3 col-md-3 col-md-6 col-xs-6">
                        <div class="biolife-cart-info">
                            <div class="mobile-search">
                                <a href="javascript:void(0)" class="open-searchbox"><i class="biolife-icon icon-search"></i></a>
                                <div class="mobile-search-content">
                                    <form action="<?php echo e(route('product_search')); ?>" class="form-search" name="mobile-seacrh" method="get">
                                        <?php echo csrf_field(); ?>
                                        <a href="#" class="btn-close"><span class="biolife-icon icon-close-menu"></span></a>
                                        <input type="text" name="search" class="input-text" value="" placeholder="Search here...">
                                        <button type="submit" class="btn-submit">go</button>
                                    </form>
                                </div>
                            </div>
                            
                            <div class="minicart-block">
                                <div class="minicart-contain">
                                    <a href="javascript:void(0)" class="link-to">
                                            <span class="icon-qty-combine">
                                                <i class="icon-cart-mini biolife-icon"></i>
                                                <span class="qty"><?php echo e(Cart::count()); ?></span>
                                            </span>
                                        <span class="title">My Cart -</span>
                                        <span class="sub-total">£<?php echo e(Cart::subtotal()); ?></span>
                                    </a>
                                    <div class="cart-content">
                                        <div class="cart-inner">
                                            <ul class="products">

                                                <?php $__currentLoopData = $cart_items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <?php $product = App\Product::find($item->id);$images = explode(",", $product->image)?>
                                                <li>
                                                    <div class="minicart-item">
                                                        <div class="thumb">
                                                            <a href="<?php echo e(url('/single-product')); ?>/<?php echo e($product->id); ?>"><?php $__currentLoopData = $images; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $image): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?><img src="<?php echo e(url('public/images/product', $image)); ?>" width="90" height="90" alt="<?php echo e($item->name); ?>">
                                                            <?php break; ?>
                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                            </a>
                                                        </div>
                                                        <div class="left-info">
                                                            <div class="product-title"><a href="<?php echo e(url('/single-product')); ?>/<?php echo e($product->id); ?>" class="product-name"><?php echo e($item->name); ?></a></div>
                                                            <div class="price">
                                                                <ins><span class="price-amount"><span class="currencySymbol">£</span><?php echo e($item->price); ?></span></ins>
                                                                <!-- <del><span class="price-amount"><span class="currencySymbol">£</span>95.00</span></del> -->
                                                            </div>
                                                            <div class="qty">
                                                                <label for="cart[id123][qty]">Qty: <?php echo e($item->qty); ?></label>
                                                                <!-- <input type="number" class="input-qty" name="cart[id123][qty]" id="cart[id123][qty]" value="1" disabled> -->
                                                            </div>
                                                        </div>
                                                        <div class="action">
                                                            <a href="<?php echo e(url('shopping-cart')); ?>"><i class="fa fa-pencil" aria-hidden="true"></i></a>
                                                            <a href="<?php echo e(url('cart/remove_item')); ?>/<?php echo e($item->rowId); ?>"><i class="fa fa-trash-o" aria-hidden="true"></i></a>
                                                        </div>
                                                    </div>
                                                </li>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                
                                            </ul>
                                            <p class="btn-control">
                                                <a href="<?php echo e(url('shopping-cart')); ?>" class="btn view-cart">view cart</a>
                                                <a href="<?php echo e(url('/check_out')); ?>" class="btn">checkout</a>
                                            </p>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="mobile-menu-toggle">
                                <a class="btn-toggle" data-object="open-mobile-menu" href="javascript:void(0)">
                                    <span></span>
                                    <span></span>
                                    <span></span>
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="header-bottom hidden-sm hidden-xs">
            <div class="container">
                <div class="row">
                    <div class="col-lg-3 col-md-4">
                        <div class="vertical-menu vertical-category-block">
                            <div class="block-title">
                                <span class="menu-icon">
                                    <span class="line-1"></span>
                                    <span class="line-2"></span>
                                    <span class="line-3"></span>
                                </span>
                                <span class="menu-title">All departments</span>
                                <span class="angle" data-tgleclass="fa fa-caret-down"><i class="fa fa-caret-up" aria-hidden="true"></i></span>
                            </div>
                            <div class="wrap-menu">
                                <ul class="menu clone-main-menu">
                                    <?php $categories = App\Category::where('is_active', true)->orderBy('id', 'desc')->where('parent_id', null)->get(); ?>
                                    <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php $sub_cat_count = App\Category::where('parent_id', $category->id)->where('is_active', true)->count(); ?>
                                    
                                        <li class="menu-item <?php  if($sub_cat_count > 0){ ?> menu-item-has-children has-child<?php } ?>">
                                        <a href="<?php echo e(url('/shop_by_id/' . $category->id)); ?>" class="menu-name" data-title="Butter & Eggs"><i class="biolife-icon icon-honey"></i><?php echo e($category->name); ?></a>

                                        <ul class="sub-menu">
                                            <?php if($sub_cat_count > 0): ?>
                <?php $sub_cats = App\Category::where('parent_id', $category->id)->where('is_active', true)->get(); ?>
                                             <?php $__currentLoopData = $sub_cats; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $sub_cat): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                                             <?php $sub_sub_cat_count = App\Category::where('parent_id', $sub_cat->id)->where('is_active', true)->count(); ?>
                                            <li class="menu-item <?php  if($sub_sub_cat_count > 0){ ?> menu-item-has-children has-child<?php } ?>">
                                                <a href="<?php echo e(url('/shop_by_id/' . $sub_cat->id)); ?>" class="menu-name" data-title="Eggs & other considerations"><?php echo e($sub_cat->name); ?> </a>

                                                <ul class="sub-menu">
                                                     <?php if($sub_sub_cat_count > 0): ?>
                                <?php $sub_sub_cats = App\Category::where('parent_id', $sub_cat->id)->where('is_active', true)->get(); ?>
                                                    <?php $__currentLoopData = $sub_sub_cats; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $sub_sub_cat): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <li class="menu-item"><a href="<?php echo e(url('/shop_by_id/' . $sub_sub_cat->id)); ?>"><?php echo e($sub_sub_cat->name); ?></a></li>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    <?php endif; ?>
                                                </ul>
                                            </li>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            <?php endif; ?>
                                                                                         
                                        </ul>
                                    </li>

                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>   
                                </ul>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-9 col-md-8 padding-top-2px">
                        <div class="header-search-bar layout-01">
                            <form action="<?php echo e(route('product_search')); ?>" class="form-search" name="desktop-seacrh" method="get">
                                <?php echo csrf_field(); ?>
                                <input type="text" name="search" class="input-text" value="" placeholder="Search here...">
                                
                                <button type="submit" class="btn-submit"><i class="biolife-icon icon-search"></i></button>
                            </form>
                        </div>
                        <div class="live-info">
                            <p class="telephone"><i class="fa fa-phone" aria-hidden="true"></i><b class="phone-number"><?php echo e($info->phone); ?></b></p>
                            <p class="working-time">Mon-Fri: 8:30am-7:30pm;</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </header><?php /**PATH /home/mamusxqr/alamminimarket.co.uk/resources/views/front/layout/header.blade.php ENDPATH**/ ?>