

<?php $__env->startSection('content'); ?>

<?php if(session()->has('success')): ?>
  <div class="alert alert-success alert-dismissible text-center">
      <button type="button" class="close" data-dismiss="alert" aria-label="Close">
          <span aria-hidden="true">&times;</span>
      </button>
      <?php echo e(session()->get('success')); ?>

  </div> 
<?php endif; ?>

<section class="forms">
    <div class="container-fluid">
        <div class="row">
            <div class="col-md-12">
                <div class="card">
                    <div class="card-header d-flex align-items-center">
                        <h4>SEO Settings for Product: <?php echo e($product->name); ?></h4>
                    </div>
                    <div class="card-body">
                        <p class="italic"><small>Fields marked with * are optional but recommended for SEO.</small></p>

                        <?php echo Form::open(['route' => ['products.seo_meta.update', $product->id], 'method' => 'post']); ?>


                        <?php echo Form::hidden('model_type', \App\Models\Product::class); ?>

                        <?php echo Form::hidden('model_id', $product->id); ?>


                        <div class="row">

                            
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label>URL Slug</label>
                                    <div class="input-group">
                                        <div class="input-group-prepend">
                                            <span class="input-group-text"><?php echo e(url('/')); ?>/single-product/<?php echo e($product->id); ?>/</span>
                                        </div>
                                        <input type="text" name="slug" class="form-control"
                                            value="<?php echo e($seo->slug ?? \Illuminate\Support\Str::slug($product->name)); ?>">
                                    </div>
                                    
                                </div>
                            </div>

                            
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Meta Title</label>
                                    <input type="text" name="title" class="form-control" 
                                           value="<?php echo e($seo->title ?? ''); ?>">
                                </div>
                            </div>

                            
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Meta Description</label>
                                    <textarea name="meta_description" rows="3" class="form-control"><?php echo e($seo->meta_description ?? ''); ?></textarea>
                                </div>
                            </div>

                            
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Meta Keywords (comma separated)</label>
                                    <input type="text" name="meta_keywords" class="form-control"
                                           value="<?php echo e($seo->meta_keywords ?? ''); ?>">
                                </div>
                            </div>

                            
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Canonical URL</label>
                                    <input type="text" name="canonical_url" class="form-control"
                                           value="<?php echo e($seo->canonical_url ?? ''); ?>">
                                </div>
                            </div>

                            
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Robots Directive</label>
                                    <select name="robots" class="form-control">
                                        <option value="" <?php echo e(empty($seo->robots) ? 'selected' : ''); ?>>-- Select --</option>
                                        <option value="index, follow" <?php echo e(($seo->robots ?? '') == 'index, follow' ? 'selected' : ''); ?>>index, follow</option>
                                        <option value="noindex, follow" <?php echo e(($seo->robots ?? '') == 'noindex, follow' ? 'selected' : ''); ?>>noindex, follow</option>
                                        <option value="index, nofollow" <?php echo e(($seo->robots ?? '') == 'index, nofollow' ? 'selected' : ''); ?>>index, nofollow</option>
                                        <option value="noindex, nofollow" <?php echo e(($seo->robots ?? '') == 'noindex, nofollow' ? 'selected' : ''); ?>>noindex, nofollow</option>
                                    </select>
                                </div>
                            </div>

                            
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label>Custom &lt;head&gt; Script (optional)</label>
                                    <textarea name="custom_head_script" rows="4" class="form-control"><?php echo e($seo->custom_head_script ?? ''); ?></textarea>
                                </div>
                            </div>

                            
                            <div class="form-group col-md-12">
                                <button type="submit" class="btn btn-primary">Save SEO</button>
                                <a href="<?php echo e(route('products.index')); ?>" class="btn btn-secondary">Back to Products</a>
                            </div>

                        </div>

                        <?php echo Form::close(); ?>

                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<script type="text/javascript">
    $("ul#product").siblings('a').attr('aria-expanded','true');
    $("ul#product").addClass("show");
    $("ul#product #product-seo-menu").addClass("active");
</script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layout.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/mamusxqr/alamminimarket.co.uk/resources/views/product/seo.blade.php ENDPATH**/ ?>