<?php echo $__env->make('front.layout.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <!--Hero Section-->
    <div class="hero-section hero-background">
        <h1 class="page-title">ShoppingCart</h1>
    </div>

    <!--Navigation section-->
    <div class="container">
        <nav class="biolife-nav">
            <ul>
                <li class="nav-item"><a href="<?php echo e(url('/')); ?>" class="permal-link">Home</a></li>
                <li class="nav-item"><span class="current-page">ShoppingCart</span></li>
            </ul>
        </nav>
    </div>
    <?php if(session()->has('success')): ?>
    <div class="alert alert-success alert-dismissible text-center">
        <button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
        <?php echo e(session()->get('success')); ?>

    </div> 
<?php endif; ?>

<?php if(session()->has('error')): ?>
    <div class="alert alert-danger alert-dismissible text-center">
        <button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
        <?php echo e(session()->get('error')); ?>

    </div> 
<?php endif; ?>

<?php if(isset($error)): ?>
    <div class="alert alert-danger alert-dismissible text-center">
        <button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
        <?php echo e($error); ?>

    </div> 
<?php endif; ?>

    <div class="page-contain shopping-cart">

        <!-- Main content -->
        <div id="main-content" class="main-content">
            <div class="container">

                <!--Top banner-->

                <!--Cart Table-->
                <div class="shopping-cart-container">
                    <div class="row">
                        <div class="col-lg-9 col-md-12 col-sm-12 col-xs-12">
                            <h3 class="box-title">Your cart items</h3>
                            <div id="alert-container"></div>
                            <!-- <form class="shopping-cart-form" action="<?php echo e(route('cart.update_cart')); ?>" method="POST"> -->
                                <?php echo csrf_field(); ?>
                                <table class="shop_table cart-form">
                                    <thead>
                                        <tr>
                                            <th class="li-product-remove">Remove</th>
                                            <th class="li-product-thumbnail">Images</th>
                                            <th class="cart-product-name">Product</th>
                                            <th class="li-product-price">Unit Price</th>
                                            <th class="li-product-quantity">Quantity</th>
                                            <th class="li-product-subtotal">Total</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $__currentLoopData = $cart_items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $i => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <?php 
                                            $product = App\Product::find($item->id); 
                                            $images = explode(",", $product->image);
                                            ?>
                                            <tr class="cart_item">
                                                <input type="hidden" name="rowId[]" value="<?php echo e($item->rowId); ?>">
                                                <td class="li-product-remove"><a href="<?php echo e(url('cart/remove_item')); ?>/<?php echo e($item->rowId); ?>"><i class="fa fa-times"></i></a></td>
                                                <?php $__currentLoopData = $images; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $image): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <td class="li-product-thumbnail"><a href="#"><img src="<?php echo e(url('public/images/product', $image)); ?>" height="150" width="150" alt="Li's Product Image"></a></td>
                                                    <?php break; ?>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                <td class="li-product-name"><a href="#"><?php echo e($item->name); ?></a></td>
                                                <input type="hidden" name="hidden_amount" class="hidden_amount" value="<?php echo e($item->price); ?>">
                                                <td class="li-product-price"><span class="amount">£ <?php echo e($item->price); ?></span></td>
                                                <td class="quantity">
                                                    <input style="width:80px" class="qty" type="number" name="quantity[]" value="<?php echo e($item->qty); ?>" min="1" data-rowid="<?php echo e($item->rowId); ?>">
                                                </td>
                                                <?php $subtotal = $item->qty * $item->price; ?>
                                                <td class="product-subtotal"><span id="subtotal-<?php echo e($item->rowId); ?>" class="subtotal">£ <?php echo e($subtotal); ?></span></td>
                                            </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        <tr class="cart_item wrap-buttons">
                                            <td class="wrap-btn-control" colspan="6">
                                                <a href="<?php echo e(url('/shop')); ?>" class="btn back-to-shop">Back to Shop</a>
                                                <!-- <button class="btn btn-update" type="submit">Update Cart</button> -->
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>
                            </form>

                        </div>
                        <div class="col-lg-3 col-md-12 col-sm-12 col-xs-12">
                            <div class="shpcart-subtotal-block">
                                <div class="subtotal-line">
                                    <b class="stt-name">Subtotal <span class="sub"></span></b>
                                    <span class="stt-price" id="cart-total">£ <?php echo e(Cart::subtotal()); ?></span>
                                </div>
                                <div class="subtotal-line">
                                    <b class="stt-name">Shipping</b>
                                    <span class="stt-price">£ 0.00</span>
                                </div>
                                <div class="btn-checkout">
                                    <a href="<?php echo e(url('/check_out')); ?>" class="btn checkout">Check out</a>
                                </div>
                            </div>
                        </div>
                </div>

                <!--Related Product-->

            </div>
        </div>
    </div>

<?php echo $__env->make('front.layout.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<script type="text/javascript">
    var csrfToken = "<?php echo e(csrf_token()); ?>";
    var updateCartUrl = "<?php echo e(route('cart.update')); ?>";

    document.addEventListener('DOMContentLoaded', function() {
        const qtyInputs = document.querySelectorAll('.qty');
        
        qtyInputs.forEach(input => {
            input.addEventListener('change', function() {
                updateCartItem(this);
            });
        });
    });

    function updateCartItem(input) {
        const rowId = input.dataset.rowid;
        const quantity = input.value;
        const price = input.closest('tr').querySelector('.hidden_amount').value;

        fetch(updateCartUrl, {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': csrfToken
            },
            body: JSON.stringify({
                rowId: rowId,
                quantity: quantity
            })
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                // Update subtotal
                const subtotal = price * quantity;
                const subtotalElement = document.getElementById(`subtotal-${rowId}`);
                if (subtotalElement) {
                    subtotalElement.textContent = `£ ${parseFloat(subtotal).toFixed(2)}`;
                }

                // Update cart total
                if (data.cartTotal !== undefined) {
                    const cartTotalElement = document.getElementById('cart-total');
                    if (cartTotalElement) {
                        cartTotalElement.textContent = `£ ${parseFloat(data.cartTotal).toFixed(2)}`;
                    }
                }

                showAlert('success', data.message);
            } else {
                showAlert('error', data.message);
                // Reset the input to the previous valid quantity
                input.value = input.defaultValue;
            }
        })
        .catch(error => {
            console.error('Error:', error);
            showAlert('error', 'An error occurred while updating the cart');
            // Reset the input to the previous valid quantity
            input.value = input.defaultValue;
        });
    }

    function showAlert(type, message) {
        const alertContainer = document.getElementById('alert-container');
        const alertClass = type === 'success' ? 'alert-success' : 'alert-danger';
        const alertHtml = `
            <div class="alert ${alertClass} alert-dismissible text-center">
                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
                ${message}
            </div>
        `;
        
        alertContainer.innerHTML = alertHtml;
        
        // Automatically remove the alert after 5 seconds
        setTimeout(() => {
            const alert = alertContainer.querySelector('.alert');
            if (alert) {
                alert.remove();
            }
        }, 5000);
    }
</script><?php /**PATH /home/mamusxqr/alamminimarket.co.uk/resources/views/front/shopping-cart.blade.php ENDPATH**/ ?>