<?php echo $__env->make('front.layout.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<div class="breadcrumb-area">
    <div class="container">
        <ol class="breadcrumb breadcrumb-list">
            <li class="breadcrumb-item"><a href="<?php echo e(url('/')); ?>">Home</a></li>
            <li class="breadcrumb-item active">My Account</li>
        </ol>
    </div>
</div>

<?php if(session()->has('success')): ?>
    <div class="alert alert-success alert-dismissible text-center">
        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
            <span aria-hidden="true">&times;</span>
        </button>
        <?php echo e(session()->get('success')); ?>

    </div>
<?php endif; ?>

<div class="container" style="padding: 20px; font-family: Arial, sans-serif;">
    <h3>Orders</h3>
    <div style="overflow-x: auto;">
        <table style="width: 100%; border-collapse: collapse; margin-top: 20px;">
            <thead>
                <tr>
                    <th style="border: 1px solid #ddd; padding: 8px; background-color: #f2f2f2;">Reference No.</th>
                    <th style="border: 1px solid #ddd; padding: 8px; background-color: #f2f2f2;">Order Date</th>
                    <th style="border: 1px solid #ddd; padding: 8px; background-color: #f2f2f2;">Items</th>
                    <th style="border: 1px solid #ddd; padding: 8px; background-color: #f2f2f2;">Total</th>
                    <th style="border: 1px solid #ddd; padding: 8px; background-color: #f2f2f2;">Status</th>
                </tr>
            </thead>
            <tbody>
                <?php $__currentLoopData = $orders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php $sale_details = App\Product_Sale::where('sale_id', $order->id)->get(); ?>
                    <tr>
                        <td style="border: 1px solid #ddd; padding: 8px;"><?php echo e($order->reference_no); ?></td>
                        <td style="border: 1px solid #ddd; padding: 8px;">
                            <?php echo e(date($general_setting->date_format, strtotime($order->created_at->toDateString())) . ' ' . $order->created_at->toTimeString()); ?>

                        </td>
                        <td style="border: 1px solid #ddd; padding: 8px;">
                            <?php $__currentLoopData = $sale_details; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php $product = App\Product::find($row->product_id); ?>
                                <?php echo e($product->name); ?> x <?php echo e($row->qty); ?><br>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </td>
                        <td style="border: 1px solid #ddd; padding: 8px;"><?php echo e($order->grand_total); ?></td>
                        <td style="border: 1px solid #ddd; padding: 8px;">
                            <?php if($order->sale_status == 1): ?>
                                <span style="color: green;">Completed</span>
                            <?php elseif($order->sale_status == 2): ?>
                                <span style="color: orange;">Pending</span>
                            <?php elseif($order->sale_status == 3): ?>
                                <span style="color: blue;">Processing</span>
                            <?php else: ?>
                                <span style="color: grey;">Draft</span>
                            <?php endif; ?>
                        </td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>
    </div>
</div>

<?php echo $__env->make('front.layout.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<?php /**PATH /home/mamusxqr/alamminimarket.co.uk/resources/views/front/customer_account.blade.php ENDPATH**/ ?>