<?php

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/
use App\Http\Controllers\front\WebController;
use App\Http\Controllers\front\StripePaymentController;
use App\Http\Controllers\front\SslCommerzPaymentController;
use App\Http\Controllers\front\PayPalController;
use App\Http\Controllers\front\BkashController;
use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\Route;



Route::get('/optimize-clear', function () {
    Artisan::call('optimize:clear');
    Artisan::call('cache:clear');
    Artisan::call('view:clear');
    Artisan::call('config:clear');
    return "Optimizations cleared!";
});

Auth::routes();

// Dynamic sitemap route - generates sitemap on every request
Route::get('/sitemap.xml', 'SitemapController@index');



Route::group(['middleware' => 'auth'], function() {
	Route::get('/dashboard', 'HomeController@dashboard');
});
Route::get('redirects', [WebController::class, 'authenticate']);


Route::group(['middleware' => ['auth', 'active']], function() {

	Route::get('/home', 'HomeController@index');
	Route::get('/dashboard-filter/{start_date}/{end_date}', 'HomeController@dashboardFilter');
	Route::get('check-batch-availability/{product_id}/{batch_no}/{warehouse_id}', 'ProductController@checkBatchAvailability');

	Route::get('language_switch/{locale}', 'LanguageController@switchLanguage');

	Route::get('role/permission/{id}', 'RoleController@permission')->name('role.permission');
	Route::post('role/set_permission', 'RoleController@setPermission')->name('role.setPermission');
	Route::resource('role', 'RoleController');

	Route::post('importunit', 'UnitController@importUnit')->name('unit.import');
	Route::post('unit/deletebyselection', 'UnitController@deleteBySelection');
	Route::get('unit/lims_unit_search', 'UnitController@limsUnitSearch')->name('unit.search');
	Route::resource('unit', 'UnitController');

	Route::post('category/import', 'CategoryController@import')->name('category.import');
	Route::post('category/deletebyselection', 'CategoryController@deleteBySelection');
	Route::post('category/category-data', 'CategoryController@categoryData');
	Route::resource('category', 'CategoryController');

	Route::post('importbrand', 'BrandController@importBrand')->name('brand.import');
	Route::post('brand/deletebyselection', 'BrandController@deleteBySelection');
	Route::get('brand/lims_brand_search', 'BrandController@limsBrandSearch')->name('brand.search');
	Route::resource('brand', 'BrandController');

	Route::post('importsupplier', 'SupplierController@importSupplier')->name('supplier.import');
	Route::post('supplier/deletebyselection', 'SupplierController@deleteBySelection');
	Route::get('supplier/lims_supplier_search', 'SupplierController@limsSupplierSearch')->name('supplier.search');
	Route::resource('supplier', 'SupplierController');

	/*------- Investor -------*/
	Route::resource('investor', 'InvestorController');
	Route::resource('investment', 'InvestmentController');
	Route::resource('bankdeposit', 'BankDepositController');

	/*--------Payable loan-------*/
	Route::resource('payable_loan','PayableLoanController');
	Route::get('payable_loan/view_installment/{id}', 'PayableLoanController@view_installment')->name('payable_loan.view_installment');
	Route::get('products/pay_installment/{id}', 'PayableLoanController@pay_installment')->name('payable_loan.pay_installment');
	Route::post('payable_loan/installment_store', 'PayableLoanController@installment_store')->name('payable_loan.installment_store');

	Route::post('payable_loan/deleteinstallment', 'PayableLoanController@deleteInstallment')->name('payable_loans.delete-installment');
	/*payable loan report*/
	Route::get('report/payable_loan_report', 'PayableLoanController@payable_loan_report')->name('report.payable_loan_report');
	/*installment details in payable loan*/
	Route::get('payable_loan/details/{id}','PayableLoanController@payable_loan_details')->name('payable_loan.details');
	
	/*--------Receivable loan-------*/
	Route::resource('receivable_loan','RecievableLoanController');

	Route::get('receivable_loan/view_installment/{id}', 'RecievableLoanController@view_installment')->name('receivable_loan.view_installment');
	Route::get('products/receive_installment/{id}', 'RecievableLoanController@receive_installment')->name('receivable_loan.receive_installment');

	Route::post('receivable_loan/installment_store', 'RecievableLoanController@installment_store')->name('receivable_loan.installment_store');

	
	Route::post('receivable_loan/deleteinstallment', 'RecievableLoanController@deleteInstallment')->name('receivable_loan.delete-installment');

	/*Recievable loan report*/
	Route::get('report/receivable_loan_report', 'RecievableLoanController@receivable_loan_report')->name('report.receivable_loan_report');
	/*installment details in Recievable loan*/
	Route::get('receivable_loan/details/{id}','RecievableLoanController@receivable_loan_details')->name('receivable_loan.details');

	Route::post('accounts/profit&loss', 'ReportController@profit_loss_statement')->name('accounts.profit&loss');


	Route::post('importwarehouse', 'WarehouseController@importWarehouse')->name('warehouse.import');
	Route::post('warehouse/deletebyselection', 'WarehouseController@deleteBySelection');
	Route::get('warehouse/lims_warehouse_search', 'WarehouseController@limsWarehouseSearch')->name('warehouse.search');
	Route::resource('warehouse', 'WarehouseController');

	Route::post('importtax', 'TaxController@importTax')->name('tax.import');
	Route::post('tax/deletebyselection', 'TaxController@deleteBySelection');
	Route::get('tax/lims_tax_search', 'TaxController@limsTaxSearch')->name('tax.search');
	Route::resource('tax', 'TaxController');

	//Route::get('products/getbarcode', 'ProductController@getBarcode');
	Route::post('products/product-data', 'ProductController@productData');
	Route::get('products/gencode', 'ProductController@generateCode');
	Route::get('products/search', 'ProductController@search');
	Route::get('products/saleunit/{id}', 'ProductController@saleUnit');
	Route::get('products/getdata/{id}', 'ProductController@getData');
	Route::get('products/product_warehouse/{id}', 'ProductController@productWarehouseData');
	Route::post('importproduct', 'ProductController@importProduct')->name('product.import');
	Route::post('exportproduct', 'ProductController@exportProduct')->name('product.export');
	Route::get('products/print_barcode','ProductController@printBarcode')->name('product.printBarcode');
	
	Route::get('products/lims_product_search', 'ProductController@limsProductSearch')->name('product.search');
	Route::post('products/deletebyselection', 'ProductController@deleteBySelection');
	Route::post('products/update', 'ProductController@updateProduct');
	Route::resource('products', 'ProductController');

	Route::post('importcustomer_group', 'CustomerGroupController@importCustomerGroup')->name('customer_group.import');
	Route::post('customer_group/deletebyselection', 'CustomerGroupController@deleteBySelection');
	Route::get('customer_group/lims_customer_group_search', 'CustomerGroupController@limsCustomerGroupSearch')->name('customer_group.search');
	Route::resource('customer_group', 'CustomerGroupController');

	Route::post('importcustomer', 'CustomerController@importCustomer')->name('customer.import');
	Route::get('customer/getDeposit/{id}', 'CustomerController@getDeposit');
	Route::post('customer/add_deposit', 'CustomerController@addDeposit')->name('customer.addDeposit');
	Route::post('customer/update_deposit', 'CustomerController@updateDeposit')->name('customer.updateDeposit');
	Route::post('customer/deleteDeposit', 'CustomerController@deleteDeposit')->name('customer.deleteDeposit');
	Route::post('customer/deletebyselection', 'CustomerController@deleteBySelection');
	Route::get('customer/lims_customer_search', 'CustomerController@limsCustomerSearch')->name('customer.search');
	Route::resource('customer', 'CustomerController');
	Route::get('reseller', 'CustomerController@reseller_list')->name('reseller');
	

	Route::post('importbiller', 'BillerController@importBiller')->name('biller.import');
	Route::post('biller/deletebyselection', 'BillerController@deleteBySelection');
	Route::get('biller/lims_biller_search', 'BillerController@limsBillerSearch')->name('biller.search');
	Route::resource('biller', 'BillerController');

	Route::post('sales/sale-data', 'SaleController@saleData');
	Route::post('sales/sendmail', 'SaleController@sendMail')->name('sale.sendmail');
	Route::get('sales/sale_by_csv', 'SaleController@saleByCsv');
	Route::get('sales/product_sale/{id}','SaleController@productSaleData');
	Route::post('importsale', 'SaleController@importSale')->name('sale.import');
	Route::get('pos', 'SaleController@posSale')->name('sale.pos');
	Route::get('sales/lims_sale_search', 'SaleController@limsSaleSearch')->name('sale.search');
	Route::get('sales/lims_product_search', 'SaleController@limsProductSearch')->name('product_sale.search');
	Route::get('sales/getcustomergroup/{id}', 'SaleController@getCustomerGroup')->name('sale.getcustomergroup');
	Route::get('sales/getproduct/{id}', 'SaleController@getProduct')->name('sale.getproduct');
	Route::get('sales/getproduct/{category_id}/{brand_id}', 'SaleController@getProductByFilter');
	Route::get('sales/getfeatured', 'SaleController@getFeatured');
	Route::get('sales/get_gift_card', 'SaleController@getGiftCard');
	Route::get('sales/paypalSuccess', 'SaleController@paypalSuccess');
	Route::get('sales/paypalPaymentSuccess/{id}', 'SaleController@paypalPaymentSuccess');
	Route::get('sales/gen_invoice/{id}', 'SaleController@genInvoice')->name('sale.invoice');
	Route::post('sales/add_payment', 'SaleController@addPayment')->name('sale.add-payment');
	Route::get('sales/getpayment/{id}', 'SaleController@getPayment')->name('sale.get-payment');
	Route::post('sales/updatepayment', 'SaleController@updatePayment')->name('sale.update-payment');
	Route::post('sales/deletepayment', 'SaleController@deletePayment')->name('sale.delete-payment');
	Route::get('sales/{id}/create', 'SaleController@createSale');
	Route::post('sales/deletebyselection', 'SaleController@deleteBySelection');
	Route::get('sales/print-last-reciept', 'SaleController@printLastReciept')->name('sales.printLastReciept');
	Route::get('sales/today-sale', 'SaleController@todaySale');
	Route::get('sales/today-profit/{warehouse_id}', 'SaleController@todayProfit');
	Route::resource('sales', 'SaleController');

	Route::get('delivery', 'DeliveryController@index')->name('delivery.index');
	Route::get('delivery/product_delivery/{id}','DeliveryController@productDeliveryData');
	Route::get('delivery/create/{id}', 'DeliveryController@create');
	Route::post('delivery/store', 'DeliveryController@store')->name('delivery.store');
	Route::post('delivery/sendmail', 'DeliveryController@sendMail')->name('delivery.sendMail');
	Route::get('delivery/{id}/edit', 'DeliveryController@edit');
	Route::post('delivery/update', 'DeliveryController@update')->name('delivery.update');
	Route::post('delivery/deletebyselection', 'DeliveryController@deleteBySelection');
	Route::post('delivery/delete/{id}', 'DeliveryController@delete')->name('delivery.delete');

	Route::get('quotations/product_quotation/{id}','QuotationController@productQuotationData');
	Route::get('quotations/lims_product_search', 'QuotationController@limsProductSearch')->name('product_quotation.search');
	Route::get('quotations/getcustomergroup/{id}', 'QuotationController@getCustomerGroup')->name('quotation.getcustomergroup');
	Route::get('quotations/getproduct/{id}', 'QuotationController@getProduct')->name('quotation.getproduct');
	Route::get('quotations/{id}/create_sale', 'QuotationController@createSale')->name('quotation.create_sale');
	Route::get('quotations/{id}/create_purchase', 'QuotationController@createPurchase')->name('quotation.create_purchase');
	Route::post('quotations/sendmail', 'QuotationController@sendMail')->name('quotation.sendmail');
	Route::post('quotations/deletebyselection', 'QuotationController@deleteBySelection');
	Route::resource('quotations', 'QuotationController');

	Route::post('purchases/purchase-data', 'PurchaseController@purchaseData')->name('purchases.data');
	Route::get('purchases/product_purchase/{id}','PurchaseController@productPurchaseData');
	Route::get('purchases/lims_product_search', 'PurchaseController@limsProductSearch')->name('product_purchase.search');
	Route::post('purchases/add_payment', 'PurchaseController@addPayment')->name('purchase.add-payment');
	Route::get('purchases/getpayment/{id}', 'PurchaseController@getPayment')->name('purchase.get-payment');
	Route::post('purchases/updatepayment', 'PurchaseController@updatePayment')->name('purchase.update-payment');
	Route::post('purchases/deletepayment', 'PurchaseController@deletePayment')->name('purchase.delete-payment');
	Route::get('purchases/purchase_by_csv', 'PurchaseController@purchaseByCsv');
	Route::post('importpurchase', 'PurchaseController@importPurchase')->name('purchase.import');
	Route::post('purchases/deletebyselection', 'PurchaseController@deleteBySelection');
	Route::resource('purchases', 'PurchaseController');

	Route::get('transfers/product_transfer/{id}','TransferController@productTransferData');
	Route::get('transfers/transfer_by_csv', 'TransferController@transferByCsv');
	Route::post('importtransfer', 'TransferController@importTransfer')->name('transfer.import');
	Route::get('transfers/getproduct/{id}', 'TransferController@getProduct')->name('transfer.getproduct');
	Route::get('transfers/lims_product_search', 'TransferController@limsProductSearch')->name('product_transfer.search');
	Route::post('transfers/deletebyselection', 'TransferController@deleteBySelection');
	Route::resource('transfers', 'TransferController');

	Route::get('qty_adjustment/getproduct/{id}', 'AdjustmentController@getProduct')->name('adjustment.getproduct');
	Route::get('qty_adjustment/lims_product_search', 'AdjustmentController@limsProductSearch')->name('product_adjustment.search');
	Route::post('qty_adjustment/deletebyselection', 'AdjustmentController@deleteBySelection');
	Route::resource('qty_adjustment', 'AdjustmentController');

	Route::get('return-sale/getcustomergroup/{id}', 'ReturnController@getCustomerGroup')->name('return-sale.getcustomergroup');
	Route::post('return-sale/sendmail', 'ReturnController@sendMail')->name('return-sale.sendmail');
	Route::get('return-sale/getproduct/{id}', 'ReturnController@getProduct')->name('return-sale.getproduct');
	Route::get('return-sale/lims_product_search', 'ReturnController@limsProductSearch')->name('product_return-sale.search');
	Route::get('return-sale/product_return/{id}','ReturnController@productReturnData');
	Route::post('return-sale/deletebyselection', 'ReturnController@deleteBySelection');
	Route::resource('return-sale', 'ReturnController');

	Route::get('return-purchase/getcustomergroup/{id}', 'ReturnPurchaseController@getCustomerGroup')->name('return-purchase.getcustomergroup');
	Route::post('return-purchase/sendmail', 'ReturnPurchaseController@sendMail')->name('return-purchase.sendmail');
	Route::get('return-purchase/getproduct/{id}', 'ReturnPurchaseController@getProduct')->name('return-purchase.getproduct');
	Route::get('return-purchase/lims_product_search', 'ReturnPurchaseController@limsProductSearch')->name('product_return-purchase.search');
	Route::get('return-purchase/product_return/{id}','ReturnPurchaseController@productReturnData');
	Route::post('return-purchase/deletebyselection', 'ReturnPurchaseController@deleteBySelection');
	Route::resource('return-purchase', 'ReturnPurchaseController');

	Route::get('report/product_quantity_alert', 'ReportController@productQuantityAlert')->name('report.qtyAlert');
	Route::get('report/warehouse_stock', 'ReportController@warehouseStock')->name('report.warehouseStock');
	Route::post('report/warehouse_stock', 'ReportController@warehouseStockById')->name('report.warehouseStock');
	Route::get('report/daily_sale/{year}/{month}', 'ReportController@dailySale');
	Route::post('report/daily_sale/{year}/{month}', 'ReportController@dailySaleByWarehouse')->name('report.dailySaleByWarehouse');
	Route::get('report/monthly_sale/{year}', 'ReportController@monthlySale');
	Route::post('report/monthly_sale/{year}', 'ReportController@monthlySaleByWarehouse')->name('report.monthlySaleByWarehouse');
	Route::get('report/daily_purchase/{year}/{month}', 'ReportController@dailyPurchase');
	Route::post('report/daily_purchase/{year}/{month}', 'ReportController@dailyPurchaseByWarehouse')->name('report.dailyPurchaseByWarehouse');
	Route::get('report/monthly_purchase/{year}', 'ReportController@monthlyPurchase');
	Route::post('report/monthly_purchase/{year}', 'ReportController@monthlyPurchaseByWarehouse')->name('report.monthlyPurchaseByWarehouse');
	Route::get('report/best_seller', 'ReportController@bestSeller');
	Route::post('report/best_seller', 'ReportController@bestSellerByWarehouse')->name('report.bestSellerByWarehouse');
	Route::post('report/profit_loss', 'ReportController@profitLoss')->name('report.profitLoss');
	Route::get('report/product_report', 'ReportController@productReport')->name('report.product');

	Route::post('report/product_report_data', 'ReportController@productReportData');
	Route::post('report/purchase', 'ReportController@purchaseReport')->name('report.purchase');
	Route::post('report/sale_report', 'ReportController@saleReport')->name('report.sale');
	Route::post('report/payment_report_by_date', 'ReportController@paymentReportByDate')->name('report.paymentByDate');
	Route::post('report/warehouse_report', 'ReportController@warehouseReport')->name('report.warehouse');
	Route::post('report/user_report', 'ReportController@userReport')->name('report.user');
	Route::post('report/customer_report', 'ReportController@customerReport')->name('report.customer');
	Route::post('report/supplier', 'ReportController@supplierReport')->name('report.supplier');
	Route::post('report/due_report_by_date', 'ReportController@dueReportByDate')->name('report.dueByDate');
	//custom sms report
	Route::post('report/sms', 'ReportController@sms_report')->name('report.sms');
    Route::get('sms_details/{id}', 'ReportController@sms_details')->name('sms_details');
    //Custom Investment Report for musicare
    Route::post('report/investment_report', 'ReportController@investmentReport')->name('report.investment_report');
    Route::post('report/bankdeposit_report', 'ReportController@bankdpReport')->name('report.bankdeposit_report');
    Route::post('report/earning_report', 'ReportController@earningReport')->name('report.earning_report');

	Route::get('user/profile/{id}', 'UserController@profile')->name('user.profile');
	Route::put('user/update_profile/{id}', 'UserController@profileUpdate')->name('user.profileUpdate');
	Route::put('user/changepass/{id}', 'UserController@changePassword')->name('user.password');
	Route::get('user/genpass', 'UserController@generatePassword');
	Route::post('user/deletebyselection', 'UserController@deleteBySelection');
	Route::resource('user','UserController');

	Route::get('setting/general_setting', 'SettingController@generalSetting')->name('setting.general');
	Route::post('setting/general_setting_store', 'SettingController@generalSettingStore')->name('setting.generalStore');
	Route::get('backup', 'SettingController@backup')->name('setting.backup');
	Route::get('setting/general_setting/change-theme/{theme}', 'SettingController@changeTheme');
	Route::get('setting/mail_setting', 'SettingController@mailSetting')->name('setting.mail');
	Route::get('setting/sms_setting', 'SettingController@smsSetting')->name('setting.sms');
	Route::get('setting/createsms', 'SettingController@createSms')->name('setting.createSms');
	Route::post('setting/sendsms', 'SettingController@sendSms')->name('setting.sendSms');
	Route::get('setting/hrm_setting', 'SettingController@hrmSetting')->name('setting.hrm');
	Route::post('setting/hrm_setting_store', 'SettingController@hrmSettingStore')->name('setting.hrmStore');
	Route::post('setting/mail_setting_store', 'SettingController@mailSettingStore')->name('setting.mailStore');
	Route::post('setting/sms_setting_store', 'SettingController@smsSettingStore')->name('setting.smsStore');
	Route::get('setting/pos_setting', 'SettingController@posSetting')->name('setting.pos');
	Route::post('setting/pos_setting_store', 'SettingController@posSettingStore')->name('setting.posStore');
	Route::get('setting/empty-database', 'SettingController@emptyDatabase')->name('setting.emptyDatabase');

	Route::get('setting/pgsetting', 'SettingController@pgSetting')->name('setting.pgsetting');
	Route::post('setting/pg_setting_store', 'SettingController@pgSettingStore')->name('setting.pgStore');

	/*for seo*/
	Route::get('setting/site_settings', 'SettingController@site_settings')->name('setting.site_settings');
	Route::post('setting/site_settings_store', 'SettingController@site_settings_store')->name('setting.site_settings_store');

	Route::get('products/{id}/seo', 'ProductSeoController@edit')->name('products.seo_meta');
	Route::post('products/{id}/seo', 'ProductSeoController@update')->name('products.seo_meta.update');

	Route::get('page/{id}/seo', 'PageSeoController@edit')->name('page.seo_meta');
	Route::post('page/{id}/seo', 'PageSeoController@update')->name('page.seo_meta.update');

	Route::get('blog/{id}/seo', 'BlogSeoController@edit')->name('blog.seo_meta');
	Route::post('blog/{id}/seo', 'BlogSeoController@update')->name('blog.seo_meta.update');

	Route::get('staticpage/{id}/seo', 'PageSeoController@staticpageedit')->name('staticpage.seo_meta');
	Route::post('staticpage/{id}/seo', 'PageSeoController@staticpageupdate')->name('staticpage.seo_meta.update');


	Route::get('expense_categories/gencode', 'ExpenseCategoryController@generateCode');
	Route::post('expense_categories/import', 'ExpenseCategoryController@import')->name('expense_category.import');
	Route::post('expense_categories/deletebyselection', 'ExpenseCategoryController@deleteBySelection');
	Route::resource('expense_categories', 'ExpenseCategoryController');

	Route::post('expenses/deletebyselection', 'ExpenseController@deleteBySelection');
	Route::resource('expenses', 'ExpenseController');

	Route::get('gift_cards/gencode', 'GiftCardController@generateCode');
	Route::post('gift_cards/recharge/{id}', 'GiftCardController@recharge')->name('gift_cards.recharge');
	Route::post('gift_cards/deletebyselection', 'GiftCardController@deleteBySelection');
	Route::resource('gift_cards', 'GiftCardController');

	Route::get('coupons/gencode', 'CouponController@generateCode');
	Route::post('coupons/deletebyselection', 'CouponController@deleteBySelection');
	Route::resource('coupons', 'CouponController');
	//accounting routes
	Route::get('accounts/make-default/{id}', 'AccountsController@makeDefault');
	Route::get('accounts/balancesheet', 'AccountsController@balanceSheet')->name('accounts.balancesheet');
	Route::post('accounts/account-statement', 'AccountsController@accountStatement')->name('accounts.statement');
	Route::resource('accounts', 'AccountsController');
	Route::resource('money-transfers', 'MoneyTransferController');
	//HRM routes
	Route::post('departments/deletebyselection', 'DepartmentController@deleteBySelection');
	Route::resource('departments', 'DepartmentController');

	Route::post('employees/deletebyselection', 'EmployeeController@deleteBySelection');
	Route::resource('employees', 'EmployeeController');

	Route::post('payroll/deletebyselection', 'PayrollController@deleteBySelection');
	Route::resource('payroll', 'PayrollController');

	Route::post('attendance/deletebyselection', 'AttendanceController@deleteBySelection');
	Route::resource('attendance', 'AttendanceController');

	Route::resource('stock-count', 'StockCountController');
	Route::post('stock-count/finalize', 'StockCountController@finalize')->name('stock-count.finalize');
	Route::get('stock-count/stockdif/{id}', 'StockCountController@stockDif');
	Route::get('stock-count/{id}/qty_adjustment', 'StockCountController@qtyAdjustment')->name('stock-count.adjustment');

	Route::post('holidays/deletebyselection', 'HolidayController@deleteBySelection');
	Route::get('approve-holiday/{id}', 'HolidayController@approveHoliday')->name('approveHoliday');
	Route::get('holidays/my-holiday/{year}/{month}', 'HolidayController@myHoliday')->name('myHoliday');
	Route::resource('holidays', 'HolidayController');

	Route::get('cash-register', 'CashRegisterController@index')->name('cashRegister.index');
	Route::get('cash-register/check-availability/{warehouse_id}', 'CashRegisterController@checkAvailability')->name('cashRegister.checkAvailability');
	Route::post('cash-register/store', 'CashRegisterController@store')->name('cashRegister.store');
	Route::get('cash-register/getDetails/{id}', 'CashRegisterController@getDetails');
	Route::get('cash-register/showDetails/{warehouse_id}', 'CashRegisterController@showDetails');
	Route::post('cash-register/close', 'CashRegisterController@close')->name('cashRegister.close');

	Route::post('notifications/store', 'NotificationController@store')->name('notifications.store');
	Route::get('notifications/mark-as-read', 'NotificationController@markAsRead');

	Route::resource('currency', 'CurrencyController');

	Route::get('/home', 'HomeController@index')->name('home');
	Route::get('my-transactions/{year}/{month}', 'HomeController@myTransaction');

	Route::get('/forms', function () {
  
    return view('forms');
});
	Route::get('/checkout', [WebController::class, 'checkout'])->name('checkout');
	Route::get('/track_order', [WebController::class, 'track_order'])->name('track_order');
});

// routes for ecommerce front end

/*Route::get('/blog-2-column', function () {
    return view('front/blog-2-column');
});*/

Route::get('/pages/{id}', [WebController::class, 'pages']);
Route::get('/404', [WebController::class, 'notFound'])->name('404');
Route::get('/shopwithus', [WebController::class, 'shopwithus'])->name('shopwithus');
Route::get('/payment', [WebController::class, 'payment'])->name('payment');
Route::get('/shipping', [WebController::class, 'shipping'])->name('shipping');
Route::get('/about-us', [WebController::class, 'about_us'])->name('about-us');
Route::get('/contact', [WebController::class, 'contact'])->name('contact');

Route::get('/blog-item/{id}', [WebController::class, 'blog_item']);
Route::get('/blog', [WebController::class, 'blog']);
Route::get('/blog_by_cat/{id}', [WebController::class, 'blog_by_cat']);

Route::get('/faq', [WebController::class, 'faq'])->name('faq');
Route::get('/customer_account', [WebController::class, 'customer_account'])->name('customer_account');
Route::post('/customer_account/update', [WebController::class, 'updateCustomerAccount'])->name('customer_account.update');

Route::get('/privacy_policy', [WebController::class, 'privacy_policy'])->name('privacy_policy');
Route::get('/return_policy', [WebController::class, 'return_policy'])->name('return_policy');
Route::get('/terms_conditions', [WebController::class, 'terms_conditions'])->name('terms_conditions');
Route::get('reseller_info/{id}', 'CustomerController@reseller_info')->name('reseller_info');

Route::get('/', [WebController::class, 'index'])->name('ecom');

Route::get('/shop', [WebController::class, 'shop_left_sidebar']);
Route::get('/deals', [WebController::class, 'deals']);

Route::get('/shop_by_id/{id}', [WebController::class, 'shop_left_sidebar_by_id']);
//for sorting 
Route::post('/sortproducts', [WebController::class, 'sortProducts'])->name('sortproducts');
Route::post('/sortdealproducts', [WebController::class, 'sortdealproducts'])->name('sortdealproducts');

Route::get('/shopping-cart', [WebController::class, 'cart']);
Route::get('/single-product/{id}', [WebController::class, 'single_product']);
//routes with slug
Route::get('/single-product/{id}/{slug?}', [WebController::class, 'single_product_slug'])->name('product.seo');
Route::get('/pages/{id}/{slug}', [WebController::class, 'pages_slug'])->name('page.seo');
Route::get('/blog-item/{id}/{slug?}', [WebController::class, 'blog_slug'])->name('blog.seo');

Route::get('front/product_details/{id}', [WebController::class, 'product_details_data']);

Route::post('place_order', [WebController::class, 'place_order'])->name('place_order');
Route::post('guest_placeorder', [WebController::class, 'guest_placeorder'])->name('guest_placeorder');
//cart functions
Route::post('/cart/addItem', [WebController::class, 'addItem'])->name('cart.addItem');
Route::post('/cart/update_cart', [WebController::class, 'update_cart'])->name('cart.update_cart');

Route::get('cart/remove_item/{id}', [WebController::class, 'removeItem']);


Route::get('/wishlist', [WebController::class, 'wishlist'])->name('wishlist');
Route::get('/order_completed', [WebController::class, 'order_completed'])->name('order_completed');
Route::get('/c_o', [WebController::class, 'c_o'])->name('c_o');

Route::get('product_search', [WebController::class, 'product_search'])->name('product_search');

Route::post('contact', [WebController::class, 'contact_mail'])->name('contact');

/*ECOMMERCE DYNAMIC PORTION*/

Route::resource('slider', 'SliderController');

Route::resource('page', 'PageController');

Route::resource('info', 'InfoController');

Route::resource('faqs', 'FaqController');

//blogs
Route::resource('blogs', BlogController::class);
Route::resource('blog_cat', BlogCatController::class);

Route::resource('adds', 'AddController');

Route::resource('dcs', 'DeliveryChargeController');

Route::get('/order_now/{id}', [WebController::class, 'order_now']);

Route::get('/check_out', [WebController::class, 'check_out'])->name('check_out');

Route::post('/process-checkout', [WebController::class, 'processCheckout'])->name('process_checkout');

Route::post('customer_store', [WebController::class, 'customer_store'])->name('customer_store');

Route::post('/update_order_now_quantity/{id}', [WebController::class, 'update_order_now_quantity'])->name('update_order_now_quantity');

Route::post('/update-cart-item', [WebController::class, 'updateCartItem'])->name('cart.update');

Route::resource('review', 'ReviewController');

//payment gateway routes

/*stripe*/
Route::get('stripe', [StripePaymentController::class, 'index']);
Route::post('stripe', [StripePaymentController::class, 'processPayment'])->name('stripe.payment');
Route::get('stripe/success', [StripePaymentController::class, 'paymentSuccess'])->name('stripe.success');
Route::get('stripe/failure', [StripePaymentController::class, 'paymentFailure'])->name('stripe.failure');
Route::post('stripe/create-payment-intent', [StripePaymentController::class, 'createPaymentIntent'])->name('stripe.intent');
Route::post('/record-payment', [StripePaymentController::class, 'recordPayment'])->name('stripe.record');

/*ssl*/
Route::post('/success', [SslCommerzPaymentController::class, 'success']);
Route::post('/fail', [SslCommerzPaymentController::class, 'fail']);
Route::post('/cancel', [SslCommerzPaymentController::class, 'cancel']);
Route::post('/ipn', [SslCommerzPaymentController::class, 'ipn']);

/*bkash*/

Route::get('/bkash/pay', [BkashController::class, 'payment'])->name('url-pay');
Route::post('/bkash/create', [BkashController::class, 'createPayment'])->name('url-create');
Route::get('/bkash/callback', [BkashController::class, 'callback'])->name('url-callback');

// Checkout (URL) Admin Part
Route::get('/bkash/refund', [BkashController::class, 'getRefund'])->name('url-get-refund');
Route::post('/bkash/refund', [BkashController::class, 'refundPayment'])->name('url-post-refund');
Route::post('/bkash/search', [BkashController::class, 'searchTransaction'])->name('url-post-search');


//paypal
Route::get('/paypal/checkout', [PayPalController::class, 'createTransaction'])->name('paypal.checkout');
Route::get('/paypal/success', [PayPalController::class, 'successTransaction'])->name('paypal.success');
Route::get('/paypal/cancel', [PayPalController::class, 'cancelTransaction'])->name('paypal.cancel');


