@extends('layout.main') @section('content')

@if(session()->has('not_permitted'))
  <div class="alert alert-danger alert-dismissible text-center"><button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>{{ session()->get('not_permitted') }}</div> 
@endif
<section class="forms">
    <div class="container-fluid">
        <div class="row">
            <div class="col-md-12">
                <div class="card">
                    <div class="card-header d-flex align-items-center">
                        <h4>Update Slider</h4>
                    </div>
                    <div class="card-body">
                        <p class="italic"><small>{{trans('file.The field labels marked with * are required input fields')}}.</small></p>
                        {!! Form::open(['route' => ['volunteer.update', $lims_user_data->id], 'method' => 'put', 'files' => true]) !!}
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label><strong>Name</strong> </label>
                                        <input value="{{$lims_user_data->title}}" type="text" name="title" required class="form-control" >
                                        @if($errors->has('title'))
                                       <span>
                                           <strong>{{ $errors->first('title') }}</strong>
                                        </span>
                                        @endif
                                    </div>
                                    <div class="form-group">
                                        <label><strong>Job title</strong> </label>
                                        <input type="text" name="details" class="form-control" value="{{$lims_user_data->details}}">
                                        @if($errors->has('details'))
                                       <span>
                                           <strong>{{ $errors->first('details') }}</strong>
                                        </span>
                                        @endif
                                    </div>
                                    <div class="form-group">
                                        <label><strong>Image *</strong> </label>
                                        <input type="file" name="thumb"  class="form-control" value="{{$lims_user_data->thumb}}">
                                        @if($errors->has('thumb'))
                                       <span>
                                           <strong>{{ $errors->first('thumb') }}</strong>
                                        </span>
                                        @endif
                                    </div>
                                    <div class="form-group">
                                        <label><strong>Current Page Image</strong></label>
                                        <div>
                                            <img src="{{ asset('storage/app/' . $lims_user_data->thumb) }}" alt="Page Image" style="max-width: 200px; max-height: 200px;">
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label><strong>Facbook</strong> </label>
                                        <input type="text" name="facbook"  class="form-control" value="{{$lims_user_data->facebook}}">
                                        @if($errors->has('facebook'))
                                       <span>
                                           <strong>{{ $errors->first('facebook') }}</strong>
                                        </span>
                                        @endif
                                    </div>

                                    <div class="form-group">
                                        <label><strong>Twitter </strong> </label>
                                        <input type="text" name="twitter"  class="form-control" value="{{$lims_user_data->twitter}}">
                                        @if($errors->has('twitter'))
                                       <span>
                                           <strong>{{ $errors->first('twitter') }}</strong>
                                        </span>
                                        @endif
                                    </div>
                                    <div class="form-group">
                                        <label><strong>Instagram </strong> </label>
                                        <input type="text" name="insta"  class="form-control" value="{{$lims_user_data->insta}}">
                                        @if($errors->has('insta'))
                                       <span>
                                           <strong>{{ $errors->first('insta') }}</strong>
                                        </span>
                                        @endif
                                    </div>
                                    <div class="form-group">
                                        <label><strong>Linked_in</strong> </label>
                                        <input type="text" name="linked_in"  class="form-control" value="{{$lims_user_data->linked_in}}">
                                        @if($errors->has('linked_in'))
                                       <span>
                                           <strong>{{ $errors->first('linked_in') }}</strong>
                                        </span>
                                        @endif
                                    </div>

                                    <div class="form-group">
                                        <input type="submit" value="{{trans('file.submit')}}" class="btn btn-primary">
                                    </div>
                                </div>                           
                            </div>
                        {!! Form::close() !!}
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<script type="text/javascript">
    $("ul#people").siblings('a').attr('aria-expanded','true');
    $("ul#people").addClass("show");
    $('#biller-id').hide();
    $('#warehouseId').hide();
    
    

    $('select[name=role_id]').val($("input[name='role_id_hidden']").val());
    if($('select[name=role_id]').val() > 2){
        $('#warehouseId').show();
        $('select[name=warehouse_id]').val($("input[name='warehouse_id_hidden']").val());
        $('#biller-id').show();
        $('select[name=biller_id]').val($("input[name='biller_id_hidden']").val());
    }
    $('.selectpicker').selectpicker('refresh');

    $('select[name="role_id"]').on('change', function() {
        if($(this).val() > 2){
            $('select[name="warehouse_id"]').prop('required',true);
            $('select[name="biller_id"]').prop('required',true);
            $('#biller-id').show();
            $('#warehouseId').show();
        }
        else{
            $('select[name="warehouse_id"]').prop('required',false);
            $('select[name="biller_id"]').prop('required',false);
            $('#biller-id').hide();
            $('#warehouseId').hide();
        }
    });

    $('#genbutton').on("click", function(){
      $.get('../genpass', function(data){
        $("input[name='password']").val(data);
      });
    });

</script>
@endsection