@extends('layout.main') @section('content')
@if(session()->has('message'))
  <div class="alert alert-success alert-dismissible text-center"><button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>{!! session()->get('message') !!}</div> 
@endif
<section class="forms">
    <div class="container-fluid">
        <h3>Receivable Loan Report</h3>
        
    </div>
    <div class="table-responsive mb-4">
        <table id="account-table" class="table table-hover">
            <thead>
                <tr>
                    <th class="not-exported"></th>
                    <th>{{trans('file.date')}}</th>
                    <th>Reference no.</th>
                    <th>Details</th>
                    <th>Due</th>
                    <th>Paid</th>
                </tr>
            </thead>
            <tbody>
                @foreach($lims_payable_loans as $key=>$loan)
                <?php 
                    $installments = App\ReceivableLoanInstallment::where('loan_id',$loan->id)->get();
                    $paid = App\ReceivableLoanInstallment::where('loan_id',$loan->id)->sum('amount');
                    $due = $loan->amount - $paid;
                    $outstanding = $due - $paid;

                ?>
                
                <tr class="loan-link" data-loan='["{{$loan->id}}", "{{$loan->amount}}", "{{$loan->due_date}}", "{{$loan->reference_no}}","{{$loan->borrowed_from}}", "{{$loan->interest_rate}}", "{{$loan->no_of_installments}}"]'>
                    <td>{{$key}}</td>
                    <td>{{$loan->date}}</td>
                    <td>{{$loan->reference_no}}</td>
                    <td>{{$loan->note}}</td>
                    <td>{{$due}}</td>
                    <td>{{$paid}}</td>
                </tr>
                @endforeach

            </tbody>
        </table>
    </div>
</section>

<div id="payable-loan-details" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true" class="modal fade text-left">
    <div role="document" class="modal-dialog">
      <div class="modal-content">
        <div class="container mt-3 pb-2 border-bottom">
            <div class="row">
                <div class="col-md-3">
                </div>
                <div class="col-md-6">
                    <h3 id="exampleModalLabel" class="modal-title text-center container-fluid">{{$general_setting->site_title}}</h3>
                </div>
                <div class="col-md-3">
                    <button type="button" id="close-btn" data-dismiss="modal" aria-label="Close" class="close d-print-none"><span aria-hidden="true"><i class="dripicons-cross"></i></span></button>
                </div>
                <div class="col-md-12 text-center">
                    <i style="font-size: 15px;">Receivable Loan Installments</i>
                </div>
            </div>
        </div>
            <div id="payable-loan-content" class="modal-body">
            </div>
            <br>
            <table class="table table-bordered payable-loan-list">
                <thead>
                    <th>#</th>
                    <th>Date</th>
                    <th>Amount</th>
                    <th>Payment Method</th>
                    <th>Remark</th>
                </thead>
                <tbody>
                </tbody>
            </table>
            
      </div>
    </div>
</div>

<script type="text/javascript">
    $("ul#report").siblings('a').attr('aria-expanded','true');
    $("ul#report").addClass("show");
    $("ul#report #receivableloan-report-menu").addClass("active");

    $("tr.loan-link td:not(:first-child, :last-child)").on("click", function(){
        var loan = $(this).parent().data('loan');
        loanDetails(loan);
    });

    function loanDetails(loan){
        $('input[name="loan_id"]').val(loan[0]);
        var htmltext = '<br><strong>{{trans("file.reference")}}: </strong>'+loan[3]+'<br><strong>Total Amount: </strong>'+loan[1]+'<br><strong>Interest Rate: </strong>'+loan[5]+'<br><strong>Number of Installments: </strong>'+loan[6]+'<br><br><div class="row"><div class="col-md-6"><strong>Borrowed {{trans("file.From")}}:</strong><br>'+loan[4]+'<br></div></div></div>';
        $.get('../receivable_loan/details/' + loan[0], function(data){
            $(".payable-loan-list tbody").remove();
            var amount = data[0];
            var date = data[1];
            var remark = data[2];
            var payment_method = data[3];
        
            var newBody = $("<tbody>");
            $.each(amount, function(index){
                var newRow = $("<tr>");
                var cols = '';
                cols += '<td><strong>' + (index+1) + '</strong></td>';
                cols += '<td>' + date[index] + '</td>';
                cols += '<td>' + amount[index] + '</td>';
                cols += '<td>' + payment_method[index] + '</td>';
                cols += '<td>' + remark[index] + '</td>';
                newRow.append(cols);
                newBody.append(newRow);
            });

            $("table.payable-loan-list").append(newBody);
        });
        
        $('#payable-loan-content').html(htmltext);
        $('#payable-loan-details').modal('show');
    }

    var table = $('#account-table').DataTable( {
        "order": [],
        'language': {
            'lengthMenu': '_MENU_ {{trans("file.records per page")}}',
             "info":      '<small>{{trans("file.Showing")}} _START_ - _END_ (_TOTAL_)</small>',
            "search":  '{{trans("file.Search")}}',
            'paginate': {
                    'previous': '<i class="dripicons-chevron-left"></i>',
                    'next': '<i class="dripicons-chevron-right"></i>'
            }
        },
        'columnDefs': [
            {
                "orderable": false,
                'targets': 0
            },
            {
                'render': function(data, type, row, meta){
                    if(type === 'display'){
                        data = '<div class="checkbox"><input type="checkbox" class="dt-checkboxes"><label></label></div>';
                    }

                   return data;
                },
                'checkboxes': {
                   'selectRow': true,
                   'selectAllRender': '<div class="checkbox"><input type="checkbox" class="dt-checkboxes"><label></label></div>'
                },
                'targets': [0]
            }
        ],
        'select': { style: 'multi',  selector: 'td:first-child'},
        'lengthMenu': [[10, 25, 50, -1], [10, 25, 50, "All"]],
        dom: '<"row"lfB>rtip',
        buttons: [
            {
                extend: 'pdf',
                text: '{{trans("file.PDF")}}',
                exportOptions: {
                    columns: ':visible:Not(.not-exported)',
                    rows: ':visible'
                }
            },
            {
                extend: 'csv',
                text: '{{trans("file.CSV")}}',
                exportOptions: {
                    columns: ':visible:Not(.not-exported)',
                    rows: ':visible'
                }
            },
            {
                extend: 'print',
                text: '{{trans("file.Print")}}',
                exportOptions: {
                    columns: ':visible:Not(.not-exported)',
                    rows: ':visible'
                }
            },
            {
                extend: 'colvis',
                text: '{{trans("file.Column visibility")}}',
                columns: ':gt(0)'
            },
        ],
    } );

</script>
@endsection