@extends('layout.main') @section('content')

<section class="forms">
    <div class="container-fluid">
        <div class="row">
            <div class="col-md-12">
                <div class="card">
                    <div class="card-header d-flex align-items-center">
                        <h4>Add Receivable Loan Installment</h4>
                    </div>
                    <div class="card-body">
                        <p class="italic"><small>{{trans('file.The field labels marked with * are required input fields')}}.</small></p>
                        {!! Form::open(['route' => 'receivable_loan.installment_store', 'method' => 'post', 'files' => true]) !!}
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Loan reference *</strong> </label>
                                    <input type="text" name="reference_no" value="{{$lims_recievable_loans->reference_no}}" disabled required class="form-control">
                                    <input type="hidden" name="loan_id" value="{{$lims_recievable_loans->id}}">
                                </div>
                            </div>
                           
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Amount *</label>
                                    <input type="text" name="amount" required class="form-control">
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Date *</label>
                                    <input type="date" name="date" required class="form-control">
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Payment Method *</label>
                                    <div class="input-group">
                                          <select name="received_method" class="selectpicker form-control" data-live-search="true" data-live-search-style="begins" title="Select Payment Method..." required>
                                                <option value="Bank">Bank</option>
                                                <option value="Cash">Cash</option>
                                                <option value="bKash">bKash</option>
                                                <option value="Nagad">Nagad</option>
                                          </select>
                                    </div>
                                </div>
                            </div>
                            
                           <div class="col-md-6">
                                <div class="form-group">
                                    <label>Remark</strong> </label>
                                    <textarea rows="5" class="form-control" name="remark"></textarea>
                                </div>
                            </div>
                            
                            
                            <div class="col-md-12">
                                <div class="form-group mt-4">
                                    <input type="submit" value="{{trans('file.submit')}}" class="btn btn-primary">
                                </div>
                            </div>
                        </div>
                        {!! Form::close() !!}
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<script type="text/javascript">
    $("ul#account").siblings('a').attr('aria-expanded','true');
    $("ul#account").addClass("show");
    $("ul#account #receivableloan-list-menu").addClass("active");
</script>
@endsection