@extends('layout.main')

@section('content')

@if(session()->has('success'))
  <div class="alert alert-success alert-dismissible text-center">
      <button type="button" class="close" data-dismiss="alert" aria-label="Close">
          <span aria-hidden="true">&times;</span>
      </button>
      {{ session()->get('success') }}
  </div> 
@endif

<section class="forms">
    <div class="container-fluid">
        <div class="row">
            <div class="col-md-12">
                <div class="card">
                    <div class="card-header d-flex align-items-center">
                        <h4>SEO Settings for Page: {{ $page->name }}</h4>
                    </div>
                    <div class="card-body">
                        <p class="italic"><small>Fields marked with * are optional but recommended for SEO.</small></p>

                        {!! Form::open(['route' => ['page.seo_meta.update', $page->id], 'method' => 'post']) !!}

                        {!! Form::hidden('model_type', \App\Models\Page::class) !!}
                        {!! Form::hidden('model_id', $page->id) !!}

                        <div class="row">

                            {{-- Slug --}}
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label>URL Slug</label>
                                    <div class="input-group">
                                        <div class="input-group-prepend">
                                            <span class="input-group-text">{{ url('/') }}/pages/{{$page->id}}/</span>
                                        </div>
                                        <input type="text" name="slug" class="form-control"
                                            value="{{ $seo->slug ?? \Illuminate\Support\Str::slug($page->name) }}">
                                    </div>
                                    
                                </div>
                            </div>

                            {{-- Meta Title --}}
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Meta Title</label>
                                    <input type="text" name="title" class="form-control" 
                                           value="{{ $seo->title ?? '' }}">
                                </div>
                            </div>

                            {{-- Meta Description --}}
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Meta Description</label>
                                    <textarea name="meta_description" rows="3" class="form-control">{{ $seo->meta_description ?? '' }}</textarea>
                                </div>
                            </div>

                            {{-- Meta Keywords --}}
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Meta Keywords (comma separated)</label>
                                    <input type="text" name="meta_keywords" class="form-control"
                                           value="{{ $seo->meta_keywords ?? '' }}">
                                </div>
                            </div>

                            {{-- Canonical URL --}}
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Canonical URL</label>
                                    <input type="text" name="canonical_url" class="form-control"
                                           value="{{ $seo->canonical_url ?? '' }}">
                                </div>
                            </div>

                            {{-- Robots --}}
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Robots Directive</label>
                                    <select name="robots" class="form-control">
                                        <option value="" {{ empty($seo->robots) ? 'selected' : '' }}>-- Select --</option>
                                        <option value="index, follow" {{ ($seo->robots ?? '') == 'index, follow' ? 'selected' : '' }}>index, follow</option>
                                        <option value="noindex, follow" {{ ($seo->robots ?? '') == 'noindex, follow' ? 'selected' : '' }}>noindex, follow</option>
                                        <option value="index, nofollow" {{ ($seo->robots ?? '') == 'index, nofollow' ? 'selected' : '' }}>index, nofollow</option>
                                        <option value="noindex, nofollow" {{ ($seo->robots ?? '') == 'noindex, nofollow' ? 'selected' : '' }}>noindex, nofollow</option>
                                    </select>
                                </div>
                            </div>

                            {{-- Custom Head Script --}}
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label>Custom &lt;head&gt; Script (optional)</label>
                                    <textarea name="custom_head_script" rows="4" class="form-control">{{ $seo->custom_head_script ?? '' }}</textarea>
                                </div>
                            </div>

                            {{-- Submit --}}
                            <div class="form-group col-md-12">
                                <button type="submit" class="btn btn-primary">Save SEO</button>
                                <a href="{{ route('products.index') }}" class="btn btn-secondary">Back to Products</a>
                            </div>

                        </div>

                        {!! Form::close() !!}
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<script type="text/javascript">
    $("ul#product").siblings('a').attr('aria-expanded','true');
    $("ul#product").addClass("show");
    $("ul#product #product-seo-menu").addClass("active");
</script>

@endsection
