@extends('layout.main') @section('content')

<section>
    <div class="container-fluid">
        <!-- Trigger the modal with a button -->
        <a href="{{route('page.create')}}" class="btn btn-info"><i class="dripicons-plus"></i> Add Page</a>
    </div>
    <div class="table-responsive">
        <table id="page-table" class="table" style="width: 100%">
            <thead>
                <tr>
                    <th class="not-exported"></th>
                    <th>name</th>
                    <th>image</th>
                    <th class="not-exported">{{trans('file.action')}}</th>
                </tr>
            </thead>
            <tbody>
                @php $serialNumber = 1; @endphp <!-- Initialize serial number -->
                @foreach($lims_pages_all ?? [] as $page)
                <tr>
                    <tr data-id="{{ $page->id }}">
                    <td>{{ $serialNumber }}</td> <!-- Display serial number -->
                    <td>{{ $page->name }}</td>

                    <td>
                        <div class="d-flex align-items-center">
                            <div class="recent-product-img">
                                <img src="{{ url('storage/app/'.$page->thumb) }}" alt="" style="width: 90px; height: 90px;">
                            </div>
                        </div>
                    </td>

                    <td>
                        <div class="btn-group">
                            <button type="button" class="btn btn-default btn-sm dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">{{trans('file.action')}}
                                <span class="caret"></span>
                                <span class="sr-only">Toggle Dropdown</span>
                            </button>
                            <ul class="dropdown-menu edit-options dropdown-menu-right dropdown-default" user="menu">
                             
                                <li>
                                    <a href="{{ route('page.edit', $page->id) }}" class="btn btn-link"><i class="dripicons-document-edit"></i> {{trans('file.edit')}}</a>
                                </li>
                                <?php
                                    $role = DB::table('roles')->find(Auth::user()->role_id);
                                    $seo = DB::table('permissions')->where('name', 'seo')->first();
                                    $seo_active = null;
                                    if ($seo) {
                                        $seo_active = DB::table('role_has_permissions')->where([
                                            ['permission_id', $seo->id],
                                            ['role_id', $role->id]
                                        ])->first();
                                    }
                                ?>
                                @if(!empty($seo_active))
                                <li>
                                    <a href="{{ route('page.seo_meta', $page->id) }}" class="btn btn-link"><i class="dripicons-document-edit"></i> SEO</a>
                                </li>
                                @endif
                                <li class="divider"></li>
                               
                                {{ Form::open(['route' => ['page.destroy', $page->id], 'method' => 'DELETE'] ) }}
                                @if($page->id > 2 && $page->id != 9)
                                    <li>
                                        <button type="submit" class="btn btn-link" onclick="return confirmDelete()"><i class="dripicons-trash"></i> {{trans('file.delete')}}</button>
                                    </li>
                                @endif
                                {{ Form::close() }}
                               
                            </ul>
                        </div>
                    </td>
                </tr>
                @php $serialNumber++; @endphp <!-- Increment serial number -->
                @endforeach
                <?php
                    $seopages = App\SeoMeta::whereNull('model_id')->get();
                ?>

                @foreach($seopages as $seopage)
                @if(!empty($seo_active))
                    <tr data-id="{{ $seopage->id }}">
                        <td>00</td> <!-- Display serial number -->
                        <td>{{ $seopage->model_type }}</td>
                        <td>N/A</td>
                        <td>
                            <div class="btn-group">
                                <button type="button" class="btn btn-default btn-sm dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">{{trans('file.action')}}
                                    <span class="caret"></span>
                                    <span class="sr-only">Toggle Dropdown</span>
                                </button>
                                <ul class="dropdown-menu edit-options dropdown-menu-right dropdown-default" user="menu">
                                    <li>
                                        <a href="{{ route('staticpage.seo_meta', $seopage->id) }}" class="btn btn-link"><i class="dripicons-document-edit"></i> SEO</a>
                                    </li>
                                </ul>
                            </div>
                        </td>
                    </tr>
                @endif
                @endforeach
            </tbody>

        </table>
    </div>
</section>




<script type="text/javascript">
    $("ul#cms").siblings('a').attr('aria-expanded','true');
    $("ul#cms").addClass("show");
    $("ul#cms #page-menu").addClass("active");

    function confirmDelete() {
      if (confirm("If you delete category all products under this category will also be deleted. Are you sure want to delete?")) {
          return true;
      }
      return false;
    }

    var category_id = [];
    var user_verified = <?php echo json_encode(env('USER_VERIFIED')) ?>;
    
    $.ajaxSetup({
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        }
    });
    $(document).on("click", ".open-EditCategoryDialog", function(){
          var url ="category/";
          var id = $(this).data('id').toString();
          url = url.concat(id).concat("/edit");
          
          $.get(url, function(data){
            $("#editModal input[name='name']").val(data['name']);
            $("#editModal select[name='parent_id']").val(data['parent_id']);
            $("#editModal input[name='category_id']").val(data['id']);
            $('.selectpicker').selectpicker('refresh');
          });
    });

  $('#page-table').DataTable( {
        "order": [],
        'language': {
            'lengthMenu': '_MENU_ {{trans("file.records per page")}}',
             "info":      '<small>{{trans("file.Showing")}} _START_ - _END_ (_TOTAL_)</small>',
            "search":  '{{trans("file.Search")}}',
            'paginate': {
                    'previous': '<i class="dripicons-chevron-left"></i>',
                    'next': '<i class="dripicons-chevron-right"></i>'
            }
        },
        'columnDefs': [
            {
                "orderable": false,
                'targets': [0, 7]
            },
            {
                'render': function(data, type, row, meta){
                    if(type === 'display'){
                        data = '<div class="checkbox"><input type="checkbox" class="dt-checkboxes"><label></label></div>';
                    }

                   return data;
                },
                'checkboxes': {
                   'selectRow': true,
                   'selectAllRender': '<div class="checkbox"><input type="checkbox" class="dt-checkboxes"><label></label></div>'
                },
                'targets': [0]
            }
        ],
        'select': { style: 'multi',  selector: 'td:first-child'},
        'lengthMenu': [[10, 25, 50, -1], [10, 25, 50, "All"]],
        dom: '<"row"lfB>rtip',
        buttons: [
            {
                extend: 'pdf',
                text: '{{trans("file.PDF")}}',
                exportOptions: {
                    columns: ':visible:Not(.not-exported)',
                    rows: ':visible'
                },
            },
            {
                extend: 'csv',
                text: '{{trans("file.CSV")}}',
                exportOptions: {
                    columns: ':visible:Not(.not-exported)',
                    rows: ':visible'
                },
            },
            {
                extend: 'print',
                text: '{{trans("file.Print")}}',
                exportOptions: {
                    columns: ':visible:Not(.not-exported)',
                    rows: ':visible'
                },
            },
            {
                text: '{{trans("file.delete")}}',
                className: 'buttons-delete',
                action: function ( e, dt, node, config ) {
                    if(user_verified == '1') {
                        user_id.length = 0;
                        $(':checkbox:checked').each(function(i){
                            if(i){
                                user_id[i-1] = $(this).closest('tr').data('id');
                            }
                        });
                        if(user_id.length && confirm("Are you sure want to delete?")) {
                            $.ajax({
                                type:'POST',
                                url:'user/deletebyselection',
                                data:{
                                    userIdArray: user_id
                                },
                                success:function(data){
                                    alert(data);
                                }
                            });
                            dt.rows({ page: 'current', selected: true }).remove().draw(false);
                        }
                        else if(!user_id.length)
                            alert('No user is selected!');
                    }
                    else
                        alert('This feature is disable for demo!');
                }
            },
            {
                extend: 'colvis',
                text: '{{trans("file.Column visibility")}}',
                columns: ':gt(0)'
            },
        ],
    } );
  if(all_permission.indexOf("users-delete") == -1)
        $('.buttons-delete').addClass('d-none');
</script>
@endsection