<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title>Payment Receipt</title>
    <style>
        body { font-family: Arial, sans-serif; color: #333; }
        .container { padding: 20px; }
        h2 { color: #4CAF50; }
        table { width: 100%; border-collapse: collapse; margin-top: 20px; }
        th, td { border: 1px solid #ddd; padding: 10px; text-align: left; }
        th { background-color: #f2f2f2; }
    </style>
</head>
<body>
    <div class="container">
        <h2>Thank you for your purchase!</h2>

        <p><strong>Invoice ID:</strong> {{ $sale->id }}</p>
        <p><strong>Payment Method:</strong> Paypal</p>
        <p><strong>Transaction ID:</strong> {{ $payment->payment_note }}</p>

        <h3>Sale Summary</h3>
        <table>
            <tr>
                <th>Total Amount</th>
                <th>Paid Amount</th>
                <th>Status</th>
            </tr>
            <tr>
                <td>${{ number_format($sale->grand_total, 2) }}</td>
                <td>${{ number_format($sale->paid_amount, 2) }}</td>
                <td>
                    @if($sale->payment_status == 4)
                        Paid
                    @elseif($sale->payment_status == 2)
                        Partially Paid
                    @else
                        Unpaid
                    @endif
                </td>
            </tr>
        </table>

        <p style="margin-top: 30px;">If you have any questions, feel free to contact us.</p>
    </div>
</body>
</html>
