@extends('layout.main') @section('content')

<section class="forms">
    <div class="container-fluid">
        <div class="row">
            <div class="col-md-12">
                <div class="card">
                    <div class="card-header d-flex align-items-center">
                        <h4>Add Investment</h4>
                    </div>
                    <div class="card-body">
                        <p class="italic"><small>{{trans('file.The field labels marked with * are required input fields')}}.</small></p>
                        {!! Form::open(['route' => 'investment.store', 'method' => 'post', 'files' => true]) !!}
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Investment Ref *</strong> </label>
                                    <input type="text" name="investment_id" required class="form-control">
                                </div>
                            </div>
                            <?php $investors= App\Investor::get(); ?>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Investor *</label>
                                        <div class="input-group">
                                          <select name="investor_id" class="selectpicker form-control" data-live-search="true" data-live-search-style="begins" title="Select Investor...">
                                            @foreach($investors as $investor)
                                                <option value="{{$investor->id}}">{{$investor->investor_name}}</option>
                                            @endforeach    
                                          </select>
                                        </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Amount *</label>
                                    <input type="text" name="amount" required class="form-control">
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Date *</label>
                                    <input type="date" name="date" required class="form-control">
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Payment Methode *</label>
                                    <div class="input-group">
                                          <select name="payment_method" class="selectpicker form-control" data-live-search="true" data-live-search-style="begins" title="Select Investor...">
                                                <option value="Bank">Bank</option>
                                                <option value="bKash">bKash</option>
                                                <option value="Nagad">Nagad</option>
                                          </select>
                                        </div>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Account ID *</label>
                                    <div class="input-group">
                                          <select name="account_id" class="selectpicker form-control" data-live-search="true" data-live-search-style="begins" title="Select Account...">
                                            @foreach($account as $acc)
                                                <option value="{{$acc->id}}">{{$acc->name}} ({{ $acc->account_no}})</option>
                                            @endforeach    
                                          </select>
                                    </div>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Option *</label>
                                        <div class="input-group">
                                          <select name="option" class="selectpicker form-control" data-live-search="true" data-live-search-style="begins" title="Select Option...">
                                                <option value="Withdraw">Withdraw</option>
                                                <option value="Deposit">Deposit</option>
                                          </select>
                                      </div>  
                                </div>
                            </div>
                            
                            <div class="col-md-12">
                                <div class="form-group mt-4">
                                    <input type="submit" value="{{trans('file.submit')}}" class="btn btn-primary">
                                </div>
                            </div>
                        </div>
                        {!! Form::close() !!}
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<script type="text/javascript">
    $("ul#account").siblings('a').attr('aria-expanded','true');
    $("ul#account").addClass("show");
    $("ul#account #investment-list-menu").addClass("active");
</script>
@endsection