<!DOCTYPE html>
<html>
<head>
    <title>Stripe Elements</title>
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <script src="https://js.stripe.com/v3/"></script>
</head>
<body>

@if (session('success'))
    <div>{{ session('success') }}</div>
@endif

<form id="payment-form">
    <div id="card-element"></div>
    <button id="submit">Pay $100</button>
</form>

<script>
    const stripe = Stripe("{{ config('services.stripe.key') }}");
    const elements = stripe.elements();
    const card = elements.create('card');
    card.mount('#card-element');

    const form = document.getElementById('payment-form');
    const submitBtn = document.getElementById('submit');

    form.addEventListener('submit', async (e) => {
        e.preventDefault();
        submitBtn.disabled = true;

        const {paymentMethod, error} = await stripe.createPaymentMethod({
            type: 'card',
            card: card,
        });

        if (error) {
            alert(error.message);
            submitBtn.disabled = false;
        } else {
            fetch("{{ route('stripe.post') }}", {
                method: "POST",
                headers: {
                    "Content-Type": "application/json",
                    "X-CSRF-TOKEN": document.querySelector('meta[name="csrf-token"]').getAttribute('content')
                },
                body: JSON.stringify({
                    payment_method: paymentMethod.id
                })
            }).then(response => response.json())
              .then(data => {
                alert("Payment successful!");
                submitBtn.disabled = false;
              }).catch(err => {
                alert("Error processing payment.");
                submitBtn.disabled = false;
              });
        }
    });
</script>

</body>
</html>
