@include('front.layout.header')
@if(session()->has('success'))
    <div class="alert alert-danger alert-dismissible text-center"><button type="button" class="close" data-dismiss="alert"><span aria-hidden="true">&times;</span></button>{{ session()->get('success') }}</div> 
@endif
@if(session()->has('error'))
    <div class="alert alert-danger alert-dismissible text-center"><button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>{{ session()->get('error') }}</div> 
@endif
<!--Hero Section-->
    <div class="hero-section hero-background">
        <h1 class="page-title">Organic Fruits</h1>
    </div>

    <!--Navigation section-->
    <div class="container">
        <nav class="biolife-nav">
            <ul>
                <li class="nav-item"><a href="{{url('/')}}" class="permal-link">Home</a></li>
                
                <li class="nav-item"><span class="current-page">{{$product->name}}</span></li>
            </ul>
        </nav>
    </div>

    <div class="page-contain single-product">
        <div class="container">

            <!-- Main content -->
            <div id="main-content" class="main-content">
                
                <!-- summary info -->
                <div class="sumary-product single-layout">
                    <div class="media">

                        <ul class="biolife-carousel slider-for" data-slick='{"arrows":false,"dots":false,"slidesMargin":30,"slidesToShow":1,"slidesToScroll":1,"fade":true,"asNavFor":".slider-nav"}'>
                            <?php $images = explode(",", $product->image); ?>
                            @foreach($images as $key => $image)
                            <li><img src="{{url('public/images/product', $image)}}" alt="" width="500" height="500"></li>

                            @endforeach
                        </ul>
                        <ul class="biolife-carousel slider-nav" data-slick='{"arrows":false,"dots":false,"centerMode":false,"focusOnSelect":true,"slidesMargin":10,"slidesToShow":4,"slidesToScroll":1,"asNavFor":".slider-for"}'>
                            <?php $images = explode(",", $product->image); ?>
                            @foreach($images as $key => $image)
                            <li><img src="{{url('public/images/product', $image)}}" alt="{{$product->name}}" width="88" height="88"></li>
                            @endforeach
                        </ul>
                    </div>
                    <div class="product-attribute">
                        <h3 class="title">{{$product->name}}</h3>

                        @php
                            // Calculate width class for star bar — each star = 20%
                            $ratingPercent = round($averageRating) * 20; // e.g. 4.5 * 20 = 90
                            $ratingClass = "width-{$ratingPercent}percent"; // will become width-90percent etc.
                        @endphp

                        <div class="rating">
                            <p class="star-rating">
                                <span class="{{ $ratingClass }}"></span>
                            </p>
                            <span class="review-count">({{ $reviews->count() }} Reviews)</span>
                        </div>


                        <span class="sku">Sku: #{{$product->code}}</span>
                        <p class="excerpt">{!! $product->product_details1 !!}</p>
                        <div class="price">
                            @if($product->promotion_price != null)
                            <ins><span class="price-amount"><span class="currencySymbol">£</span>{{$product->promotion_price}}</span></ins>

                            <del><span class="price-amount"><span class="currencySymbol">£</span>{{$product->price}}</span></del>
                            @else
                            <ins><span class="price-amount"><span class="currencySymbol">£</span>{{$product->price}}</span></ins>
                            @endif
                        </div>
                       
                    </div>
                    
                    <form id="addItem{{$product->id}}" action="{{url('cart/addItem')}}" method="POST" class="from-cart">@csrf
                        <div class="action-form">
                            <div class="quantity-box">
                                <span class="title">Quantity:</span>
                                <div class="qty-input">
                                    <input 
                                        type="number" 
                                        name="quantity" 
                                        value="1" 
                                        min="1" 
                                        data-max_value="20" 
                                        data-min_value="1" 
                                        class="quantity-input"
                                        data-product-id="{{$product->id}}"
                                    >
                                </div>

                                <div class="total-price-contain">
                                    <span class="title">Total Price:</span>
                                    <p class="price" id="totalPrice{{$product->id}}">£{{ number_format($product->promotion_price ?? $product->price, 2) }}</p>
                                </div>

                                <div class="buttons">
                                    @if($product->is_variant == null && $product->qty > 0)
                                        <button type="submit" class="btn add-to-cart-btn">Add to Cart</button>
                                    @else
                                        <a href="#" class="btn add-to-cart-btn disabled">Out of Stock</a>
                                    @endif
                                </div>

                                <input type="hidden" name="product_id" value="{{$product->id}}">
                                <input type="hidden" name="name" value="{{$product->name}}">
                                @if($product->promotion_price != null)
                                    <input type="hidden" name="price" id="productPrice{{$product->id}}" value="{{$product->promotion_price}}">
                                @else
                                    <input type="hidden" name="price" id="productPrice{{$product->id}}" value="{{$product->price}}">
                                @endif
                                @if($product->is_variant != null)
                                    <input type="hidden" name="product_code" value="{{$product->product_code}}">
                                @endif
                            </div>
                        </div>
                    </form>
                </div>

                <!-- Tab info -->
                <div class="product-tabs single-layout biolife-tab-contain">
                    <div class="tab-head">
                        <ul class="tabs">
                            <li class="tab-element active"><a href="#tab_1st" class="tab-link">Products Descriptions</a></li>
                            
                            <li class="tab-element" ><a href="#tab_4th" class="tab-link">Customer Reviews <sup>({{$reviews->count()}})</sup></a></li>
                        </ul>
                    </div>
                    <div class="tab-content">
                        <div id="tab_1st" class="tab-contain desc-tab active">
                            <p class="desc">{!! $product->product_details2 !!}</p>
                            
                        </div>
                       
                      
                        <div id="tab_4th" class="tab-contain review-tab">
                            <div class="container">
                                <div class="row">
                                    <div class="col-lg-5 col-md-5 col-sm-6 col-xs-12">
                                        <div class="rating-info">
                                    <p class="index"><strong class="rating">{{round($averageRating)}}</strong>out of 5</p>
                                            <div class="rating"><p class="star-rating"><span class="width-{{$ratingPercent}}percent"></span></p></div>
                                            <p class="see-all">See all {{$reviews->count()}} reviews</p>
                                            <ul class="options">
                                                <li>
                                                    <div class="detail-for">
                                                        @foreach($reviews as $review)
                                                            <div class="review-item">
                                                                <h4 class="review-mini-title">{{$review->customer_name}}</h4>
                                                                
                                                                <p>{{$review->details}}</p>
                                                                <span class="review-date">Posted on {{$review->created_at->format($general_setting->date_format . ' H:i:s')}}</span>
                                                            </div>
                                                        @endforeach
                                                    </div>
                                                </li>
                                               
                                            </ul>
                                        </div>
                                    </div>
                                    @if(Auth::check())
                                    <div class="col-lg-7 col-md-7 col-sm-6 col-xs-12">
                                        <div class="review-form-wrapper">
                                            <span class="title">Submit your review</span>

                                            @php
                                                $user = Auth::user();
                                                $customer = App\Customer::where('user_id', $user->id)->first();
                                            @endphp

                                            @if($customer != null)
                                                <form action="{{ route('review.store') }}" name="frm-review" method="post">
                                                    @csrf
                                                    <input type="hidden" name="product_id" value="{{ $product->id }}">
                                                    <input type="hidden" name="customer_id" value="{{ $customer->id }}">
                                                    <input type="hidden" name="stars" id="rating-value" value="">

                                                    <div class="comment-form-rating">
                                                        <label>1. Your rating of this product:</label>
                                                        <p class="stars">
                                                            <span>
                                                                @for ($i = 1; $i <= 5; $i++)
                                                                    <a href="#" class="btn-rating" data-value="{{ $i }}"><i class="fa fa-star-o" aria-hidden="true"></i></a>
                                                                @endfor
                                                            </span>
                                                        </p>
                                                    </div>

                                                    <p class="form-row wide-half">
                                                        <input type="text" name="customer_name" value="{{ $customer->name }}" placeholder="Your name" required>
                                                    </p>

                                                    <p class="form-row wide-half">
                                                        <input type="email" name="email" value="{{ $customer->email }}" placeholder="Email address" readonly>
                                                    </p>

                                                    <p class="form-row">
                                                        <textarea name="details" id="txt-comment" cols="30" rows="10" placeholder="Write your review here..." required></textarea>
                                                    </p>

                                                    <p class="form-row">
                                                        <button type="submit" name="submit" class="btn">Submit Review</button>
                                                    </p>
                                                </form>
                                            @endif
                                            @else
                                                <div class="review-login-notice">
                                                    <h3>Login Or Register to give a review</h3>
                                                    <a href="{{ route('login') }}" class="btn">Login</a>
                                                    <a href="{{ route('register') }}" class="btn">Register</a>
                                                </div>
                                            @endif
                                        </div>
                                    </div>




                                <!-- <div id="comments">
                                    <ol class="commentlist">
                                        <li class="review">
                                            <div class="comment-container">
                                                <div class="row">
                                                    <div class="comment-content col-lg-8 col-md-9 col-sm-8 col-xs-12">
                                                        <p class="comment-in"><span class="post-name">Quality is our way of life</span><span class="post-date">01/04/2018</span></p>
                                                        <div class="rating"><p class="star-rating"><span class="width-80percent"></span></p></div>
                                                        <p class="author">by: <b>Shop organic</b></p>
                                                        <p class="comment-text">There are few things in life that please people more than the succulence of quality fresh fruit and vegetables.  At Fresh Fruits we work to deliver the world’s freshest, choicest, and juiciest produce to discerning customers across the UAE and GCC.</p>
                                                    </div>
                                                    <div class="comment-review-form col-lg-3 col-lg-offset-1 col-md-3 col-sm-4 col-xs-12">
                                                        <span class="title">Was this review helpful?</span>
                                                        <ul class="actions">
                                                            <li><a href="#" class="btn-act like" data-type="like"><i class="fa fa-thumbs-up" aria-hidden="true"></i>Yes (100)</a></li>
                                                            <li><a href="#" class="btn-act hate" data-type="dislike"><i class="fa fa-thumbs-down" aria-hidden="true"></i>No (20)</a></li>
                                                            <li><a href="#" class="btn-act report" data-type="dislike"><i class="fa fa-flag" aria-hidden="true"></i>Report</a></li>
                                                        </ul>
                                                    </div>
                                                </div>
                                            </div>
                                        </li>
                                        <li class="review">
                                            <div class="comment-container">
                                                <div class="row">
                                                    <div class="comment-content col-lg-8 col-md-9 col-sm-8 col-xs-12">
                                                        <p class="comment-in"><span class="post-name">Quality is our way of life</span><span class="post-date">01/04/2018</span></p>
                                                        <div class="rating"><p class="star-rating"><span class="width-80percent"></span></p></div>
                                                        <p class="author">by: <b>Shop organic</b></p>
                                                        <p class="comment-text">There are few things in life that please people more than the succulence of quality fresh fruit and vegetables.  At Fresh Fruits we work to deliver the world’s freshest, choicest, and juiciest produce to discerning customers across the UAE and GCC.</p>
                                                    </div>
                                                    <div class="comment-review-form col-lg-3 col-lg-offset-1 col-md-3 col-sm-4 col-xs-12">
                                                        <span class="title">Was this review helpful?</span>
                                                        <ul class="actions">
                                                            <li><a href="#" class="btn-act like" data-type="like"><i class="fa fa-thumbs-up" aria-hidden="true"></i>Yes (100)</a></li>
                                                            <li><a href="#" class="btn-act hate" data-type="dislike"><i class="fa fa-thumbs-down" aria-hidden="true"></i>No (20)</a></li>
                                                            <li><a href="#" class="btn-act report" data-type="dislike"><i class="fa fa-flag" aria-hidden="true"></i>Report</a></li>
                                                        </ul>
                                                    </div>
                                                </div>
                                            </div>
                                        </li>
                                        <li class="review">
                                            <div class="comment-container">
                                                <div class="row">
                                                    <div class="comment-content col-lg-8 col-md-9 col-sm-8 col-xs-12">
                                                        <p class="comment-in"><span class="post-name">Quality is our way of life</span><span class="post-date">01/04/2018</span></p>
                                                        <div class="rating"><p class="star-rating"><span class="width-80percent"></span></p></div>
                                                        <p class="author">by: <b>Shop organic</b></p>
                                                        <p class="comment-text">There are few things in life that please people more than the succulence of quality fresh fruit and vegetables.  At Fresh Fruits we work to deliver the world’s freshest, choicest, and juiciest produce to discerning customers across the UAE and GCC.</p>
                                                    </div>
                                                    <div class="comment-review-form col-lg-3 col-lg-offset-1 col-md-3 col-sm-4 col-xs-12">
                                                        <span class="title">Was this review helpful?</span>
                                                        <ul class="actions">
                                                            <li><a href="#" class="btn-act like" data-type="like"><i class="fa fa-thumbs-up" aria-hidden="true"></i>Yes (100)</a></li>
                                                            <li><a href="#" class="btn-act hate" data-type="dislike"><i class="fa fa-thumbs-down" aria-hidden="true"></i>No (20)</a></li>
                                                            <li><a href="#" class="btn-act report" data-type="dislike"><i class="fa fa-flag" aria-hidden="true"></i>Report</a></li>
                                                        </ul>
                                                    </div>
                                                </div>
                                            </div>
                                        </li>
                                    </ol>
                                    <div class="biolife-panigations-block version-2">
                                        <ul class="panigation-contain">
                                            <li><span class="current-page">1</span></li>
                                            <li><a href="#" class="link-page">2</a></li>
                                            <li><a href="#" class="link-page">3</a></li>
                                            <li><span class="sep">....</span></li>
                                            <li><a href="#" class="link-page">20</a></li>
                                            <li><a href="#" class="link-page next"><i class="fa fa-angle-right" aria-hidden="true"></i></a></li>
                                        </ul>
                                        <div class="result-count">
                                            <p class="txt-count"><b>1-5</b> of <b>126</b> reviews</p>
                                            <a href="#" class="link-to">See all<i class="fa fa-caret-right" aria-hidden="true"></i></a>
                                        </div>
                                    </div>
                                </div> -->
                            </div>
                        </div>
                    </div>
                </div>

                <!-- related products -->
                <div class="product-related-box single-layout">
                    <div class="biolife-title-box lg-margin-bottom-26px-im">
                        <span class="biolife-icon icon-organic"></span>
                        <span class="subtitle">All the best item for You</span>
                        <h3 class="main-title">Related Products</h3>
                    </div>
                    <ul class="products-list biolife-carousel nav-center-02 nav-none-on-mobile" data-slick='{"rows":1,"arrows":true,"dots":false,"infinite":false,"speed":400,"slidesMargin":0,"slidesToShow":5, "responsive":[{"breakpoint":1200, "settings":{ "slidesToShow": 4}},{"breakpoint":992, "settings":{ "slidesToShow": 3, "slidesMargin":20 }},{"breakpoint":768, "settings":{ "slidesToShow": 2, "slidesMargin":10}}]}'>
                        @foreach($related_products as $related)
                        <li class="product-item">
                            <div class="contain-product layout-default">
                                <?php $images = explode(",", $related->image);$primaryImage = isset($images[0]) ? $images[0] : '';?>
                                <div class="product-thumb">
                                    <a href="{{url('/single-product')}}/{{$related->id}}" class="link-to-product">
                                        <img src="{{ url('public/images/product', $primaryImage) }}" alt="dd" width="270" height="270" class="product-thumnail">
                                    </a>
                                </div>
                                <div class="info">
                                    <b class="categories">Fresh Fruit</b>
                                    <h4 class="product-title"><a href="{{url('/single-product')}}/{{$related->id}}" class="pr-name">{{$related->name}}</a></h4>
                                    <div class="price">
                                       @if($product->promotion_price != null)
                                        <ins><span class="price-amount"><span class="currencySymbol">£</span>{{$product->promotion_price}}</span></ins>

                                        <del><span class="price-amount"><span class="currencySymbol">£</span>{{$product->price}}</span></del>
                                        @else
                                        <ins><span class="price-amount"><span class="currencySymbol">£</span>{{$product->price}}</span></ins>
                                        @endif
                                    </div>
                                    <div class="slide-down-box">
                                        <p class="message">All products are carefully selected to ensure food safety.</p>
                                        <div class="buttons">
                                            <a href="#" class="btn wishlist-btn"><i class="fa fa-heart" aria-hidden="true"></i></a>

                                            <a href="#" class="btn add-to-cart-btn"><i class="fa fa-cart-arrow-down" aria-hidden="true"></i>add to cart</a>
                                            
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </li>
                         @endforeach

                    </ul>
                </div>
                
            </div>
        </div>
    </div>

    @include('front.layout.footer')

<script>
        document.addEventListener('DOMContentLoaded', function () {
            const qtyInput = document.querySelector(`input.quantity-input[data-product-id='{{$product->id}}']`);
            const priceDisplay = document.getElementById(`totalPrice{{$product->id}}`);
            const hiddenPriceInput = document.getElementById(`productPrice{{$product->id}}`);
            const basePrice = parseFloat(hiddenPriceInput.value);

            qtyInput.value = 1;
            hiddenPriceInput.value = basePrice.toFixed(2);
            priceDisplay.textContent = `£${basePrice.toFixed(2)}`;

            qtyInput.addEventListener('input', function () {
                let quantity = parseInt(this.value);
                //console.log(quantity);
                    if (isNaN(quantity) || quantity < 1) {
                    this.value = 1;
                    quantity = 1;
                }

                const newTotal = basePrice * quantity;
                //console.log(newTotal);
                // Update visible total price
                priceDisplay.textContent = `£${newTotal.toFixed(2)}`;

                // Update hidden input price (optional, per quantity)
                //hiddenPriceInput.value = newTotal.toFixed(2);
            });
        });
</script>

<!-- JavaScript for star rating -->
<script>
    document.addEventListener("DOMContentLoaded", function () {
        const ratingLinks = document.querySelectorAll(".btn-rating");
        const ratingInput = document.getElementById("rating-value");

        ratingLinks.forEach(link => {
            link.addEventListener("click", function (e) {
                e.preventDefault();
                const rating = this.dataset.value;
                ratingInput.value = rating;

                // Reset all stars first
                ratingLinks.forEach(star => {
                    star.querySelector("i").classList.remove("fa-star");
                    star.querySelector("i").classList.add("fa-star-o");
                });

                // Highlight selected stars
                for (let i = 0; i < rating; i++) {
                    ratingLinks[i].querySelector("i").classList.remove("fa-star-o");
                    ratingLinks[i].querySelector("i").classList.add("fa-star");
                }
            });
        });
    });
</script>
<script>
    document.forms['frm-review'].addEventListener('submit', function (e) {
        const rating = document.getElementById('rating-value').value;
        if (!rating) {
            e.preventDefault();
            alert('Please select a star rating before submitting your review.');
        }
    });
</script>
