<!DOCTYPE html>
<html class="no-js" lang="en">

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <title>{{$general_setting->site_title}}</title>
    {!! SEOTools::generate() !!}
    @if (!empty($customHeadScript))
        {!! $customHeadScript !!}
    @endif

    <!-- for seo -->
    @php $site = \App\SiteSetting::first(); @endphp

    @if(!empty($site->google_search_console_meta))
        <meta name="google-site-verification" content="{{ $site->google_search_console_meta }}">
    @endif

    @if(!empty($site->bing_webmaster_meta))
        <meta name="msvalidate.01" content="{{ $site->bing_webmaster_meta }}">
    @endif

    @if(!empty($site->yandex_webmaster_meta))
        <meta name="yandex-verification" content="{{ $site->yandex_webmaster_meta }}">
    @endif

    @if(!empty($site->google_analytics_id))
        <!-- Global site tag (gtag.js) - Google Analytics -->
        <script async src="https://www.googletagmanager.com/gtag/js?id={{ $site->google_analytics_id }}"></script>
        <script>
            window.dataLayer = window.dataLayer || [];
            function gtag(){dataLayer.push(arguments);}
            gtag('js', new Date());
            gtag('config', '{{ $site->google_analytics_id }}');
        </script>
    @endif

    @if(!empty($site->google_tag_manager_id))
        <!-- Google Tag Manager -->
        <script>
            (function(w,d,s,l,i){w[l]=w[l]||[];w[l].push({'gtm.start':
            new Date().getTime(),event:'gtm.js'});var f=d.getElementsByTagName(s)[0],
            j=d.createElement(s),dl=l!='dataLayer'?'&l='+l:'';j.async=true;j.src=
            'https://www.googletagmanager.com/gtm.js?id='+i+dl;f.parentNode.insertBefore(j,f);
            })(window,document,'script','dataLayer','{{ $site->google_tag_manager_id }}');
        </script>
    @endif

    @if(!empty($site->facebook_pixel_id))
        <!-- Facebook Pixel Code -->
        <script>
            !function(f,b,e,v,n,t,s){if(f.fbq)return;n=f.fbq=function(){n.callMethod?
            n.callMethod.apply(n,arguments):n.queue.push(arguments)};if(!f._fbq)f._fbq=n;
            n.push=n;n.loaded=!0;n.version='2.0';n.queue=[];t=b.createElement(e);t.async=!0;
            t.src=v;s=b.getElementsByTagName(e)[0];s.parentNode.insertBefore(t,s)}
            (window, document,'script','https://connect.facebook.net/en_US/fbevents.js');
            fbq('init', '{{ $site->facebook_pixel_id }}');
            fbq('track', 'PageView');
        </script>
        <noscript>
            <img height="1" width="1" style="display:none"
                src="https://www.facebook.com/tr?id={{ $site->facebook_pixel_id }}&ev=PageView&noscript=1"/>
        </noscript>
    @endif

    @if(!empty($site->twitter_pixel_id))
        <!-- Twitter Pixel -->
        <script>
            !function(e,t,n,s,u,a){e.twq||(s=e.twq=function(){s.exe?s.exe.apply(s,arguments):s.queue.push(arguments);
            },s.version='1.1',s.queue=[],u=t.createElement(n),u.async=!0,u.src='//static.ads-twitter.com/uwt.js',
            a=t.getElementsByTagName(n)[0],a.parentNode.insertBefore(u,a))}(window,document,'script');
            twq('init','{{ $site->twitter_pixel_id }}');
            twq('track','PageView');
        </script>
    @endif

    @if(!empty($site->custom_head_scripts))
        {!! $site->custom_head_scripts !!}
    @endif

    <!-- seo ends -->
    <link href="https://fonts.googleapis.com/css?family=Cairo:400,600,700&amp;display=swap" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css?family=Poppins:600&amp;display=swap" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css?family=Playfair+Display:400i,700i" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css?family=Ubuntu&amp;display=swap" rel="stylesheet">
    <link rel="shortcut icon" type="image/x-icon" href="<?php echo asset('public/front/images/favicon.png') ?>"/>
    <link rel="stylesheet" href="<?php echo asset('public/front/css/font-awesome.min.css') ?>">

    <link rel="stylesheet" type="text/css" href="<?php echo asset('public/front/css/bootstrap.min.css') ?>">
    <link rel="stylesheet" type="text/css" href="<?php echo asset('public/front/css/animate.min.css') ?>">
    <link rel="stylesheet" type="text/css" href="<?php echo asset('public/front/css/font-awesome.min.css') ?>">
    <link rel="stylesheet" type="text/css" href="<?php echo asset('public/front/css/nice-select.css') ?>">
    <link rel="stylesheet" type="text/css" href="<?php echo asset('public/front/css/slick.min.css') ?>">
    <link rel="stylesheet" type="text/css" href="<?php echo asset('public/front/css/style.css') ?>">
    <link rel="stylesheet" type="text/css" href="<?php echo asset('public/front/css/main-color.css') ?>">

</head>
<body class="biolife-body">
    <!-- seo body script -->
    @if(!empty($site->google_tag_manager_id))
        <!-- Google Tag Manager (noscript) -->
        <noscript>
            <iframe src="https://www.googletagmanager.com/ns.html?id={{ $site->google_tag_manager_id }}"
                    height="0" width="0" style="display:none;visibility:hidden"></iframe>
        </noscript>
    @endif

    @if(!empty($site->custom_body_scripts))
        {!! $site->custom_body_scripts !!}
    @endif

    <!-- Preloader -->
    <div id="biof-loading">
        <div class="biof-loading-center">
            <div class="biof-loading-center-absolute">
                <div class="dot dot-one"></div>
                <div class="dot dot-two"></div>
                <div class="dot dot-three"></div>
            </div>
        </div>
    </div>

    <!-- HEADER -->
    <header id="header" class="header-area style-01 layout-03">
        <div class="header-top bg-main hidden-xs">
            <div class="container">
                <div class="top-bar left">
                    <ul class="horizontal-menu">
                        <li><a href="mailto:{{$info->mail}}"><i class="fa fa-envelope" aria-hidden="true"></i>{{$info->mail}}</a></li>
                        <li><a href="call:+447411039260">Order Now {{$info->phone}}</a></li>
                    </ul>
                </div>
                <div class="top-bar right">
                    <ul class="social-list">
                        <li><a href="{{$info->ss2}}" target="_blank"><i class="fa fa-youtube" aria-hidden="true"></i></a></li>
                        <li><a href="{{$info->facebook}}" target="_blank"><i class="fa fa-facebook" aria-hidden="true"></i></a></li>
                        <li><a href="{{$info->ss3}}" target="_blank"><i class="fa fa-instagram" aria-hidden="true"></i></a></li>
                    </ul>
                    <ul class="horizontal-menu">
                        @guest
                            <li><a href="{{ route('login') }}" class="login-link"><i class="biolife-icon icon-login"></i>Login</a></li>
                            <li><a href="{{ route('register') }}"><i class="biolife-icon icon-login"></i>Register</a></li>
                        @else
                    @if(Auth::user()->role_id == 5)
                        <li><a href="{{url('/customer_account')}}"><i class="biolife-icon icon-login"></i>User Profile</a></li>
                    @endif
                    @if(Auth::user()->role_id != 5)
                        <li><a href="{{url('/home')}}"><i class="biolife-icon icon-login"></i>Dashboard</a></li>
                    @endif
                        <li><a href="{{ route('logout') }}"
                                onclick="event.preventDefault();
                                document.getElementById('logout-form').submit();"><i class="biolife-icon icon-login"></i>
                                {{ __('Logout') }}</a>
                                <form id="logout-form" action="{{ route('logout') }}" method="POST" style="display: none;">
                                    @csrf
                                </form>
                        </li>
                    @endguest
                    </ul>
                </div>
            </div>
        </div>
        <div class="header-middle biolife-sticky-object ">
            <div class="container">
                <div class="row">
                    <div class="col-lg-3 col-md-2 col-md-6 col-xs-6">
                        <a href="{{url('/')}}" class="biolife-logo">
                            <img src="{{url('public/logo', $general_setting->site_logo)}}" alt="Alamminimarket" width="135" height="34">
                            </a>
                    </div>
                    <div class="col-lg-6 col-md-7 hidden-sm hidden-xs">
                        <div class="primary-menu">
                        <ul class="menu biolife-menu clone-main-menu clone-primary-menu" id="primary-menu" data-menuname="main menu">
                            <li class="menu-item"><a style="{{ Request::is('/') ? 'color:#e73917;' : '' }}" href="{{url('/')}}">Home</a></li>
                            <?php 
                            $about = App\Page::orderBy('created_at', 'asc')->first();?>
                                        
                            <li>
                                <a href="{{ url('pages/' . $about->id) }}" style="{{ Request::is('pages/' . $about->id) ? 'color:#e73917;' : '' }}">
                                    About Us
                                </a>
                            </li>


                            <li class="menu-item">
                                <a href="{{url('/shop')}}" style="{{ Request::is('shop') ? 'color:#e73917;' : '' }}" class="menu-name" data-title="Products">Shop</a>
                                
                            </li>
                            <li>
                                <a style="{{ Request::is('deals') ? 'color:#e73917;' : '' }}" href="{{url('/deals')}}">Hot Deals</a>
                            </li>

                            <li class="menu-item"> <a style="{{ Request::is('contact')?'color:#e73917;' : '' }}" href="{{url('/contact')}}">Contact</a></li>
                        </ul>
                    </div>
                    </div>
                    <div class="col-lg-3 col-md-3 col-md-6 col-xs-6">
                        <div class="biolife-cart-info">
                            <div class="mobile-search">
                                <a href="javascript:void(0)" class="open-searchbox"><i class="biolife-icon icon-search"></i></a>
                                <div class="mobile-search-content">
                                    <form action="{{route('product_search')}}" class="form-search" name="mobile-seacrh" method="get">
                                        @csrf
                                        <a href="#" class="btn-close"><span class="biolife-icon icon-close-menu"></span></a>
                                        <input type="text" name="search" class="input-text" value="" placeholder="Search here...">
                                        <button type="submit" class="btn-submit">go</button>
                                    </form>
                                </div>
                            </div>
                            
                            <div class="minicart-block">
                                <div class="minicart-contain">
                                    <a href="javascript:void(0)" class="link-to">
                                            <span class="icon-qty-combine">
                                                <i class="icon-cart-mini biolife-icon"></i>
                                                <span class="qty">{{ Cart::count() }}</span>
                                            </span>
                                        <span class="title">My Cart -</span>
                                        <span class="sub-total">£{{Cart::subtotal()}}</span>
                                    </a>
                                    <div class="cart-content">
                                        <div class="cart-inner">
                                            <ul class="products">

                                                @foreach($cart_items as $item)
                                                    <?php $product = App\Product::find($item->id);$images = explode(",", $product->image)?>
                                                <li>
                                                    <div class="minicart-item">
                                                        <div class="thumb">
                                                            <a href="{{url('/single-product')}}/{{$product->id}}">@foreach($images as $key => $image)<img src="{{url('public/images/product', $image)}}" width="90" height="90" alt="{{$item->name}}">
                                                            @break
                                                            @endforeach
                                                            </a>
                                                        </div>
                                                        <div class="left-info">
                                                            <div class="product-title"><a href="{{url('/single-product')}}/{{$product->id}}" class="product-name">{{$item->name}}</a></div>
                                                            <div class="price">
                                                                <ins><span class="price-amount"><span class="currencySymbol">£</span>{{$item->price}}</span></ins>
                                                                <!-- <del><span class="price-amount"><span class="currencySymbol">£</span>95.00</span></del> -->
                                                            </div>
                                                            <div class="qty">
                                                                <label for="cart[id123][qty]">Qty: {{$item->qty}}</label>
                                                                <!-- <input type="number" class="input-qty" name="cart[id123][qty]" id="cart[id123][qty]" value="1" disabled> -->
                                                            </div>
                                                        </div>
                                                        <div class="action">
                                                            <a href="{{url('shopping-cart')}}"><i class="fa fa-pencil" aria-hidden="true"></i></a>
                                                            <a href="{{url('cart/remove_item')}}/{{$item->rowId}}"><i class="fa fa-trash-o" aria-hidden="true"></i></a>
                                                        </div>
                                                    </div>
                                                </li>
                                                @endforeach
                                                
                                            </ul>
                                            <p class="btn-control">
                                                <a href="{{url('shopping-cart')}}" class="btn view-cart">view cart</a>
                                                <a href="{{url('/check_out')}}" class="btn">checkout</a>
                                            </p>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="mobile-menu-toggle">
                                <a class="btn-toggle" data-object="open-mobile-menu" href="javascript:void(0)">
                                    <span></span>
                                    <span></span>
                                    <span></span>
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="header-bottom hidden-sm hidden-xs">
            <div class="container">
                <div class="row">
                    <div class="col-lg-3 col-md-4">
                        <div class="vertical-menu vertical-category-block">
                            <div class="block-title">
                                <span class="menu-icon">
                                    <span class="line-1"></span>
                                    <span class="line-2"></span>
                                    <span class="line-3"></span>
                                </span>
                                <span class="menu-title">All departments</span>
                                <span class="angle" data-tgleclass="fa fa-caret-down"><i class="fa fa-caret-up" aria-hidden="true"></i></span>
                            </div>
                            <div class="wrap-menu">
                                <ul class="menu clone-main-menu">
                                    <?php $categories = App\Category::where('is_active', true)->orderBy('id', 'desc')->where('parent_id', null)->get(); ?>
                                    @foreach($categories as $category)
                                        <?php $sub_cat_count = App\Category::where('parent_id', $category->id)->where('is_active', true)->count(); ?>
                                    
                                        <li class="menu-item <?php  if($sub_cat_count > 0){ ?> menu-item-has-children has-child<?php } ?>">
                                        <a href="{{ url('/shop_by_id/' . $category->id) }}" class="menu-name" data-title="Butter & Eggs"><i class="biolife-icon icon-honey"></i>{{ $category->name }}</a>

                                        <ul class="sub-menu">
                                            @if($sub_cat_count > 0)
                <?php $sub_cats = App\Category::where('parent_id', $category->id)->where('is_active', true)->get(); ?>
                                             @foreach($sub_cats as $sub_cat)

                                             <?php $sub_sub_cat_count = App\Category::where('parent_id', $sub_cat->id)->where('is_active', true)->count(); ?>
                                            <li class="menu-item <?php  if($sub_sub_cat_count > 0){ ?> menu-item-has-children has-child<?php } ?>">
                                                <a href="{{ url('/shop_by_id/' . $sub_cat->id) }}" class="menu-name" data-title="Eggs & other considerations">{{ $sub_cat->name }} </a>

                                                <ul class="sub-menu">
                                                     @if($sub_sub_cat_count > 0)
                                <?php $sub_sub_cats = App\Category::where('parent_id', $sub_cat->id)->where('is_active', true)->get(); ?>
                                                    @foreach($sub_sub_cats as $sub_sub_cat)
                                                    <li class="menu-item"><a href="{{ url('/shop_by_id/' . $sub_sub_cat->id) }}">{{ $sub_sub_cat->name }}</a></li>
                                                    @endforeach
                                                    @endif
                                                </ul>
                                            </li>
                                            @endforeach
                                            @endif
                                                                                         
                                        </ul>
                                    </li>

                                    @endforeach   
                                </ul>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-9 col-md-8 padding-top-2px">
                        <div class="header-search-bar layout-01">
                            <form action="{{route('product_search')}}" class="form-search" name="desktop-seacrh" method="get">
                                @csrf
                                <input type="text" name="search" class="input-text" value="" placeholder="Search here...">
                                
                                <button type="submit" class="btn-submit"><i class="biolife-icon icon-search"></i></button>
                            </form>
                        </div>
                        <div class="live-info">
                            <p class="telephone"><i class="fa fa-phone" aria-hidden="true"></i><b class="phone-number">{{$info->phone}}</b></p>
                            <p class="working-time">Mon-Fri: 8:30am-7:30pm;</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </header>