@include('front.layout.header')

<div class="breadcrumb-area">
    <div class="container">
        <ol class="breadcrumb breadcrumb-list">
            <li class="breadcrumb-item"><a href="{{ url('/') }}">Home</a></li>
            <li class="breadcrumb-item active">My Account</li>
        </ol>
    </div>
</div>

@if(session()->has('success'))
    <div class="alert alert-success alert-dismissible text-center">
        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
            <span aria-hidden="true">&times;</span>
        </button>
        {{ session()->get('success') }}
    </div>
@endif

<div class="container" style="padding: 20px; font-family: Arial, sans-serif;">
    <h3>Orders</h3>
    <div style="overflow-x: auto;">
        <table style="width: 100%; border-collapse: collapse; margin-top: 20px;">
            <thead>
                <tr>
                    <th style="border: 1px solid #ddd; padding: 8px; background-color: #f2f2f2;">Reference No.</th>
                    <th style="border: 1px solid #ddd; padding: 8px; background-color: #f2f2f2;">Order Date</th>
                    <th style="border: 1px solid #ddd; padding: 8px; background-color: #f2f2f2;">Items</th>
                    <th style="border: 1px solid #ddd; padding: 8px; background-color: #f2f2f2;">Total</th>
                    <th style="border: 1px solid #ddd; padding: 8px; background-color: #f2f2f2;">Status</th>
                </tr>
            </thead>
            <tbody>
                @foreach($orders as $order)
                    <?php $sale_details = App\Product_Sale::where('sale_id', $order->id)->get(); ?>
                    <tr>
                        <td style="border: 1px solid #ddd; padding: 8px;">{{ $order->reference_no }}</td>
                        <td style="border: 1px solid #ddd; padding: 8px;">
                            {{ date($general_setting->date_format, strtotime($order->created_at->toDateString())) . ' ' . $order->created_at->toTimeString() }}
                        </td>
                        <td style="border: 1px solid #ddd; padding: 8px;">
                            @foreach($sale_details as $row)
                                <?php $product = App\Product::find($row->product_id); ?>
                                {{ $product->name }} x {{ $row->qty }}<br>
                            @endforeach
                        </td>
                        <td style="border: 1px solid #ddd; padding: 8px;">{{ $order->grand_total }}</td>
                        <td style="border: 1px solid #ddd; padding: 8px;">
                            @if($order->sale_status == 1)
                                <span style="color: green;">Completed</span>
                            @elseif($order->sale_status == 2)
                                <span style="color: orange;">Pending</span>
                            @elseif($order->sale_status == 3)
                                <span style="color: blue;">Processing</span>
                            @else
                                <span style="color: grey;">Draft</span>
                            @endif
                        </td>
                    </tr>
                @endforeach
            </tbody>
        </table>
    </div>
</div>

@include('front.layout.footer')

