<div class="single-makal-product">
    <div class="pro-img">
        <a href="{{url('/single-product')}}/{{$product->id}}">
        <?php $images = explode(",", $product->image);
            $primaryImage = isset($images[0]) ? $images[0] : '';
            $hoverImage = isset($images[1]) ? $images[1] : $primaryImage;?>
            <img src="{{ url('public/images/product', $primaryImage) }}" alt="product-img" style="width: 350px; height: 424px;">
        </a>
        <span class="sticker-new">new</span>
        <!-- <div class="quick-view-pro">
            <a data-bs-toggle="modal" data-bs-target="#product-window" class="quick-view" href="#"></a> -->
        </div>
    </div>
    <div class="pro-content">
        <h4 class="pro-title">
            <a href="{{url('/single-product')}}/{{$product->id}}">{{$product->name}}</a>
        </h4>
        <p>
            @if($product->promotion_price != null)
                <span class="price">BDT {{$product->promotion_price}}</span>
            @else
                <span class="price">BDT {{$product->price}}</span>
            @endif
        </p>
        <div class="pro-actions">
            <div class="actions-primary">
                @if($product->is_variant == null)
                    @if($product->qty > 0)
                        <form id="addItem{{$product->id}}" action="{{url('cart/addItem')}}" method="POST" class="variants add">
                            @csrf
                            <input type="hidden" name="quantity" value="1">
                            <input type="hidden" name="product_id" value="{{$product->id}}">
                            <input type="hidden" name="name" value="{{$product->name}}">
                            @if($product->promotion_price != null)
                            <input type="hidden" name="price" value="{{$product->promotion_price}}">
                            @else
                            <input type="hidden" name="price" value="{{$product->price}}">
                            @endif
                            <a href="addItem{{$product->id}}" class="add-to-cart" data-toggle="tooltip" data-original-title="Add to Cart">Add To Cart</a>
                        </form>
                    @else
                        <form class="variants add" action="#" onclick="window.location.href='{{url('/single-product')}}/{{$product->id}}'"method="post">
                            <a href="#" class="add-to-cart" data-toggle="tooltip" data-original-title="Add to Cart">Out Of Stock</a>
                        </form>
                        @endif
                    @else
                    <form class="variants add" action="#" onclick="window.location.href='{{url('/single-product')}}/{{$product->id}}'"method="post">
                        <a href="addItem{{$product->id}}" class="add-to-cart" data-toggle="tooltip" data-original-title="Add to Cart">Add To Cart</a>
                    </form>
                @endif
            </div>
            
            <div class="actions-secondary">
                <?php 
                    $reviews = App\Review::where('product_id', $product->id)->get();
                    if ($reviews) {
                        $number = $reviews->count();
                        $totalStars = $reviews->sum('stars');
                        $averageRating = $number > 0 ? $totalStars / $number : 0;
                    } else {
                        // Handle the case where the product is not found
                        $reviews = collect();
                        $number = 0;
                        $totalStars = 0;
                        $averageRating = 0;
                    }?>
                <div class="rating">
                    @for ($i = 1; $i <= 5; $i++)
                        <i class="font-13 fa fa-{{ $i <= round($averageRating) ? 'star' : 'star-o' }}"></i>
                    @endfor
                    
                </div>
            </div>
        </div>
    </div>
</div>