@include('front.layout.header')
<!--Hero Section-->
    <div class="hero-section hero-background style-02">
        <h1 class="page-title">Our Blog</h1>
        <nav class="biolife-nav">
            <ul>
                <li class="nav-item"><a href="{{ url('/') }}" class="permal-link">Home</a></li>
                <li class="nav-item"><span class="current-page">Our Blog</span></li>
            </ul>
        </nav>
    </div>

    <!-- Page Contain -->
    <div class="page-contain blog-page">
        <div class="container">
            <!-- Main content -->
            <div id="main-content" class="main-content">

                <div class="row">

                    <!--articles block-->
                    <ul class="posts-list main-post-list">
                        @foreach($blogs as $blog)
                        <li class="post-elem col-lg-4 col-md-4 col-sm-6 col-xs-12">
                            <div class="post-item effect-04 style-bottom-info">
                                <div class="thumbnail">
                                    <a href="#" class="link-to-post"><img src="{{ asset('storage/app/' . $blog->image) }}" width="370" height="270" alt=""></a>
                                </div>
                                <div class="post-content">
                                    <h4 class="post-name"><a href="{{url('blog-item')}}/{{$blog->id}}" class="linktopost">{{ Str::limit($blog->title, 20) }}</a></h4>
                                    <p class="post-archive"><b class="post-cat"></b><span class="post-date">{{ $blog->created_at->format('F j, Y') }}</span><span class="author">Posted By {{$blog->author}}</span></p>
                                    <p class="excerpt">{{ Str::limit($blog->title, 100) }}...</p>
                                    <div class="group-buttons">
                                        <a href="{{url('blog-item')}}/{{$blog->id}}" class="btn readmore">read more</a>
                                        <!-- <a href="#" class="btn count-number liked"><i class="biolife-icon icon-heart-1"></i><span class="number">20</span></a>
                                        <a href="#" class="btn count-number commented"><i class="biolife-icon icon-conversation"></i><span class="number">06</span></a> -->
                                    </div>
                                </div>
                            </div>
                        </li>
                        @endforeach
                    </ul>

                </div>
        </div>
    </div>
@include('front.layout.footer')