@extends('layout.main')

@section('content')
<section>
    <div class="container-fluid">
        <!-- Trigger the modal with a button -->
        <a href="{{route('dcs.create')}}" class="btn btn-info"><i class="dripicons-plus"></i> Add Delivery Charge</a>
    </div>
    <div class="table-responsive">
        <table id="delivery-table" class="table" style="width: 100%">
            <thead>
                <tr>
                    <th class="not-exported"></th>
                    <th>Location</th>
                    <th>Delivery Charge</th>
                    <th class="not-exported">{{trans('file.action')}}</th>
                </tr>
            </thead>
            <tbody>
                @php $serialNumber = 1; @endphp <!-- Initialize serial number -->
                @foreach($deliveryCharges ?? [] as $deliveryCharge)
                <tr>
                    <td>{{ $serialNumber }}</td>
                    <td>{{ $deliveryCharge->location }}</td>
                    <td>{{ $deliveryCharge->charge }}</td>
                    <td>
                        <div class="btn-group">
                            <button type="button" class="btn btn-default btn-sm dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                {{trans('file.action')}}
                                <span class="caret"></span>
                                <span class="sr-only">Toggle Dropdown</span>
                            </button>
                            <ul class="dropdown-menu edit-options dropdown-menu-right dropdown-default" user="menu">
                                <li>
                                    <a href="{{ route('dcs.edit', $deliveryCharge->id) }}" class="btn btn-link">
                                        <i class="dripicons-document-edit"></i> {{trans('file.edit')}}
                                    </a>
                                </li>
                                <li class="divider"></li>
                                {{ Form::open(['route' => ['dcs.destroy', $deliveryCharge->id], 'method' => 'DELETE'] ) }}
                                <li>
                                    <button type="submit" class="btn btn-link" onclick="return confirmDelete()">
                                        <i class="dripicons-trash"></i> {{trans('file.delete')}}
                                    </button>
                                </li>
                                {{ Form::close() }}
                            </ul>
                        </div>
                    </td>
                </tr>
                @php $serialNumber++; @endphp <!-- Increment serial number -->
                @endforeach
            </tbody>
        </table>
    </div>
</section>

<script type="text/javascript">
    $("ul#cms").siblings('a').attr('aria-expanded','true');
    $("ul#cms").addClass("show");
    $("ul#cms #faq-menu").addClass("active");

    function confirmDelete() {
        return confirm("Are you sure you want to delete this delivery charge?");
    }

    $(document).ready(function() {
        $('#delivery-table').DataTable({
            "order": [],
            'language': {
                'lengthMenu': '_MENU_ {{trans("file.records per page")}}',
                "info": '<small>{{trans("file.Showing")}} _START_ - _END_ (_TOTAL_)</small>',
                "search": '{{trans("file.Search")}}',
                'paginate': {
                    'previous': '<i class="dripicons-chevron-left"></i>',
                    'next': '<i class="dripicons-chevron-right"></i>'
                }
            },
            'columnDefs': [
                {
                    "orderable": false,
                    'targets': [0, 3]
                },
                {
                    'render': function(data, type, row, meta) {
                        if (type === 'display') {
                            data = '<div class="checkbox"><input type="checkbox" class="dt-checkboxes"><label></label></div>';
                        }
                        return data;
                    },
                    'checkboxes': {
                        'selectRow': true,
                        'selectAllRender': '<div class="checkbox"><input type="checkbox" class="dt-checkboxes"><label></label></div>'
                    },
                    'targets': [0]
                }
            ],
            'select': { style: 'multi', selector: 'td:first-child' },
            'lengthMenu': [[10, 25, 50, -1], [10, 25, 50, "All"]],
            dom: '<"row"lfB>rtip',
            buttons: [
                {
                    extend: 'pdf',
                    text: '{{trans("file.PDF")}}',
                    exportOptions: {
                        columns: ':visible:Not(.not-exported)',
                        rows: ':visible'
                    },
                },
                {
                    extend: 'csv',
                    text: '{{trans("file.CSV")}}',
                    exportOptions: {
                        columns: ':visible:Not(.not-exported)',
                        rows: ':visible'
                    },
                },
                {
                    extend: 'print',
                    text: '{{trans("file.Print")}}',
                    exportOptions: {
                        columns: ':visible:Not(.not-exported)',
                        rows: ':visible'
                    },
                },
                {
                    text: '{{trans("file.delete")}}',
                    className: 'buttons-delete',
                    action: function(e, dt, node, config) {
                        var user_verified = <?php echo json_encode(env('USER_VERIFIED')) ?>;
                        if (user_verified == '1') {
                            var ids = [];
                            $(':checkbox:checked').each(function(i) {
                                if (i) {
                                    ids[i-1] = $(this).closest('tr').data('id');
                                }
                            });
                            if (ids.length && confirm("Are you sure you want to delete?")) {
                                $.ajax({
                                    type: 'POST',
                                    url: 'dcs/deletebyselection',
                                    data: {
                                        idArray: ids
                                    },
                                    success: function(data) {
                                        alert(data);
                                    }
                                });
                                dt.rows({ page: 'current', selected: true }).remove().draw(false);
                            } else if (!ids.length)
                                alert('No delivery charge is selected!');
                        } else
                            alert('This feature is disabled for demo!');
                    }
                },
                {
                    extend: 'colvis',
                    text: '{{trans("file.Column visibility")}}',
                    columns: ':gt(0)'
                },
            ],
        });
    });

    if(all_permission.indexOf("users-delete") == -1)
        $('.buttons-delete').addClass('d-none');
</script>
@endsection
