@extends('layout.main')
@section('content')

<section>
    <div class="container-fluid">
        <a href="{{route('blogs.create')}}" class="btn btn-info"><i class="dripicons-plus"></i> Add Blogs</a>
    </div>
    <div class="table-responsive">
        <table id="blogs-table" class="table" style="width: 100%">
            <thead>
                <tr>
                    <th>Title</th>
                    <th>Description</th>
                    <th>Image</th>
                    <th>{{trans('file.action')}}</th>
                </tr>
            </thead>
            <tbody>
                @foreach($blogs_all ?? [] as $blog)
                <tr data-id="{{ $blog->id }}">
                    <td>{{ $blog->title }}</td>
                    <td>{{ substr($blog->description, 0, 30) }}</td>
                    <td><img src="{{ asset('storage/app/' . $blog->image) }}" alt="Blog Image" height="50px" width="100px"></td>
                    <td>
                        <div class="btn-group">
                            <button type="button" class="btn btn-default btn-sm dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">{{trans('file.action')}}
                                <span class="caret"></span>
                                <span class="sr-only">Toggle Dropdown</span>
                            </button>
                            <ul class="dropdown-menu edit-options dropdown-menu-right dropdown-default" user="menu">
                                <li>
                                    <a href="{{ route('blogs.edit', $blog->id) }}" class="btn btn-link"><i class="dripicons-document-edit"></i> {{trans('file.edit')}}</a>
                                </li>
                                <li class="divider"></li>
                                <?php
                                    $role = DB::table('roles')->find(Auth::user()->role_id);
                                    $seo = DB::table('permissions')->where('name', 'seo')->first();
                                    $seo_active = null;
                                    if ($seo) {
                                        $seo_active = DB::table('role_has_permissions')->where([
                                            ['permission_id', $seo->id],
                                            ['role_id', $role->id]
                                        ])->first();
                                    }
                                ?>
                                @if(!empty($seo_active))
                                <li>
                                    <a href="{{ route('blog.seo_meta', $blog->id) }}" class="btn btn-link"><i class="dripicons-document-edit"></i> SEO</a>
                                </li>
                                @endif
                                {{ Form::open(['route' => ['blogs.destroy', $blog->id], 'method' => 'DELETE'] ) }}
                                <li>
                                    <button type="submit" class="btn btn-link" onclick="return confirmDelete()"><i class="dripicons-trash"></i> {{trans('file.delete')}}</button>
                                </li>
                                {{ Form::close() }}
                            </ul>
                        </div>
                    </td>
                </tr>
                @endforeach
            </tbody>
        </table>
    </div>
</section>

<script type="text/javascript">
    $(document).ready(function() {
        $("ul#cms").siblings('a').attr('aria-expanded','true');
        $("ul#cms").addClass("show");
        $("ul#cms #blogs-menu").addClass("active");

        $('#blogs-table').DataTable({
            responsive: true,
            fixedHeader: {
                header: true,
                footer: true
            },
            "order": [],
            'language': {
                'lengthMenu': '_MENU_ {{trans("file.records per page")}}',
                "info":      '<small>{{trans("file.Showing")}} _START_ - _END_ (_TOTAL_)</small>',
                "search":  '{{trans("file.Search")}}',
                'paginate': {
                    'previous': '<i class="dripicons-chevron-left"></i>',
                    'next': '<i class="dripicons-chevron-right"></i>'
                }
            },
            'columnDefs': [
                {
                    "orderable": false,
                    'targets': [2, 3]
                },
            ],
            'select': { style: 'multi',  selector: 'td:first-child'},
            'lengthMenu': [[10, 25, 50, -1], [10, 25, 50, "All"]],
            dom: '<"row"lfB>rtip',
            buttons: [
                {
                    extend: 'pdf',
                    text: '{{trans("file.PDF")}}',
                    exportOptions: {
                        columns: ':visible:Not(.not-exported)',
                        rows: ':visible'
                    },
                },
                {
                    extend: 'csv',
                    text: '{{trans("file.CSV")}}',
                    exportOptions: {
                        columns: ':visible:Not(.not-exported)',
                        rows: ':visible'
                    },
                },
                {
                    extend: 'print',
                    text: '{{trans("file.Print")}}',
                    exportOptions: {
                        columns: ':visible:Not(.not-exported)',
                        rows: ':visible'
                    },
                },
                {
                    extend: 'colvis',
                    text: '{{trans("file.Column visibility")}}',
                    columns: ':gt(0)'
                },
            ],
        });
    });

    function confirmDelete() {
        if (confirm("Are you sure you want to delete this blog?")) {
            return true;
        }
        return false;
    }
</script>

@endsection