@extends('layout.main') @section('content')
@if(session()->has('not_permitted'))
  <div class="alert alert-danger alert-dismissible text-center"><button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>{{ session()->get('not_permitted') }}</div> 
@endif
<section class="forms">
    <div class="container-fluid">
        <div class="row">
            <div class="col-md-12">
                <div class="card">
                    <div class="card-header d-flex align-items-center">
                        <h4>Update Bank Deposit</h4>
                    </div>
                    <div class="card-body">
                        <p class="italic"><small>{{trans('file.The field labels marked with * are required input fields')}}.</small></p>
                        {!! Form::open(['route' => ['bankdeposit.update', $lims_bankdeposit_data->id], 'method' => 'put', 'files' => true]) !!}
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Check No *</strong> </label>
                                    <input type="text" name="check_no" value="{{$lims_bankdeposit_data->check_no}}" required class="form-control">
                                </div>
                            </div>
                           
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Amount *</label>
                                    <input type="text" name="amount" value="{{$lims_bankdeposit_data->amount}}" required class="form-control">
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Date *</label>
                                    <input type="date" name="date" value="{{$lims_bankdeposit_data->date}}" required class="form-control">
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Account ID *</label>
                                    <input type="hidden" name="account_id_hidden" value="{{$lims_bankdeposit_data->account_id}}" />
                                    <div class="input-group">
                                          <select name="account_id" class="selectpicker form-control" data-live-search="true" data-live-search-style="begins" title="Select Account...">
                                            @foreach($account as $acc)
                                                <option value="{{$acc->id}}">{{$acc->name}} ({{ $acc->account_no}})</option>
                                            @endforeach    
                                          </select>
                                        </div>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Option *</label>
                                    <input type="hidden" name="mathod_option_hidden" value="{{$lims_bankdeposit_data->option}}" />
                                        <div class="input-group">
                                          <select name="option" class="selectpicker form-control" data-live-search="true" data-live-search-style="begins" title="Select Option...">
                                                <option value="Withdraw">Withdraw</option>
                                                <option value="Deposit">Deposit</option>
                                          </select>
                                      </div>  
                                </div>
                            </div>
                            
                            <div class="col-md-12">
                                <div class="form-group mt-3">
                                    <input type="submit" value="{{trans('file.submit')}}" class="btn btn-primary">
                                </div>
                            </div>
                        </div>
                        {!! Form::close() !!}
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<script type="text/javascript">
    $("ul#account").siblings('a').attr('aria-expanded','true');
    $("ul#account").addClass("show");
    $("ul#account #bankdeposit-list-menu").addClass("active");
    $('select[name="account_id"]').val($('input[name="account_id_hidden"]').val());
    $('select[name="option"]').val($('input[name="mathod_option_hidden"]').val());
</script>
@endsection
