@extends('layout.main') @section('content')
@if(session()->has('message'))
  <div class="alert alert-success alert-dismissible text-center"><button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>{!! session()->get('message') !!}</div> 
@endif
<section class="forms">
    <div class="container-fluid">
        <h3>{{trans('file.Account Statement')}}</h3>
        <strong>{{trans('file.Account')}}:</strong> {{$lims_account_data->name}} [{{$lims_account_data->account_no}}]
    </div>
    <div class="table-responsive mb-4">
        <table id="account-table" class="table table-hover">
            <thead>
                <tr>
                    <th class="not-exported"></th>
                    <th>{{trans('file.date')}}</th>
                    <th>Detail</th>
                    <th>{{trans('file.Payment Reference')}}</th>
                    <th>{{trans('file.Transaction Reference')}}</th>
                    <th>{{trans('file.Credit')}}</th>
                    <th>{{trans('file.Debit')}}</th>
                    <th>{{trans('file.Balance')}}</th>
                </tr>
            </thead>
            <tbody>
                <tr>
                    <?php
                        $opening_balance = $initial_balance + $total_credit_opening - $total_debit_opening;
                        $balance = $opening_balance;
                    ?>
                    <td>0</td>
                    <td>{{$end_date}}</td>
                    <td>Opening Balance</td>
                    <td></td>
                    <td></td>
                    <td></td>
                    <td></td>
                    <td>{{$opening_balance}}</td>

                </tr>
                @foreach($credit_list as $key=>$credit)
                <?php
                    $transaction = App\Sale::select('reference_no')->find($credit->sale_id);
                    $balance = $balance + $credit->amount; 
                ?>
                <tr>
                    <td>{{$key}}</td>
                    <td>{{date($general_setting->date_format, strtotime($credit->created_at->toDateString()))}}</td>
                    <td>Sale</td>
                    <td>{{$credit->payment_reference}}</td>
                    @if($transaction)
                        <td>{{$transaction->reference_no}}</td>
                    @else
                        <td></td>
                    @endif
                    <td>{{number_format((float)$credit->amount, 2, '.', '')}}</td>
                    <td>0.00</td>
                    <td>{{number_format((float)$balance, 2, '.', '')}}</td>
                </tr>
                @endforeach

                @foreach($recieved_money_transfer_list as $key=>$recieved_money)
                <?php 
                    $balance = $balance + $recieved_money->amount; 
                ?>
                <tr>
                    <td>{{$key}}</td>
                    <td>{{date($general_setting->date_format, strtotime($recieved_money->created_at->toDateString()))}}</td>
                    <td>Money Transfer (received)</td>
                    <td>{{$recieved_money->reference_no}}</td>
                    <td></td>
                    <td>{{number_format((float)$recieved_money->amount, 2, '.', '')}}</td>
                    <td>0.00</td>
                    <td>{{number_format((float)$balance, 2, '.', '')}}</td>
                </tr>
                @endforeach

                @foreach($bank_deposits as $key=>$deposit_money)
                <?php 
                    $balance = $balance + $deposit_money->amount; 
                ?>
                <tr>
                    <td>{{$key}}</td>
                    <td>{{date($general_setting->date_format, strtotime($deposit_money->created_at->toDateString()))}}</td>
                    <td>Bank Deposit</td>
                    <td>{{$deposit_money->check_no}}</td>
                    <td></td>
                    <td>{{number_format((float)$deposit_money->amount, 2, '.', '')}}</td>
                    <td>0.00</td>
                    <td>{{number_format((float)$balance, 2, '.', '')}}</td>
                </tr>
                @endforeach

                
                @foreach($investment_deposit as $key=>$investment_money)
                <?php 
                    $balance = $balance + $investment_money->amount; 
                ?>
                <tr>
                    <td>{{$key}}</td>
                    <td>{{date($general_setting->date_format, strtotime($investment_money->created_at->toDateString()))}}</td>
                    <td>Investment (Deposit)</td>
                    <td>{{$investment_money->investment_id}}</td>
                    <td></td>
                    <td>{{number_format((float)$investment_money->amount, 2, '.', '')}}</td>
                    <td>0.00</td>
                    <td>{{number_format((float)$balance, 2, '.', '')}}</td>
                </tr>
                @endforeach


                @foreach($debit_list as $key=>$debit)
                <?php
                    $transaction = App\Purchase::select('reference_no')->find($debit->purchase_id);
                    $balance = $balance - $debit->amount; 
                ?>
                <tr>
                    <td>{{$key}}</td>
                    <td>{{date($general_setting->date_format, strtotime($debit->created_at->toDateString()))}}</td>
                    <td>Purchase</td>
                    <td>{{$debit->payment_reference}}</td>
                    @if($transaction)
                        <td>{{$transaction->reference_no}}</td>
                    @else
                        <td></td>
                    @endif
                    <td>0.00</td>
                    <td>{{number_format((float)$debit->amount, 2, '.', '')}}</td>
                    <td>{{number_format((float)$balance, 2, '.', '')}}</td>
                </tr>
                @endforeach

                @foreach($return_list as $key=>$return)
                <?php 
                    $transaction = App\Returns::select('reference_no')->find($credit->return_id);
                    $balance = $balance - $return->grand_total; 
                ?>
                <tr>
                    <td>{{$key}}</td>
                    <td>{{date($general_setting->date_format, strtotime($return->created_at->toDateString()))}}</td>
                    <td>Sales Return</td>
                    <td>{{$return->reference_no}}</td>
                    @if($transaction)
                        <td>{{$transaction->reference_no}}</td>
                    @else
                        <td></td>
                    @endif
                    <td>0.00</td>
                    <td>{{number_format((float)$return->grand_total, 2, '.', '')}}</td>
                    <td>{{number_format((float)$balance, 2, '.', '')}}</td>
                </tr>
                @endforeach

                @foreach($purchase_return_list as $key=>$return)
                <?php
                    $transaction = App\ReturnPurchase::select('reference_no')->find($credit->return_id);
                    $balance = $balance + $return->grand_total;
                ?>
                <tr>
                    <td>{{$key}}</td>
                    <td>{{date($general_setting->date_format, strtotime($return->created_at->toDateString()))}}</td>
                    <td>Purchase Return</td>
                    <td>{{$return->reference_no}}</td>
                    @if($transaction)
                        <td>{{$transaction->reference_no}}</td>
                    @else
                        <td></td>
                    @endif
                    <td>{{number_format((float)$return->grand_total, 2, '.', '')}}</td>
                    <td>0.00</td>
                    <td>{{number_format((float)$balance, 2, '.', '')}}</td>
                </tr>
                @endforeach

                @foreach($bank_withdraws as $key=>$withdraw_money)
                <?php 
                    $balance = $balance - $withdraw_money->amount; 
                ?>
                <tr>
                    <td>{{$key}}</td>
                    <td>{{$withdraw_money->date}}</td>
                    <td>Bank Withdrawal</td>
                    <td>{{$withdraw_money->check_no}}</td>
                    <td></td>
                    <td>0.00</td>
                    <td>{{number_format((float)$withdraw_money->amount, 2, '.', '')}}</td>
                    <td>{{number_format((float)$balance, 2, '.', '')}}</td>
                </tr>
                @endforeach

                @foreach($investment_withdraw as $key=>$withdraw_money)
                <?php 
                    $balance = $balance - $withdraw_money->amount; 
                ?>
                <tr>
                    <td>{{$key}}</td>
                    <td>{{$withdraw_money->date}}</td>
                    <td>Investment (Withdrawal)</td>
                    <td>{{$withdraw_money->investment_id}}</td>
                    <td></td>
                    <td>0.00</td>
                    <td>{{number_format((float)$withdraw_money->amount, 2, '.', '')}}</td>
                    <td>{{number_format((float)$balance, 2, '.', '')}}</td>
                </tr>
                @endforeach

                @foreach($expense_list as $key=>$expense)
                @php $balance = $balance - $expense->amount; @endphp
                <tr>
                    <td>{{$key}}</td>
                    <td>{{date($general_setting->date_format, strtotime($expense->created_at->toDateString()))}}</td>
                    <td>Expenses</td>
                    <td>{{$expense->reference_no}}</td>
                    <td></td>
                    <td>0.00</td>
                    <td>{{number_format((float)$expense->amount, 2, '.', '')}}</td>
                    <td>{{number_format((float)$balance, 2, '.', '')}}</td>
                </tr>
                @endforeach

                @foreach($payroll_list as $key=>$payroll)
                @php $balance = $balance - $payroll->amount; @endphp
                <tr>
                    <td>{{$key}}</td>
                    <td>{{date($general_setting->date_format, strtotime($payroll->created_at->toDateString()))}}</td>
                    <td>Payroll</td>
                    <td>{{$payroll->reference_no}}</td>
                    <td></td>
                    <td>0.00</td>
                    <td>{{number_format((float)$payroll->amount, 2, '.', '')}}</td>
                    <td>{{number_format((float)$balance, 2, '.', '')}}</td>
                </tr>
                @endforeach

                @foreach($sent_money_transfer_list as $key=>$sent_money)
                @php $balance = $balance - $sent_money->amount; @endphp
                <tr>
                    <td>{{$key}}</td>
                    <td>{{date($general_setting->date_format, strtotime($sent_money->created_at->toDateString()))}}</td>
                    <td>Money Transfer (Sent)</td>
                    <td>{{$sent_money->reference_no}}</td>
                    <td></td>
                    <td>0.00</td>
                    <td>{{number_format((float)$sent_money->amount, 2, '.', '')}}</td>
                    <td>{{number_format((float)$balance, 2, '.', '')}}</td>
                </tr>
                @endforeach
            </tbody>
        </table>
    </div>
</section>

<script type="text/javascript">
    $("ul#account").siblings('a').attr('aria-expanded','true');
    $("ul#account").addClass("show");
    $("ul#account #account-statement-menu").addClass("active");

    var table = $('#account-table').DataTable( {
        "order": [],
        'language': {
            'lengthMenu': '_MENU_ {{trans("file.records per page")}}',
             "info":      '<small>{{trans("file.Showing")}} _START_ - _END_ (_TOTAL_)</small>',
            "search":  '{{trans("file.Search")}}',
            'paginate': {
                    'previous': '<i class="dripicons-chevron-left"></i>',
                    'next': '<i class="dripicons-chevron-right"></i>'
            }
        },
        'columnDefs': [
            {
                "orderable": false,
                'targets': 0
            },
            {
                'render': function(data, type, row, meta){
                    if(type === 'display'){
                        data = '<div class="checkbox"><input type="checkbox" class="dt-checkboxes"><label></label></div>';
                    }

                   return data;
                },
                'checkboxes': {
                   'selectRow': true,
                   'selectAllRender': '<div class="checkbox"><input type="checkbox" class="dt-checkboxes"><label></label></div>'
                },
                'targets': [0]
            }
        ],
        'select': { style: 'multi',  selector: 'td:first-child'},
        'lengthMenu': [[10, 25, 50, -1], [10, 25, 50, "All"]],
        dom: '<"row"lfB>rtip',
        buttons: [
            {
                extend: 'pdf',
                text: '{{trans("file.PDF")}}',
                exportOptions: {
                    columns: ':visible:Not(.not-exported)',
                    rows: ':visible'
                }
            },
            {
                extend: 'csv',
                text: '{{trans("file.CSV")}}',
                exportOptions: {
                    columns: ':visible:Not(.not-exported)',
                    rows: ':visible'
                }
            },
            {
                extend: 'print',
                text: '{{trans("file.Print")}}',
                exportOptions: {
                    columns: ':visible:Not(.not-exported)',
                    rows: ':visible'
                }
            },
            {
                extend: 'colvis',
                text: '{{trans("file.Column visibility")}}',
                columns: ':gt(0)'
            },
        ],
    } );

</script>
@endsection