<?php
namespace App\Traits;

use App\SeoMeta; // Update if your model namespace is different
use SEOTools;

trait SeoTrait
{
    public function applySeo($modelType, $modelId = null)
    {
        $query = SeoMeta::where('model_type', $modelType);

        if ($modelId) {
            $query->where('model_id', $modelId);
        }

        $seo = $query->first();

        if ($seo) {
            SEOTools::setTitle($seo->title ?? '');
            SEOTools::setDescription($seo->meta_description ?? '');
            SEOTools::setCanonical($seo->canonical_url ?? url()->current());
            SEOTools::metatags()->addKeyword(explode(',', $seo->meta_keywords ?? ''));

            $page = request()->get('page', 1);
            if ($page > 1) {
                $title = $seo->title . " - Page " . $page;
                $description = "Page " . $page . ": " . $seo->meta_description;

                SEOTools::setTitle($title);
                SEOTools::setDescription($description);
            }

            if (!empty($seo->robots)) {
                SEOTools::metatags()->setRobots($seo->robots);
            }

            if (!empty($seo->custom_head_script)) {
                view()->share('customHeadScript', $seo->custom_head_script);
            }
        }
    }
}
