<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\MorphTo;

class SeoMeta extends Model
{
    protected $table = 'seo_metas';
    protected $fillable = [
        'model_type',
        'model_id',
        'slug',
        'title',
        'meta_description',
        'meta_keywords',
        'robots',
        'canonical_url',
        'custom_head_script'
    ];

    /**
     * Get the parent SEO-able model (Product, Page, etc.).
     */
    public function seoable(): MorphTo
    {
        return $this->morphTo(__FUNCTION__, 'model_type', 'model_id');
    }


}
