<?php

namespace App\Http\Controllers\front;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use DB;
use App\Category;
use App\Product;
use App\Customer;
use App\Unit;
use App\CashRegister;
use App\Sale;
use App\ProductVariant;
use App\Variant;
use App\Product_Sale;
use App\Delivery;
use App\Slider;
use App\Page;
use App\Faq;
use App\Add;
use App\MailSetting;
use Auth;
use App\Biller;
use App\Mail\UserNotification;
use Illuminate\Support\Facades\Mail;
use Gloudemans\Shoppingcart\Facades\Cart; // for cart lib

class WebController extends Controller
{
    //
    public function authenticate(){
        
        if (Auth::user()->role_id == 5) {
            return redirect('/checkout');
        } 

        else {
            return redirect('/home');
        }
    }
    public function index()
    {
       
        /*$cart= Cart::content();
        $slider = Slider::orderBy('id', 'desc')->paginate(3);
        $category = Category::paginate(3);
        $product = Products::orderBy('id', 'desc')->paginate(8);
        $order= DB::table('order_products')
        ->leftJoin('products','order_products.products_id','=','products.id')
        ->select('products_id','product_name','product_price','image',DB::raw('count(*) as cnt'))
        ->groupBy('products_id','product_name','product_price','image')
        ->orderBy('cnt', 'DESC')
        ->take(8)
        ->get();*/
        $categoriesWithMoreThan3Products = Product::select('category_id',
                                        DB::raw('COUNT(*) as product_count'),
                                        DB::raw('MAX(created_at) as latest_product_created_at')
                                        )
                                            ->where('is_active', true)
                                            ->groupBy('category_id')
                                            ->having('product_count', '>=', 3)
                                            ->take(3)
                                            ->get();
                                            //dd($categoriesWithMoreThan3Products);
        $cart_items = Cart::content();
        $featured_products = Product::where('is_active',true)->where('featured',true)->paginate(20);
        $deal_products = Product::where('is_active',true)->where('promotion_price','!=',null)->paginate(20);
        $products = Product::where('is_active',true)->orderBy('id','desc')->paginate(20);
        $categories = Category::where('is_active',true)->orderBy('id','desc')->where('parent_id',null)->get();
        $parent_category = Category::where('is_active',true)->orderBy('id','desc')->where('parent_id',null)->paginate(9);
        $general_setting = DB::table('general_settings')->latest()->first();
        /*return view('index',compact('slider','product','category','cart','order'));*/

        //dynamic
        $home = Page::where('name','Home')->first();
        $sliders=Slider::all();
        $pc1 = Product::where('category_id','1')->orderBy('id','desc')->get();
        $pc2 = Product::where('category_id','2')->orderBy('id','desc')->get();
        $pc3 = Product::where('category_id','3')->orderBy('id','desc')->get();
        $pc4 = Product::where('category_id','4')->orderBy('id','desc')->get();
        $adds = Add::orderBy('created_at', 'asc')->limit(6)->get();
        $add7 = Add::where('id','8')->first();
        return view('front/index-2',compact('general_setting','categories','products','deal_products','cart_items','featured_products','categoriesWithMoreThan3Products','parent_category','home','sliders','pc1','pc2','pc3','pc4','adds','add7'));
     
    }

    public function wishlist(){
        $cart_items = Cart::content();
        return view('front/wishlist',compact('cart_items'));
    }

    public function track_order(){
        $categories = Category::where('is_active',true)->orderBy('id','desc')->where('parent_id',null)->get();
        $cart_items = Cart::content();
        $user = Auth::user();
        $customer = Customer::where('user_id',$user->id)->first();
        $orders = Sale::where('customer_id',$customer->id)->orderBy('id','desc')->get();
        return view('front/track_order',compact('cart_items','orders','categories'));
    }

    /*public function errorpage(){
        $cart_items = Cart::content();
        return view('front/404',compact('cart_items'));
    }*/
    public function about_us(){
        $categories = Category::where('is_active',true)->orderBy('id','desc')->where('parent_id',null)->get();
        $cart_items = Cart::content();
        $about = Page::where('name','About')->first();
        return view('front/about-us',compact('cart_items','categories','about'));
    }
    public function contact(){
        $categories = Category::where('is_active',true)->orderBy('id','desc')->where('parent_id',null)->get();
        $cart_items = Cart::content();
        return view('front/contact',compact('cart_items','categories'));
    }
    public function faq(){
        $categories = Category::where('is_active',true)->orderBy('id','desc')->where('parent_id',null)->get();
        $cart_items = Cart::content();
        $faqs=Faq::all();
        return view('front/faq',compact('cart_items','categories','faqs'));
    }
    public function privacy_policy(){
        $categories = Category::where('is_active',true)->orderBy('id','desc')->where('parent_id',null)->get();
        $cart_items = Cart::content();
        $policy = Page::where('name','Privacy Policy')->first();
        return view('front/privacy_policy',compact('cart_items','categories','policy'));
    }
    public function return_policy(){
        $categories = Category::where('is_active',true)->orderBy('id','desc')->where('parent_id',null)->get();
        $cart_items = Cart::content();
        $returns = Page::where('name','Return Policy')->first();
        return view('front/return_policy',compact('cart_items','categories','returns'));
    }
    public function terms_conditions(){
        $categories = Category::where('is_active',true)->orderBy('id','desc')->where('parent_id',null)->get();
        $cart_items = Cart::content();
        $terms = Page::where('name','Terms and Conditions')->first();
        return view('front/terms_conditions',compact('cart_items','categories','terms'));
    }


    public function single_product($id){
        $categories = Category::where('is_active',true)->orderBy('id','desc')->where('parent_id',null)->get();
        $cart_items = Cart::content();
        $product = Product::find($id);
        return view('front/single-product',compact('product','cart_items','categories'));

    }

    public function order_now($id)
    {
        // Retrieve the product details
        $product = Product::find($id);

        // Check if the product exists and is active
        if (!$product || !$product->is_active) {
            return redirect()->back()->with('error', 'Product not found or not active');
        }

        // Add the product to the cart
        $cartItem = Cart::add([
            'id' => $product->id,
            'name' => $product->name,
            'qty' => 1, // Default quantity to 1 for 'order now'
            'price' => $product->promotion_price ?? $product->price,
            'weight' => 0,
            'options' => [
                'size' => null,
                'product_code' => $product->code
            ]
        ]);

        // Retrieve the necessary elements for the view
        $categories = Category::where('is_active', true)->orderBy('id', 'desc')->where('parent_id', null)->get();
        $cart_items = Cart::content();

        // Return the 'order_now' view with the product details and other necessary data
        return view('front/order_now', compact('product', 'cart_items', 'categories'));
    }


    public function shopwithus(){
        $categories = Category::where('is_active',true)->orderBy('id','desc')->where('parent_id',null)->get();
        $cart_items = Cart::content();
        $swu = Page::where('name','Why Shop With Us')->first();
        return view('front/shopwithus',compact('cart_items','categories','swu'));

    }
    public function payment(){
        $categories = Category::where('is_active',true)->orderBy('id','desc')->where('parent_id',null)->get();
        $cart_items = Cart::content();
        $payments = Page::where('name','Payment')->first();
        return view('front/payment',compact('cart_items','categories','payments'));

    }
    public function shipping(){
        $categories = Category::where('is_active',true)->orderBy('id','desc')->where('parent_id',null)->get();
        $cart_items = Cart::content();
        $shipping = Page::where('name','Shipping')->first();
        return view('front/shipping',compact('cart_items','categories','shipping'));

    }

    public function shop_left_sidebar(){
        $categories = Category::where('is_active',true)->orderBy('id','desc')->where('parent_id',null)->get();
        $cart_items = Cart::content();
        $products = Product::where('is_active',true)->orderBy('id','desc')->paginate(20);
        $image=Page::where('name','Shop')->first();
        return view('front/shop',compact('products','cart_items','categories','image'));
    }

    public function shop_left_sidebar_by_id($id){
        $categories = Category::where('is_active',true)->orderBy('id','desc')->where('parent_id',null)->get();
        $cart_items = Cart::content();
        /*$products = Product::where('is_active',true)->orderBy('id','desc')->where('category_id',$id)->paginate(20);*/
        $products = Product::join('categories', 'products.category_id', '=', 'categories.id')
            ->select('products.*')
            ->whereIn('products.category_id', function ($query) use ($id) {
                $query->select('id')
                    ->from('categories')
                    ->where('id', $id)
                    ->orWhere('parent_id', $id);
            })
            ->where('products.is_active', true)
            ->paginate(20);
            
        $image=Page::where('name','Shop')->first();

        return view('front/shopbyid',compact('products','cart_items','categories','image'));
    }

    public function product_search(Request $request){
        $categories = Category::where('is_active',true)->orderBy('id','desc')->where('parent_id',null)->get();
        $cart_items = Cart::content();
        $page_type = 1;
        $keyword = $request->search;
        $products = DB::table('categories')
                    ->join('products', 'categories.id', '=', 'products.category_id')
                    ->where('categories.name', 'like', '%' . $keyword . '%')
                    ->where('categories.is_active', true)
                    ->where('products.is_active', true)
                    ->orWhere(function ($query) use ($keyword) {
                            $query->where('products.name', 'like', '%' . $keyword . '%')
                                  ->where('products.is_active', true);
                        })
                    ->get();
        /*dd($products);*/
        $image=Page::where('name','Shop')->first();
        return view('front/shop',compact('products','cart_items','page_type','categories','image'));

    }

    public function product_details_data($id){

        $product = Product::find($id);

        if($product->is_variant == null && $product->qty > 0){
            $stock_cond = 1;
        }
        elseif($product->is_variant != null){
            $stock_cond = 2;
        }
        else{$stock_cond = 3;}

        $product_detail[0] = $product->name;
        $product_detail[1] = $product->code;
        if($product->promotion_price == null){
            $product_detail[2] = $product->price;
        }
        else{
          $product_detail[2] = $product->promotion_price;  
        }
        $product_detail[3] = $product->product_details;
        $product_detail[4] = $product->image;
        $product_detail[5] = $product->id;
        $product_detail[6] = $stock_cond;
        return $product_detail;
    }

    public function checkout(){
        $categories = Category::where('is_active',true)->orderBy('id','desc')->where('parent_id',null)->get();
        $user = Auth::user();
        $cart_items= Cart::content();
        $customer_detail = Customer::where('user_id',$user->id)->first();
        return view('front/checkout',compact('cart_items','customer_detail','categories'));
    }

    public function addItem(Request $request){
        //dd($request->all());
        $product = Product::find($request->product_id);
        if($product->is_variant == null){
            if($product->qty < $request->quantity){
                return back()->with('error','quantity exceeds stock');
            }
        }
        else{
            $variant = ProductVariant::where('item_code',$request->product_code)->first();
            $stock = $variant->qty;
            if($stock < $request->quantity){
                return back()->with('error','quantity exceeds stock');
            }
        }
        $cart=Cart::add(['id'=>$request->product_id, 'name'=>$request->name,'qty'=>$request->quantity,'price'=>$request->price,'weight'=>0, 'options' => ['size' => null,'product_code'=>$request->product_code]]);

           
          return back()->with('success','Product added to cart');
         
   }

   public function update_cart(Request $request){
        $categories = Category::where('is_active',true)->orderBy('id','desc')->where('parent_id',null)->get();
        foreach($request->rowId as $key => $row){
            $cart_items= Cart::content();
            foreach($cart_items as $item){
                if($item->rowId == $row){
                    $product = Product::find($item->id);
                    if($product->is_variant == null){
                        if($product->qty < $request->quantity[$key]){
                            return view('front/shopping-cart', compact('cart_items'),['error'=>'quantity exceeds stock']);
                        }
                    }
                    else{
                        $variant = ProductVariant::where('item_code',$item->options->product_code)->first();
                        $stock = $variant->qty;
                        if($stock < $request->quantity[$key]){
                            return view('front/shopping-cart', compact('cart_items'),['error'=>'quantity exceeds stock']);
                        }
                    }
                }
            }
            $cart_update = Cart::update($row, $request->quantity[$key]);
        }
        $cart_items= Cart::content();
        //dd($cart_items);
        return redirect()->back();
   }

   public function removeItem($id){
        Cart::remove($id);
        $cart_items= Cart::content();
        return redirect()->back();
   }

    public function cart(){
        $categories = Category::where('is_active',true)->orderBy('id','desc')->where('parent_id',null)->get();
        $cart_items= Cart::content();
        return view('front/shopping-cart', compact('cart_items','categories'));

    }

    public function place_order(Request $request){
        /*dd($request->all());*/

        $categories = Category::where('is_active',true)->orderBy('id','desc')->where('parent_id',null)->get();
        $biller = Biller::where('is_active',true)->first();
        $data = $request->all();
        $cart_items= Cart::content();
        $item = $cart_items->count();
        $strSubtotal = Cart::subtotal();
        $subtotal = str_replace(',', '', $strSubtotal);
        $user = Auth::user();
        $customer = Customer::where('user_id',$user->id)->first();

        $data['reference_no'] = 'sr-' . date("Ymd") . '-'. date("his");
        $data['customer_id'] = $customer->id;
        $data['warehouse_id'] = "1";
        $data['biller_id'] = $biller->id;
        $data['item'] = $item;
        $data['total_qty'] = Cart::content()->count();
        $data['total_discount'] = "0.00";
        $data['total_tax'] = "0.00";
        $data['total_price'] = $subtotal;
        $data['order_tax'] = "0.00";
        $data['grand_total'] = $subtotal;
        $data['pos'] = "0";
        $data['coupon_active'] = "0";
        $data['order_tax_rate'] = "0";
        $data['sale_status'] = "2";
        $data['payment_status'] = "1";
        $data['paid_by_id'] = "1";
        $data['product_code_name'] = null;
        $data['order_discount'] = null;
        $data['shipping_cost'] = null;
        $data['paying_amount'] = null;
        $data['paid_amount'] = null;
        $data['gift_card_id'] = null;
        $data['cheque_no'] = null;
        $data['payment_note'] = null;
        $data['sale_note'] = null;
        $data['staff_note'] = null;
        //dd($cart_items);
        //return dd($data);
        $data['user_id'] = Auth::id();
        $cash_register_data = CashRegister::where([
            ['user_id', $data['user_id']],
            ['warehouse_id', $data['warehouse_id']],
            ['status', true]
        ])->first();

        if($cash_register_data)
            $data['cash_register_id'] = $cash_register_data->id;
        

        $lims_sale_data = Sale::create($data);
        $lims_customer_data = Customer::find($data['customer_id']);
        $key = 0;
        foreach($cart_items as $item){
            $product_details = Product::find($item->id);
            $sale_unit = Unit::find($product_details->sale_unit_id);
            $data['product_id'][$key] = $item->id;
            $data['product_batch_id'][$key] = null;
            $data['product_code'][$key] = $item->options->product_code;
            $data['qty'][$key] = $item->qty;
            $data['sale_unit'][$key] = $sale_unit->unit_name;
            $data['net_unit_price'][$key] = $product_details->price;
            $data['discount'][$key] = "0.00";
            $data['tax_rate'][$key] = "0.00";
            $data['tax'][$key] = "0.00";
            $data['subtotal'][$key] = $item->qty * $product_details->price;
            $key++;
        }
        //dd($data);
        $product_id = $data['product_id'];
        $product_batch_id = $data['product_batch_id'];
        $product_code = $data['product_code'];
        $qty = $data['qty'];
        $sale_unit = $data['sale_unit'];
        $net_unit_price = $data['net_unit_price'];
        $discount = $data['discount'];
        $tax_rate = $data['tax_rate'];
        $tax = $data['tax'];
        $total = $data['subtotal'];
        $product_sale = [];

        foreach ($product_id as $i => $id) {
            $lims_product_data = Product::where('id', $id)->first();
            $product_sale['variant_id'] = null;
            $product_sale['product_batch_id'] = null;


            if($sale_unit[$i] != 'n/a') {
                $lims_sale_unit_data  = Unit::where('unit_name', $sale_unit[$i])->first();
                $sale_unit_id = $lims_sale_unit_data->id;
                if($lims_product_data->is_variant) {
                    $lims_product_variant_data = ProductVariant::select('id', 'variant_id', 'qty')->FindExactProductWithCode($id, $product_code[$i])->first();
                    $product_sale['variant_id'] = $lims_product_variant_data->variant_id;
                }

                
            }
            else
                $sale_unit_id = 0;
            if($product_sale['variant_id']){
                $variant_data = Variant::select('name')->find($product_sale['variant_id']);
                $mail_data['products'][$i] = $lims_product_data->name . ' ['. $variant_data->name .']';
            }
            else
                $mail_data['products'][$i] = $lims_product_data->name;
            if($lims_product_data->type == 'digital')
                $mail_data['file'][$i] = url('/public/product/files').'/'.$lims_product_data->file;
            else
                $mail_data['file'][$i] = '';
            if($sale_unit_id)
                $mail_data['unit'][$i] = $lims_sale_unit_data->unit_code;
            else
                $mail_data['unit'][$i] = '';

            $product_sale['sale_id'] = $lims_sale_data->id ;
            $product_sale['product_id'] = $id;
            $product_sale['qty'] = $mail_data['qty'][$i] = $qty[$i];
            $product_sale['sale_unit_id'] = $sale_unit_id;
            $product_sale['net_unit_price'] = $net_unit_price[$i];
            $product_sale['discount'] = $discount[$i];
            $product_sale['tax_rate'] = $tax_rate[$i];
            $product_sale['tax'] = $tax[$i];
            $product_sale['total'] = $mail_data['total'][$i] = $total[$i];
            Product_Sale::create($product_sale);
        }
        
        $delivery = new Delivery ;
        $delivery->reference_no = 'dr-' . date("Ymd") . '-'. date("his");
        $delivery->sale_id = $lims_sale_data->id;
        $delivery->user_id = Auth::id();
        $delivery->address = 'address:' . $request->address. ', apt:'.$request->apartment. ', city:'.$request->city.', state:'.$request->state.', postcode:'.$request->postcode.', email:'.$request->email.', phone:'.$request->phone ;
        $delivery->delivered_by = 'ebexshop';
        $delivery->recieved_by = $request->name;
        $delivery->status = 0;
        $delivery->note = $request->name;
        $delivery->save();

            $message = ' order placed successfully';
            Cart::destroy();
            return view('front/order_completed',compact('cart_items','categories'));
    }

    public function guest_placeorder(Request $request)
    {
        /*dd($request->all());*/
        $categories = Category::where('is_active',true)->orderBy('id','desc')->where('parent_id',null)->get();
        $biller = Biller::where('is_active',true)->first();
        $data = $request->all();
        $cart_items= Cart::content();
        $item = $cart_items->count();
        $strSubtotal = Cart::subtotal();
        $subtotal = str_replace(',', '', $strSubtotal);
        $user = User::where('is_active',true)->first();
        $customer = Customer::where('name','at')->first();

        $data['reference_no'] = 'sr-' . date("Ymd") . '-'. date("his");
        $data['customer_id'] = $customer->id;
        $data['warehouse_id'] = "1";
        $data['biller_id'] = $biller->id;
        $data['item'] = $item;
        $data['total_qty'] = Cart::content()->count();
        $data['total_discount'] = "0.00";
        $data['total_tax'] = "0.00";
        $data['total_price'] = $subtotal;
        $data['order_tax'] = "0.00";
        $data['grand_total'] = $subtotal;
        $data['pos'] = "0";
        $data['coupon_active'] = "0";
        $data['order_tax_rate'] = "0";
        $data['sale_status'] = "2";
        $data['payment_status'] = "1";
        $data['paid_by_id'] = "1";
        $data['product_code_name'] = null;
        $data['order_discount'] = null;
        $data['shipping_cost'] = null;
        $data['paying_amount'] = null;
        $data['paid_amount'] = null;
        $data['gift_card_id'] = null;
        $data['cheque_no'] = null;
        $data['payment_note'] = null;
        $data['sale_note'] = null;
        $data['staff_note'] = null;
        //dd($cart_items);
        //return dd($data);
        $data['user_id'] = $user->id;
        $cash_register_data = CashRegister::where([
            ['user_id', $data['user_id']],
            ['warehouse_id', $data['warehouse_id']],
            ['status', true]
        ])->first();

        if($cash_register_data)
            $data['cash_register_id'] = $cash_register_data->id;
        

        $lims_sale_data = Sale::create($data);
        $lims_customer_data = Customer::find($data['customer_id']);
        $key = 0;
        foreach($cart_items as $item){
            $product_details = Product::find($item->id);
            $sale_unit = Unit::find($product_details->sale_unit_id);
            $data['product_id'][$key] = $item->id;
            $data['product_batch_id'][$key] = null;
            $data['product_code'][$key] = $item->options->product_code;
            $data['qty'][$key] = $item->qty;
            $data['sale_unit'][$key] = $sale_unit->unit_name;
            $data['net_unit_price'][$key] = $product_details->price;
            $data['discount'][$key] = "0.00";
            $data['tax_rate'][$key] = "0.00";
            $data['tax'][$key] = "0.00";
            $data['subtotal'][$key] = $item->qty * $product_details->price;
            $key++;
        }
        //dd($data);
        $product_id = $data['product_id'];
        $product_batch_id = $data['product_batch_id'];
        $product_code = $data['product_code'];
        $qty = $data['qty'];
        $sale_unit = $data['sale_unit'];
        $net_unit_price = $data['net_unit_price'];
        $discount = $data['discount'];
        $tax_rate = $data['tax_rate'];
        $tax = $data['tax'];
        $total = $data['subtotal'];
        $product_sale = [];

        foreach ($product_id as $i => $id) {
            $lims_product_data = Product::where('id', $id)->first();
            $product_sale['variant_id'] = null;
            $product_sale['product_batch_id'] = null;


            if($sale_unit[$i] != 'n/a') {
                $lims_sale_unit_data  = Unit::where('unit_name', $sale_unit[$i])->first();
                $sale_unit_id = $lims_sale_unit_data->id;
                if($lims_product_data->is_variant) {
                    $lims_product_variant_data = ProductVariant::select('id', 'variant_id', 'qty')->FindExactProductWithCode($id, $product_code[$i])->first();
                    $product_sale['variant_id'] = $lims_product_variant_data->variant_id;
                }

                
            }
            else
                $sale_unit_id = 0;
            if($product_sale['variant_id']){
                $variant_data = Variant::select('name')->find($product_sale['variant_id']);
                $mail_data['products'][$i] = $lims_product_data->name . ' ['. $variant_data->name .']';
            }
            else
                $mail_data['products'][$i] = $lims_product_data->name;
            if($lims_product_data->type == 'digital')
                $mail_data['file'][$i] = url('/public/product/files').'/'.$lims_product_data->file;
            else
                $mail_data['file'][$i] = '';
            if($sale_unit_id)
                $mail_data['unit'][$i] = $lims_sale_unit_data->unit_code;
            else
                $mail_data['unit'][$i] = '';

            $product_sale['sale_id'] = $lims_sale_data->id ;
            $product_sale['product_id'] = $id;
            $product_sale['qty'] = $mail_data['qty'][$i] = $qty[$i];
            $product_sale['sale_unit_id'] = $sale_unit_id;
            $product_sale['net_unit_price'] = $net_unit_price[$i];
            $product_sale['discount'] = $discount[$i];
            $product_sale['tax_rate'] = $tax_rate[$i];
            $product_sale['tax'] = $tax[$i];
            $product_sale['total'] = $mail_data['total'][$i] = $total[$i];
            Product_Sale::create($product_sale);
        }
        
        $delivery = new Delivery ;
        $delivery->reference_no = 'dr-' . date("Ymd") . '-'. date("his");
        $delivery->sale_id = $lims_sale_data->id;
        $delivery->user_id = Auth::id();
        $delivery->address = 'address:' . $request->address. ', apt:'.$request->apartment. ', city:'.$request->city.', state:'.$request->state.', postcode:'.$request->postcode.', email:'.$request->email.', phone:'.$request->phone ;
        $delivery->delivered_by = 'ebexshop';
        $delivery->recieved_by = $request->name;
        $delivery->status = 0;
        $delivery->note = $request->name;
        $delivery->save();

            $message = ' order placed successfully';
            Cart::destroy();
            return view('front/order_completed',compact('cart_items','categories'));
    }

    public function c_o(){
        $categories = Category::where('is_active',true)->orderBy('id','desc')->where('parent_id',null)->get();
        $cart_items= Cart::content();
        $add9 = Add::where('id','9')->first();
        return view('front/c_o',compact('cart_items','categories','add9'));
    }

    public function order_completed(){
        $categories = Category::where('is_active',true)->orderBy('id','desc')->where('parent_id',null)->get();
        $cart_items= Cart::content();
        $add9 = Add::where('id','9')->first();
        return view('front/order_completed',compact('cart_items','categories','add9'));
    }

    public function contact_mail(Request $request){

        $mail_data['name'] = $request->name;
        $mail_data['email'] = $request->email;
        $mail_data['subject'] = $request->subject;
        $mail_data['email_message'] = $request->message;
        //dd($mail_data);
        $message = ' Email sent successfully';
        try {
                Mail::send( 'mail.contact', $mail_data, function( $message ) use ($mail_data)
                {
                    $message->to( $mail_data['email'] )->subject( 'message from ebexshop' );

                });
            }
            catch(\Exception $e){
                $message = ' your Email was unfortunately not sent for some technical issues.';
            }
        return back()->with('success',$message );
    }



}