<?php

namespace App\Http\Controllers\front;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Srmklive\PayPal\Services\PayPal as PayPalClient;
use DB;
use App\User;
use App\Payment;
use App\Account;
use App\Customer;
use App\PaymentWithPaypal;
use App\PaymentGatewayAccount;
use App\Sale;
use Illuminate\Support\Facades\Mail;


class PayPalController extends Controller
{
    public function createTransaction()
    {
        $provider = new PayPalClient;
        $provider->setApiCredentials(config('paypal'));
        $token = $provider->getAccessToken();

        $provider->setAccessToken($token);
        $response = $provider->createOrder([
            "intent" => "CAPTURE",
            "application_context" => [
                "return_url" => route('paypal.success'),
                "cancel_url" => route('paypal.cancel'),
            ],
            "purchase_units" => [
                [
                    "amount" => [
                        "currency_code" => "USD",
                        "value" => "100.00" // You can make this dynamic
                    ]
                ]
            ]
        ]);

        if (isset($response['id']) && $response['status'] == 'CREATED') {
            foreach ($response['links'] as $link) {
                if ($link['rel'] === 'approve') {
                    return redirect()->away($link['href']);
                }
            }
        }

        return redirect()->route('paypal.cancel')->with('error', 'Something went wrong.');
    }

    public function successTransaction(Request $request)
    {
        //dd($request->all());
        $provider = new PayPalClient;
        $provider->setApiCredentials(config('paypal'));
        $token = $provider->getAccessToken();
        $provider->setAccessToken($token);

        $response = $provider->capturePaymentOrder($request['token']);

        if (isset($response['status']) && $response['status'] == 'COMPLETED') {
            // Save order details to DB if needed
            $sale = Sale::findOrFail($request->get('sale_id'));

            $amount = $sale->grand_total; // or pull from PayPal response if needed

            // Update sale
            $sale->paid_amount += $amount;
            $balance = $sale->grand_total - $sale->paid_amount;
            $sale->payment_status = ($balance == 0) ? 4 : 2;
            $sale->save();

            // Get user/account
            $user = User::where('is_active', true)->first();
            $account = PaymentGatewayAccount::where('gateway','paypal')->first();
            if(!$account || !$account->gateway){
                $account = Account::where('is_active', true)->first();
                $ac_id = $account->id;
            } else {
                $ac_id = $account->account_id;
            }

            // Save payment
            $payment = new Payment();
            $payment->user_id = $user->id ?? null;
            $payment->sale_id = $sale->id;
            $payment->account_id = $ac_id ?? null;
            $payment->payment_reference = 'pp-' . date("Ymd") . '-' . date("His");
            $payment->amount = $amount;
            $payment->change = 0;
            $payment->paying_method = 'Paypal';
            $payment->payment_note = 'PayPal Transaction ID: ' . $response['id'];
            $payment->save();

            PaymentWithPaypal::create([
                'payment_id' => $payment->id,
                'transaction_id' => $response['id'],
            ]);

            try {
                // Extract email from sale_note
                preg_match('/Email:\s*([^\s,]+)/i', $sale->sale_note, $matches);
                $recipientEmail = $matches[1] ?? null;

                if ($recipientEmail) {
                    $mailData = [
                        'sale' => $sale,
                        'payment' => $payment,
                    ];

                    Mail::send('mail.receipt_paypal', $mailData, function ($message) use ($recipientEmail) {
                        $message->to($recipientEmail)
                                ->subject('Payment Receipt');
                    });
                }
            } catch (\Exception $e) {
                // Log error but don’t stop the process
                \Log::error('Email sending failed: ' . $e->getMessage());
            }



            return redirect()->route('order_completed')->with('success', 'Transaction complete.');
        }

        return redirect()->route('paypal.cancel')->with('error', 'Payment failed.');
    }

    public function cancelTransaction()
    {
        return redirect()->route('order_completed')->with('error', 'Transaction canceled.');
    }
}

