<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Customer;
use App\CustomerGroup;
use App\Warehouse;
use App\Biller;
use App\Account;
use App\Currency;
use App\PosSetting;
use App\GeneralSetting;
use App\HrmSetting;
use App\sms;
use App\sms_details;
use DB;
use ZipArchive;
use Twilio\Rest\Client;
use Clickatell\Rest;
use Clickatell\ClickatellException;
use App\PaymentGatewayAccount;
use App\SiteSetting;


class SettingController extends Controller
{
    public function emptyDatabase()
    {
        if(!env('USER_VERIFIED'))
            return redirect()->back()->with('not_permitted', 'This feature is disable for demo!');
        $tables = DB::select('SHOW TABLES');
        $str = 'Tables_in_' . env('DB_DATABASE');
        foreach ($tables as $table) {
            if($table->$str != 'accounts' && $table->$str != 'general_settings' && $table->$str != 'hrm_settings' && $table->$str != 'languages' && $table->$str != 'migrations' && $table->$str != 'password_resets' && $table->$str != 'permissions' && $table->$str != 'pos_setting' && $table->$str != 'roles' && $table->$str != 'role_has_permissions' && $table->$str != 'users' && $table->$str != 'currencies') {
                DB::table($table->$str)->truncate();    
            }
        }
        return redirect()->back()->with('message', 'Database cleared successfully');
    }
    public function generalSetting()
    {
        $lims_general_setting_data = GeneralSetting::latest()->first();
        $lims_account_list = Account::where('is_active', true)->get();
        $lims_currency_list = Currency::get();
        $zones_array = array();
        $timestamp = time();
        foreach(timezone_identifiers_list() as $key => $zone) {
            date_default_timezone_set($zone);
            $zones_array[$key]['zone'] = $zone;
            $zones_array[$key]['diff_from_GMT'] = 'UTC/GMT ' . date('P', $timestamp);
        }
        return view('setting.general_setting', compact('lims_general_setting_data', 'lims_account_list', 'zones_array', 'lims_currency_list'));
    }

    public function generalSettingStore(Request $request)
    {
        if(!env('USER_VERIFIED'))
            return redirect()->back()->with('not_permitted', 'This feature is disable for demo!');

        $this->validate($request, [
            'site_logo' => 'image|mimes:jpg,jpeg,png,gif|max:100000',
        ]);

        $data = $request->except('site_logo');
        //return $data;
        //writting timezone info in .env file
        $path = '.env';
        $searchArray = array('APP_TIMEZONE='.env('APP_TIMEZONE'));
        $replaceArray = array('APP_TIMEZONE='.$data['timezone']);

        file_put_contents($path, str_replace($searchArray, $replaceArray, file_get_contents($path)));

        $general_setting = GeneralSetting::latest()->first();
        $general_setting->id = 1;
        $general_setting->site_title = $data['site_title'];
        $general_setting->currency = $data['currency'];
        $general_setting->currency_position = $data['currency_position'];
        $general_setting->staff_access = $data['staff_access'];
        $general_setting->date_format = $data['date_format'];
        $general_setting->developed_by = $data['developed_by'];
        $general_setting->invoice_format = $data['invoice_format'];
        $general_setting->state = $data['state'];
        $logo = $request->site_logo;
        if ($logo) {
            $ext = pathinfo($logo->getClientOriginalName(), PATHINFO_EXTENSION);
            $logoName = date("Ymdhis") . '.' . $ext;
            $logo->move('public/logo', $logoName);
            $general_setting->site_logo = $logoName;
        }
        $general_setting->save();
        return redirect()->back()->with('message', 'Data updated successfully');
    }

    public function backup()
    {
        if(!env('USER_VERIFIED'))
            return redirect()->back()->with('not_permitted', 'This feature is disable for demo!');

        // Database configuration
        $host = env('DB_HOST');
        $username = env('DB_USERNAME');
        $password = env('DB_PASSWORD');
        $database_name = env('DB_DATABASE');

        // Get connection object and set the charset
        $conn = mysqli_connect($host, $username, $password, $database_name);
        $conn->set_charset("utf8");


        // Get All Table Names From the Database
        $tables = array();
        $sql = "SHOW TABLES";
        $result = mysqli_query($conn, $sql);

        while ($row = mysqli_fetch_row($result)) {
            $tables[] = $row[0];
        }

        $sqlScript = "";
        foreach ($tables as $table) {
            
            // Prepare SQLscript for creating table structure
            $query = "SHOW CREATE TABLE $table";
            $result = mysqli_query($conn, $query);
            $row = mysqli_fetch_row($result);
            
            $sqlScript .= "\n\n" . $row[1] . ";\n\n";
            
            
            $query = "SELECT * FROM $table";
            $result = mysqli_query($conn, $query);
            
            $columnCount = mysqli_num_fields($result);
            
            // Prepare SQLscript for dumping data for each table
            for ($i = 0; $i < $columnCount; $i ++) {
                while ($row = mysqli_fetch_row($result)) {
                    $sqlScript .= "INSERT INTO $table VALUES(";
                    for ($j = 0; $j < $columnCount; $j ++) {
                        $row[$j] = $row[$j];
                        
                        if (isset($row[$j])) {
                            $sqlScript .= '"' . $row[$j] . '"';
                        } else {
                            $sqlScript .= '""';
                        }
                        if ($j < ($columnCount - 1)) {
                            $sqlScript .= ',';
                        }
                    }
                    $sqlScript .= ");\n";
                }
            }
            
            $sqlScript .= "\n"; 
        }

        if(!empty($sqlScript))
        {
            // Save the SQL script to a backup file
            $backup_file_name = public_path().'/'.$database_name . '_backup_' . time() . '.sql';
            //return $backup_file_name;
            $fileHandler = fopen($backup_file_name, 'w+');
            $number_of_lines = fwrite($fileHandler, $sqlScript);
            fclose($fileHandler);

            $zip = new ZipArchive();
            $zipFileName = $database_name . '_backup_' . time() . '.zip';
            $zip->open(public_path() . '/' . $zipFileName, ZipArchive::CREATE);
            $zip->addFile($backup_file_name, $database_name . '_backup_' . time() . '.sql');
            $zip->close();

            // Download the SQL backup file to the browser
            /*header('Content-Description: File Transfer');
            header('Content-Type: application/octet-stream');
            header('Content-Disposition: attachment; filename=' . basename($backup_file_name));
            header('Content-Transfer-Encoding: binary');
            header('Expires: 0');
            header('Cache-Control: must-revalidate');
            header('Pragma: public');
            header('Content-Length: ' . filesize($backup_file_name));
            ob_clean();
            flush();
            readfile($backup_file_name);
            exec('rm ' . $backup_file_name); */
        }
        return redirect('public/' . $zipFileName);
    }

    public function changeTheme($theme)
    {
        $lims_general_setting_data = GeneralSetting::latest()->first();
        $lims_general_setting_data->theme = $theme;
        $lims_general_setting_data->save();
    }

    public function mailSetting()
    {  
        return view('setting.mail_setting');
    }

    public function mailSettingStore(Request $request)
    {
        if(!env('USER_VERIFIED'))
            return redirect()->back()->with('not_permitted', 'This feature is disable for demo!');

        $data = $request->all();
        //writting mail info in .env file
        $path = '.env';
        $searchArray = array('MAIL_HOST="'.env('MAIL_HOST').'"', 'MAIL_PORT='.env('MAIL_PORT'), 'MAIL_FROM_ADDRESS="'.env('MAIL_FROM_ADDRESS').'"', 'MAIL_FROM_NAME="'.env('MAIL_FROM_NAME').'"', 'MAIL_USERNAME="'.env('MAIL_USERNAME').'"', 'MAIL_PASSWORD="'.env('MAIL_PASSWORD').'"', 'MAIL_ENCRYPTION="'.env('MAIL_ENCRYPTION').'"');
        //return $searchArray;

        $replaceArray = array('MAIL_HOST="'.$data['mail_host'].'"', 'MAIL_PORT='.$data['port'], 'MAIL_FROM_ADDRESS="'.$data['mail_address'].'"', 'MAIL_FROM_NAME="'.$data['mail_name'].'"', 'MAIL_USERNAME="'.$data['mail_address'].'"', 'MAIL_PASSWORD="'.$data['password'].'"', 'MAIL_ENCRYPTION="'.$data['encryption'].'"');
        
        file_put_contents($path, str_replace($searchArray, $replaceArray, file_get_contents($path)));

        return redirect()->back()->with('message', 'Data updated successfully');
    }

    public function smsSetting()
    {
        return view('setting.sms_setting');
    }

    public function smsSettingStore(Request $request)
    {
        if(!env('USER_VERIFIED'))
            return redirect()->back()->with('not_permitted', 'This feature is disable for demo!');
        
        $data = $request->all();
        //writting bulksms info in .env file
        $path = '.env';
        if($data['gateway'] == 'twilio'){
            $searchArray = array('SMS_GATEWAY='.env('SMS_GATEWAY'), 'ACCOUNT_SID='.env('ACCOUNT_SID'), 'AUTH_TOKEN='.env('AUTH_TOKEN'), 'Twilio_Number='.env('Twilio_Number') );

            $replaceArray = array('SMS_GATEWAY='.$data['gateway'], 'ACCOUNT_SID='.$data['account_sid'], 'AUTH_TOKEN='.$data['auth_token'], 'Twilio_Number='.$data['twilio_number'] );
        }
        /*custom adding songbird array to env*/
        elseif($data['gateway'] == 'songbird'){
            $searchArray = array('SMS_GATEWAY='.env('SMS_GATEWAY'), 'SONGBIRD_API_KEY='.env('SONGBIRD_API_KEY'), 'SONGBIRD_SECRET_KEY='.env('SONGBIRD_SECRET_KEY'), 'SONGBIRD_CALLER_ID='.env('SONGBIRD_CALLER_ID') );

            $replaceArray = array('SMS_GATEWAY='.$data['gateway'], 'SONGBIRD_API_KEY='.$data['apikey'], 'SONGBIRD_SECRET_KEY='.$data['secretkey'], 'SONGBIRD_CALLER_ID='.$data['callerID'] );
            DB::table('sms_counter')
                    ->where('id', 1) // Specify the condition to find the record
                    ->update([
                        'counter' => $data['counter'],
                    ]);
        }
        /*custom adding songbird array to env ends*/
        else{
            $searchArray = array( 'SMS_GATEWAY='.env('SMS_GATEWAY'), 'CLICKATELL_API_KEY='.env('CLICKATELL_API_KEY') );
            $replaceArray = array( 'SMS_GATEWAY='.$data['gateway'], 'CLICKATELL_API_KEY='.$data['api_key'] );
        }

        file_put_contents($path, str_replace($searchArray, $replaceArray, file_get_contents($path)));
        return redirect()->back()->with('message', 'Data updated successfully');
    }

    public function createSms()
    {
        $lims_customer_list = Customer::where('is_active', true)->get();
        return view('setting.create_sms', compact('lims_customer_list'));
    }

    public function sendSms(Request $request)
    {
        $data = $request->all();
        $type = $request->s_type;

        if (env('SMS_GATEWAY') != 'songbird' || $type == 'number') {
            $info = explode(",", $data['mobile']);
        }

        if (env('SMS_GATEWAY') == 'twilio') {
            $account_sid = env('ACCOUNT_SID');
            $auth_token = env('AUTH_TOKEN');
            $twilio_phone_number = env('Twilio_Number');
            try {
                $client = new Client($account_sid, $auth_token);
                foreach ($info as $number) {
                    $client->messages->create(
                        $number,
                        [
                            "from" => $twilio_phone_number,
                            "body" => $data['message']
                        ]
                    );
                }
            } catch (\Exception $e) {
                return redirect()->back()->with('not_permitted', 'Please setup your <a href="sms_setting">SMS Setting</a> to send SMS.');
            }
            $message = "SMS sent successfully";
        }

        elseif (env('SMS_GATEWAY') == 'clickatell') {
            try {
                $clickatell = new \Clickatell\Rest(env('CLICKATELL_API_KEY'));
                foreach ($info as $number) {
                    $clickatell->sendMessage(['to' => [$number], 'content' => $data['message']]);
                }
            } catch (ClickatellException $e) {
                return redirect()->back()->with('not_permitted', 'Please setup your <a href="sms_setting">SMS Setting</a> to send SMS.');
            }
            $message = "SMS sent successfully";
        }

        elseif (env('SMS_GATEWAY') == 'songbird') {
            $counter = DB::table('sms_counter')->first();
            $counter_up = $counter->counter;

            $apikey = env('SONGBIRD_API_KEY');
            $secretkey = env('SONGBIRD_SECRET_KEY');
            $callerID = env('SONGBIRD_CALLER_ID');

            if ($type == 'customer') {
                $info = $data['customer_id']; // array of customer IDs
            }

            $sms_cr = sms::create($data); // Create SMS record
            $sms_details = [];

            // Calculate total required SMS parts
            $messageLength = mb_strlen($data['message']);
            $messageCountPerRecipient = ceil($messageLength / 160);
            $totalRecipients = count($info);
            $totalMessagePartsRequired = $messageCountPerRecipient * $totalRecipients;

            if ($counter_up < $totalMessagePartsRequired) {
                $message = "Insufficient Balance. Needed: $totalMessagePartsRequired, Available: $counter_up. Please recharge to proceed.";
                return redirect()->back()->with('message', $message);
            }

            foreach ($info as $id) {
                if ($type == 'customer') {
                    $sms_customer = Customer::find($id);
                    $phoneNumber = $sms_customer->phone_number;
                } else {
                    $phoneNumber = $id;
                }

                $param = [
                    'apikey' => $apikey,
                    'secretkey' => $secretkey,
                    'callerID' => $callerID,
                    'messageContent' => $data['message'],
                    'toUser' => $phoneNumber
                ];

                $url = "http://103.53.84.15:8746/sendtext?" . http_build_query($param);
                $ch = curl_init($url);

                curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                curl_setopt($ch, CURLOPT_FAILONERROR, true);
                curl_setopt($ch, CURLOPT_TIMEOUT, 30);
                curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 10);
                curl_setopt($ch, CURLOPT_VERBOSE, true);
                curl_setopt($ch, CURLOPT_HEADER, true);
                curl_setopt($ch, CURLOPT_HTTPHEADER, ['Content-Type: application/x-www-form-urlencoded']);

                $result = curl_exec($ch);
                $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
                $curlError = curl_error($ch);

                $sms_details['sms_id'] = $sms_cr->id;

                if (curl_errno($ch)) {
                    $sms_details['status'] = 'Error: ' . $curlError . ' (HTTP Code: ' . $httpCode . ')';
                } else {
                    $sms_details['status'] = 'Success: ' . $result . ' (HTTP Code: ' . $httpCode . ')';
                    if ($type == 'customer') {
                        $sms_details['customer_id'] = $sms_customer->id;
                    } elseif ($type == 'number') {
                        $sms_details['number'] = $id;
                    }

                    $sms_details['counter'] = $messageCountPerRecipient;
                    sms_details::create($sms_details);

                    // Decrement SMS counter
                    $counter_up -= $messageCountPerRecipient;

                    DB::table('sms_counter')
                        ->where('id', 1)
                        ->update(['counter' => $counter_up]);
                }

                curl_close($ch);
                \Log::info('SMS Details: ', $sms_details);
            }

            $message = "SMS sent successfully to all recipients.";
        }


        else {
            return redirect()->back()->with('not_permitted', 'Please setup your <a href="sms_setting">SMS Setting</a> to send SMS.');
        }

        return redirect()->back()->with('message', $message);
    }


    // payment gateway setting


    public function pgSetting()
    {
        $account_list = Account::where('is_active', true)->get();
        $paymentgateway_accounts = PaymentGatewayAccount::pluck('account_id', 'gateway');
        return view('setting.paymentgateway_setting',compact('account_list','paymentgateway_accounts'));
    }

    public function pgSettingStore(Request $request)
    {
        if (!env('USER_VERIFIED')) {
            return redirect()->back()->with('not_permitted', 'This feature is disabled for demo!');
        }

        $data = $request->all();
        $path = base_path('.env');
        $envContent = file_get_contents($path);

        // Determine selected gateways (always an array because of checkbox name="gateway[]")
        $selectedGateways = $data['gateway'] ?? [];

        // Initialize search and replace arrays
        $allGateways = ['sslcommerz', 'stripe', 'bkash', 'nagad','paypal'];
        $searchArray = [];
        $replaceArray = [];

        foreach ($selectedGateways as $gateway) {
            switch ($gateway) {
                case 'sslcommerz':
                    $searchArray = array_merge($searchArray, [
                        'SSLCZ_STORE_ID=' . env('SSLCZ_STORE_ID'),
                        'SSLCZ_STORE_PASSWORD=' . env('SSLCZ_STORE_PASSWORD'),
                        'SSLCZ_TESTMODE=' . env('SSLCZ_TESTMODE'),

                    ]);
                    $replaceArray = array_merge($replaceArray, [
                        'SSLCZ_STORE_ID=' . $data['ssl_store_id'],
                        'SSLCZ_STORE_PASSWORD=' . $data['ssl_store_password'],
                        'SSLCZ_TESTMODE=' . (isset($data['sslcommerz_sandbox']) && $data['sslcommerz_sandbox'] ? 'true' : 'false'),

                    ]);
                    break;

                case 'stripe':
                    $searchArray = array_merge($searchArray, [
                        'STRIPE_KEY=' . env('STRIPE_KEY'),
                        'STRIPE_SECRET=' . env('STRIPE_SECRET'),
                    ]);
                    $replaceArray = array_merge($replaceArray, [
                        'STRIPE_KEY=' . $data['stripe_publishable_key'],
                        'STRIPE_SECRET=' . $data['stripe_secret_key'],
                    ]);
                    break;

                case 'bkash':
                    $searchArray = array_merge($searchArray, [
                        'BKASH_MODE=' . env('BKASH_MODE'),
                        'BKASH_USERNAME=' . env('BKASH_USERNAME'),
                        'BKASH_PASSWORD=' . env('BKASH_PASSWORD'),
                        'BKASH_APP_KEY=' . env('BKASH_APP_KEY'),
                        'BKASH_APP_SECRET=' . env('BKASH_APP_SECRET'),
                        'SANDBOX=' . env('SANDBOX'),
                    ]);
                    $replaceArray = array_merge($replaceArray, [
                        'BKASH_MODE=' . $data['bkash_mode'],
                        'BKASH_USERNAME=' . $data['bkash_number'],
                        'BKASH_PASSWORD=' . $data['bkash_password'],
                        'BKASH_APP_KEY=' . $data['bkash_app_key'],
                        'BKASH_APP_SECRET=' . $data['bkash_app_secret'],
                        'SANDBOX=' . (isset($data['bkash_sandbox']) && $data['bkash_sandbox'] ? 'true' : 'false'),
                    ]);
                    break;

                case 'nagad':
                    $searchArray = array_merge($searchArray, [
                        'NAGAD_NUMBER=' . env('NAGAD_NUMBER'),
                    ]);
                    $replaceArray = array_merge($replaceArray, [
                        'NAGAD_NUMBER=' . $data['nagad_number'],
                    ]);
                    break;
                case 'paypal':
                    $searchArray = array_merge($searchArray, [
                        'PAYPAL_CLIENT_ID=' . env('PAYPAL_CLIENT_ID'),
                        'PAYPAL_SECRET=' . env('PAYPAL_SECRET'),
                        'PAYPAL_CURRENCY=' . env('PAYPAL_CURRENCY'),
                        'PAYPAL_APP_ID=' . env('PAYPAL_APP_ID'),
                        'PAYPAL_MODE=' . env('PAYPAL_MODE'),
                    ]);
                    $replaceArray = array_merge($replaceArray, [
                        'PAYPAL_CLIENT_ID=' . $data['paypal_client_id'],
                        'PAYPAL_SECRET=' . $data['paypal_secret'],
                        'PAYPAL_CURRENCY=' . $data['paypal_currency'],
                        'PAYPAL_APP_ID=' . $data['paypal_app_id'],
                        'PAYPAL_MODE=' . (isset($data['paypal_sandbox']) && $data['paypal_sandbox'] ? 'sandbox' : 'live'),
                    ]);
                    break;


                default:
                    return redirect()->back()->with('not_permitted', 'Invalid Payment Gateway!');
            }
        }

        $unselectedGateways = array_diff($allGateways, $selectedGateways);
        
        foreach ($unselectedGateways as $gateway) {
            switch ($gateway) {
                case 'sslcommerz':
                    $searchArray = array_merge($searchArray, [
                        'SSLCZ_STORE_ID=' . env('SSLCZ_STORE_ID'),
                        'SSLCZ_STORE_PASSWORD=' . env('SSLCZ_STORE_PASSWORD'),
                        'SSLCZ_TESTMODE=' . env('SSLCZ_TESTMODE'),
                    ]);
                    $replaceArray = array_merge($replaceArray, [
                        'SSLCZ_STORE_ID=',
                        'SSLCZ_STORE_PASSWORD=',
                        'SSLCZ_TESTMODE=',
                    ]);
                    break;
                case 'stripe':
                    $searchArray = array_merge($searchArray, [
                        'STRIPE_KEY=' . env('STRIPE_KEY'),
                        'STRIPE_SECRET=' . env('STRIPE_SECRET'),
                    ]);
                    $replaceArray = array_merge($replaceArray, [
                        'STRIPE_KEY=',
                        'STRIPE_SECRET=',
                    ]);
                    break;
                case 'bkash':
                    $searchArray = array_merge($searchArray, [
                        'BKASH_MODE=' . env('BKASH_MODE'),
                        'BKASH_USERNAME=' . env('BKASH_USERNAME'),
                        'BKASH_PASSWORD=' . env('BKASH_PASSWORD'),
                        'BKASH_APP_KEY=' . env('BKASH_APP_KEY'),
                        'BKASH_APP_SECRET=' . env('BKASH_APP_SECRET'),
                        'SANDBOX=' . env('SANDBOX'),
                    ]);
                    $replaceArray = array_merge($replaceArray, [
                        'BKASH_MODE=',
                        'BKASH_USERNAME=',
                        'BKASH_PASSWORD=',
                        'BKASH_APP_KEY=',
                        'BKASH_APP_SECRET=',
                        'SANDBOX=',
                    ]);
                    break;
                case 'paypal':
                    $searchArray = array_merge($searchArray, [
                        'PAYPAL_CLIENT_ID=' . env('PAYPAL_CLIENT_ID'),
                        'PAYPAL_SECRET=' . env('PAYPAL_SECRET'),
                        'PAYPAL_MODE=' . env('PAYPAL_MODE'),
                        'PAYPAL_CURRENCY=' . env('PAYPAL_CURRENCY'),
                        'PAYPAL_APP_ID=' . env('PAYPAL_APP_ID'),
                    ]);
                    $replaceArray = array_merge($replaceArray, [
                        'PAYPAL_CLIENT_ID=',
                        'PAYPAL_SECRET=',
                        'PAYPAL_MODE=',
                        'PAYPAL_CURRENCY=',
                        'PAYPAL_APP_ID=',
                    ]);
                    break;
                case 'nagad':
                    $searchArray = array_merge($searchArray, [
                        'NAGAD_NUMBER=' . env('NAGAD_NUMBER'),
                    ]);
                    $replaceArray = array_merge($replaceArray, [
                        'NAGAD_NUMBER=',
                    ]);
                    break;
            }
        }

        // Apply replacement
        $newEnvContent = str_replace($searchArray, $replaceArray, $envContent);
        file_put_contents($path, $newEnvContent);

        if (in_array('sslcommerz', $selectedGateways) && isset($data['sslcommerz_account_id'])) {
            PaymentGatewayAccount::updateOrCreate(
                ['gateway' => 'sslcommerz'],
                ['account_id' => $data['sslcommerz_account_id']]
            );
        }
        if (in_array('paypal', $selectedGateways) && isset($data['paypal_account_id'])) {
            PaymentGatewayAccount::updateOrCreate(
                ['gateway' => 'paypal'],
                ['account_id' => $data['paypal_account_id']]
            );
        }

        if (in_array('bkash', $selectedGateways) && isset($data['bkash_account_id'])) {
            PaymentGatewayAccount::updateOrCreate(
                ['gateway' => 'bkash'],
                ['account_id' => $data['bkash_account_id']]
            );
        }

        if (in_array('stripe', $selectedGateways) && isset($data['stripe_account_id'])) {
            PaymentGatewayAccount::updateOrCreate(
                ['gateway' => 'stripe'],
                ['account_id' => $data['stripe_account_id']]
            );
        }




        return redirect()->back()->with('message', 'Payment gateway settings updated successfully!');
    }


    
    public function hrmSetting()
    {
        $lims_hrm_setting_data = HrmSetting::latest()->first();
        return view('setting.hrm_setting', compact('lims_hrm_setting_data'));
    }

    public function hrmSettingStore(Request $request)
    {
        $data = $request->all();
        $lims_hrm_setting_data = HrmSetting::firstOrNew(['id' => 1]);
        $lims_hrm_setting_data->checkin = $data['checkin'];
        $lims_hrm_setting_data->checkout = $data['checkout'];
        $lims_hrm_setting_data->save();
        return redirect()->back()->with('message', 'Data updated successfully');

    }
    public function posSetting()
    {
    	$lims_customer_list = Customer::where('is_active', true)->get();
        $lims_warehouse_list = Warehouse::where('is_active', true)->get();
        $lims_biller_list = Biller::where('is_active', true)->get();
        $lims_pos_setting_data = PosSetting::latest()->first();
        
    	return view('setting.pos_setting', compact('lims_customer_list', 'lims_warehouse_list', 'lims_biller_list', 'lims_pos_setting_data'));
    }

    public function posSettingStore(Request $request)
    {
        if(!env('USER_VERIFIED'))
            return redirect()->back()->with('not_permitted', 'This feature is disable for demo!');

    	$data = $request->all();
        //writting paypal info in .env file
        $path = '.env';
        $searchArray = array('PAYPAL_LIVE_API_USERNAME='.env('PAYPAL_LIVE_API_USERNAME'), 'PAYPAL_LIVE_API_PASSWORD='.env('PAYPAL_LIVE_API_PASSWORD'), 'PAYPAL_LIVE_API_SECRET='.env('PAYPAL_LIVE_API_SECRET') );

        $replaceArray = array('PAYPAL_LIVE_API_USERNAME='.$data['paypal_username'], 'PAYPAL_LIVE_API_PASSWORD='.$data['paypal_password'], 'PAYPAL_LIVE_API_SECRET='.$data['paypal_signature'] );

        file_put_contents($path, str_replace($searchArray, $replaceArray, file_get_contents($path)));

    	$pos_setting = PosSetting::firstOrNew(['id' => 1]);
    	$pos_setting->id = 1;
    	$pos_setting->customer_id = $data['customer_id'];
    	$pos_setting->warehouse_id = $data['warehouse_id'];
    	$pos_setting->biller_id = $data['biller_id'];
    	$pos_setting->product_number = $data['product_number'];
    	$pos_setting->stripe_public_key = $data['stripe_public_key'];
    	$pos_setting->stripe_secret_key = $data['stripe_secret_key'];
        if(!isset($data['keybord_active']))
            $pos_setting->keybord_active = false;
        else
            $pos_setting->keybord_active = true;
    	$pos_setting->save();
    	return redirect()->back()->with('message', 'POS setting updated successfully');
    }


    /*for seo*/

    public function site_settings()
    {
        $site_setting = SiteSetting::first();
        //dd($setting);
        return view('setting.site_settings', compact('site_setting'));
    }

    public function site_settings_store(Request $request)
    {
        $request->validate([
            'google_analytics_id' => 'nullable|string',
            'google_tag_manager_id' => 'nullable|string',
            'google_search_console_meta' => 'nullable|string',
            'bing_webmaster_meta' => 'nullable|string',
            'yandex_webmaster_meta' => 'nullable|string',
            'custom_head_scripts' => 'nullable|string',
            'custom_body_scripts' => 'nullable|string',
        ]);

        $site_setting = SiteSetting::first();

        if ($site_setting) {
            $site_setting->update($request->all());
        } else {
            SiteSetting::create($request->all());
        }


        return back()->with('success', 'Settings updated!');
    }
}
