<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use App\Review;
use Illuminate\Http\Request;
use App\Customer;
use Auth;

class ReviewController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $lims_review_all = Review::all();
        return view('review/index',compact('lims_review_all'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        /*dd($request->all());*/
        
        

        $review = new Review;
        $review->customer_name = $request->customer_name;
        $review->product_id = $request->product_id;
        $user = Auth::user();
        $customer = Customer::where('user_id', $user->id)->first();
        $review->customer_id = $customer->id;
        $review->details = $request->details;
        $review->stars = $request->stars;

        if ($request->hasFile('review_image')) {
            $path = $request->file('review_image')->store('public/images/review');
            $review->review_image = $path;
        }

        $review->save();

        if ($review) {
            return back()->with('success', 'Thank you for your review!');
        }

        return back()->withInput()->with('error', 'Error inserting review');
    }


    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(Review $review)
    {
        $review->delete();

        if($review){
            return back()
            ->with('success','You have successfully Deleted Review.');
        }

           return back()->with('error', 'Error Deliting Review'); 
    
    }
}
