<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use App\PayableLoan;
use App\PayableLoanInstallment;
use Illuminate\Validation\Rule;
use Auth;
use Spatie\Permission\Models\Role;
use Spatie\Permission\Models\Permission;
use App\Mail\UserNotification;
use Illuminate\Support\Facades\Mail;

class PayableLoanController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $role = Role::find(Auth::user()->role_id);
         $permissions = Role::findByName($role->name)->permissions;
            foreach ($permissions as $permission)
                $all_permission[] = $permission->name;
            if(empty($all_permission))
                $all_permission[] = 'dummy text';
        $lims_payable_loans = PayableLoan::all() ;
        return view('payable_loan.index',compact('lims_payable_loans', 'all_permission'));
        
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
      return view('payable_loan.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $lims_payable_loans = $request->all();
        
        PayableLoan::create($lims_payable_loans);
        $message = 'Data inserted successfully';
        
        return redirect('payable_loan')->with('message', $message);
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $lims_payable_loans = PayableLoan::where('id',$id)->first();
        return view('payable_loan.edit',compact('lims_payable_loans'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $input = $request->all();
        $lims_payable_loans = PayableLoan::findOrFail($id);
        $lims_payable_loans->update($input);
        //dd($lims_bankdeposit_data);
        return redirect('payable_loan')->with('message','Data updated successfully');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $lims_payable_loans = PayableLoan::findOrFail($id);
        $lims_payable_loans->delete();
        return redirect('payable_loan')->with('not_permitted','Data deleted successfully');
        
    }

    public function view_installment($id){
       
        /*dd($id);*/
        $lims_payment_list = PayableLoanInstallment::where('loan_id','=',$id)->get();
       
        $date = [];
        $paid_amount = [];
        $paying_method = [];
        $payment_id = [];
        $remark = [];
        
        
        foreach ($lims_payment_list as $payment) {
            $date[] = date(config('date_format'), strtotime($payment->created_at->toDateString())) . ' '. $payment->created_at->toTimeString();
            $paid_amount[] = $payment->amount;
            $paying_method[] = $payment->paying_method;
            $paying_amount[] = $payment->amount + $payment->change;
            $payment_id[] = $payment->id;
            $remark[] = $payment->remark;
           
        }
        $payments[] = $date;
        $payments[] = $paid_amount;
        $payments[] = $paying_method;
        $payments[] = $remark;
        $payments[] = $payment_id;
        

        return $payments;
    }

    public function pay_installment($id){
        
        $lims_payable_loans = PayableLoan::findOrFail($id);
        return view('payable_loan.pay_installment',compact('lims_payable_loans'));

    }

    public function installment_store(Request $request){

        $lims_payable_loans_installment = $request->all();
        
        PayableLoanInstallment::create($lims_payable_loans_installment);
        $message = 'Data inserted successfully';

        return redirect('payable_loan')->with('message', $message);
    }

    public function deleteInstallment(Request $request){
        $payable_loans_installment = PayableLoanInstallment::find($request->id);
        $payable_loans_installment->delete();
        $message = 'Installment deleted successfully';

        return redirect('payable_loan')->with('message', $message);

    }

    public function payable_loan_report(){
        
        $lims_payable_loans = PayableLoan::all();

        return view('report.payable_loan_report',compact('lims_payable_loans'));
    }

    public function payable_loan_details($id)
    {
        $lims_payable_loans = PayableLoanInstallment::where('loan_id', $id)->get();

        foreach ($lims_payable_loans as $key => $payable_loan) {

            $installments[0][$key] = $payable_loan->amount;
            $installments[1][$key] = $payable_loan->date;
            $installments[2][$key] = $payable_loan->remark;
            $installments[3][$key] = $payable_loan->payment_method;
            
        }
        return $installments;
    }
}
