<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Info;
class InfoController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $lims_user_data=Info::orderBy('id','desc')->first();
        
        return view('info/edit',compact('lims_user_data'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit(Info $info)
    {
         return view('info/edit', compact('info'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, Info $info)
    {
        // Retrieve the existing info
        $info = Info::find($info->id);

        // Update the text fields
        $info->phone = $request->phone;
        $info->mail = $request->mail;
        $info->address = $request->address;
        $info->facebook = $request->facebook;
        $info->moto = $request->moto;
        $info->extra_title = $request->extra_title;
        $info->extra_link = $request->extra_link;
        $info->ss1 = $request->ss1;
        $info->ss2 = $request->ss2;
        $info->ss3 = $request->ss3;
        // Update the image fields if provided
        /*foreach (['add_1', 'add_2', 'add_3', 'side_add', 'banner_add'] as $imageField) {
            if ($request->hasFile($imageField)) {
                $path = $request->file($imageField)->store('public/images');
                $info->$imageField = $path;
            }
        }*/

        // Save the updated info
        $info->save();

        // Redirect back with success message
        return redirect()->route('info.edit', $info->id)->with('success', 'Info updated successfully.');
    }


    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
