<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\DeliveryCharge;

class DeliveryChargeController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $deliveryCharges = DeliveryCharge::all();
        return view('delivery_charge.index', compact('deliveryCharges'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('delivery_charge.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $request->validate([
            'location' => 'required|string|max:255',
            'charge' => 'required|string|max:255',
        ]);

        $deliveryCharge = new DeliveryCharge();
        $deliveryCharge->location = $request->location;
        $deliveryCharge->charge = $request->charge;
        $deliveryCharge->save();

        return redirect()->route('dcs.index')->with('success', 'Delivery Charge created successfully.');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $deliveryCharge = DeliveryCharge::findOrFail($id);
        return view('delivery_charge.show', compact('deliveryCharge'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $deliveryCharge = DeliveryCharge::findOrFail($id);
        return view('delivery_charge.edit', compact('deliveryCharge'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $request->validate([
            'location' => 'required|string|max:255',
            'charge' => 'required|string|max:255',
        ]);

        $deliveryCharge = DeliveryCharge::findOrFail($id);
        $deliveryCharge->location = $request->location;
        $deliveryCharge->charge = $request->charge;
        $deliveryCharge->save();

        return redirect()->route('dcs.index')->with('success', 'Delivery Charge updated successfully.');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $deliveryCharge = DeliveryCharge::findOrFail($id);

        if ($deliveryCharge->delete()) {
            return redirect()->route('dcs.index')->with('success', 'Delivery Charge deleted successfully.');
        } else {
            return redirect()->route('dcs.index')->with('error', 'Error deleting Delivery Charge.');
        }
    }
}
