<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use App\Blog;
use Illuminate\Http\Request;
use App\BlogCat;

class BlogController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        $search = $request->input('search');
        $query = Blog::query();

        if ($search) {
            $query->where('title', 'LIKE', "%{$search}%");
        }
        $blogs_all = $query->paginate(10); // 10 items per 
        
        return view('blog/blog-list',compact('blogs_all','search'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $blog_cat=BlogCat::all();
        return view('blog/add-new-blog',compact('blog_cat'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        
        $request->validate([
            'title' => 'required',
            'description' => 'required',
        ]);

        // Store blog image
        $path = $request->file('image')->store('public/images/blogs');
        $authImagePath = $request->file('auth_img')->store('public/images/authors');
        //dd($path->all());
        // Initialize author image path
        

        $blogs = new Blog;
        $blogs->title = $request->title;
        $blogs->author = $request->author;
        $blogs->auth_img = $authImagePath;  // Save the author image path if it exists
        $blogs->video = $request->video;
        $blogs->description = $request->description;
        $blogs->cat_id = $request->cat_id;
        $blogs->image = $path;
        $blogs->save(); 

        if ($blogs) {
            return back()->with('success', 'You have successfully uploaded the file.');
        }

        return back()->withInput()->with('error', 'Error inserting blog'); 
    }


    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $blogs = Blog::find($id);
        $blog_cat=BlogCat::all();
        //dd($id);
        return view('blog/edit-blog',compact('blogs','blog_cat'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $blogs = Blog::find($id);

        $request->validate([
            'title' => 'required',
            'description' => 'required',
        ]);

        // Handle image upload
        if ($request->hasFile('image')) {
            $request->validate([
                'image' => 'image|mimes:jpg,png,jpeg,gif,svg|max:2048',
            ]);
            $path = $request->file('image')->store('public/images/blogs');
            $blogs->image = $path;
        }

        // Handle author image upload
        if ($request->hasFile('auth_img')) {
            $request->validate([
                'auth_img' => 'nullable|image|mimes:jpg,png,jpeg,gif,svg|max:2048',
            ]);
            $authImagePath = $request->file('auth_img')->store('public/images/authors');
            $blogs->auth_img = $authImagePath; // Update the author image path if it exists
        }

        $blogs->title = $request->title;
        $blogs->author = $request->author;
        $blogs->video = $request->video;
        $blogs->description = $request->description;
        $blogs->cat_id = $request->cat_id;
        $blogs->save(); 

        if ($blogs) {
            return back()->with('success', 'You have successfully updated the blog.');
        }

        return back()->withInput()->with('error', 'Error updating blog'); 
    }


    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $blogs = Blog::find($id);
        $blogs->delete();
        if($blogs){
            return back()
            ->with('success','You have successfully Deleted blogs.');
        }

           return back()->with('error', 'Error Deliting blogs'); 
    }
   

}

